/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.protocol.Encodable;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleDataResponse;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleIndexRequest;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleIndexResponse;
import org.apache.uniffle.common.netty.protocol.GetMemoryShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.GetMemoryShuffleDataResponse;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.netty.protocol.SendShuffleDataRequest;

public abstract class Message
implements Encodable {
    private ManagedBuffer body;

    protected Message() {
        this(null);
    }

    protected Message(ManagedBuffer body) {
        this.body = body;
    }

    public abstract Type type();

    public ManagedBuffer body() {
        return this.body;
    }

    public static Message decode(Type msgType, ByteBuf in) {
        switch (msgType) {
            case RPC_RESPONSE: {
                return RpcResponse.decode(in, false);
            }
            case SEND_SHUFFLE_DATA_REQUEST: {
                return SendShuffleDataRequest.decode(in);
            }
            case GET_LOCAL_SHUFFLE_DATA_REQUEST: {
                return GetLocalShuffleDataRequest.decode(in);
            }
            case GET_LOCAL_SHUFFLE_DATA_RESPONSE: {
                return GetLocalShuffleDataResponse.decode(in, true);
            }
            case GET_LOCAL_SHUFFLE_INDEX_REQUEST: {
                return GetLocalShuffleIndexRequest.decode(in);
            }
            case GET_LOCAL_SHUFFLE_INDEX_RESPONSE: {
                return GetLocalShuffleIndexResponse.decode(in, true);
            }
            case GET_MEMORY_SHUFFLE_DATA_REQUEST: {
                return GetMemoryShuffleDataRequest.decode(in);
            }
            case GET_MEMORY_SHUFFLE_DATA_RESPONSE: {
                return GetMemoryShuffleDataResponse.decode(in, true);
            }
        }
        throw new IllegalArgumentException("Unexpected message type: " + msgType);
    }

    public abstract long getRequestId();

    public static final class Type
    extends Enum<Type>
    implements Encodable {
        public static final /* enum */ Type UNKNOWN_TYPE = new Type(-1);
        public static final /* enum */ Type RPC_RESPONSE = new Type(0);
        public static final /* enum */ Type SHUFFLE_REGISTER_REQUEST = new Type(1);
        public static final /* enum */ Type SHUFFLE_UNREGISTER_REQUEST = new Type(2);
        public static final /* enum */ Type SEND_SHUFFLE_DATA_REQUEST = new Type(3);
        public static final /* enum */ Type GET_LOCAL_SHUFFLE_INDEX_REQUEST = new Type(4);
        public static final /* enum */ Type GET_LOCAL_SHUFFLE_DATA_REQUEST = new Type(5);
        public static final /* enum */ Type GET_MEMORY_SHUFFLE_DATA_REQUEST = new Type(6);
        public static final /* enum */ Type SHUFFLE_COMMIT_REQUEST = new Type(7);
        public static final /* enum */ Type REPORT_SHUFFLE_RESULT_REQUEST = new Type(8);
        public static final /* enum */ Type GET_SHUFFLE_RESULT_REQUEST = new Type(9);
        public static final /* enum */ Type GET_SHUFFLE_RESULT_FOR_MULTI_PART_REQUEST = new Type(10);
        public static final /* enum */ Type FINISH_SHUFFLE_REQUEST = new Type(11);
        public static final /* enum */ Type REQUIRE_BUFFER_REQUEST = new Type(12);
        public static final /* enum */ Type APP_HEART_BEAT_REQUEST = new Type(13);
        public static final /* enum */ Type GET_LOCAL_SHUFFLE_INDEX_RESPONSE = new Type(14);
        public static final /* enum */ Type GET_LOCAL_SHUFFLE_DATA_RESPONSE = new Type(15);
        public static final /* enum */ Type GET_MEMORY_SHUFFLE_DATA_RESPONSE = new Type(16);
        public static final /* enum */ Type SHUFFLE_COMMIT_RESPONSE = new Type(17);
        public static final /* enum */ Type GET_SHUFFLE_RESULT_RESPONSE = new Type(18);
        public static final /* enum */ Type GET_SHUFFLE_RESULT_FOR_MULTI_PART_RESPONSE = new Type(19);
        public static final /* enum */ Type REQUIRE_BUFFER_RESPONSE = new Type(20);
        private final byte id;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id) {
            assert (id < 128) : "Cannot have more than 128 message types";
            this.id = (byte)id;
        }

        public byte id() {
            return this.id;
        }

        @Override
        public int encodedLength() {
            return 1;
        }

        @Override
        public void encode(ByteBuf buf) {
            buf.writeByte((int)this.id);
        }

        public static Type decode(ByteBuf buf) {
            byte id = buf.readByte();
            switch (id) {
                case 0: {
                    return RPC_RESPONSE;
                }
                case 1: {
                    return SHUFFLE_REGISTER_REQUEST;
                }
                case 2: {
                    return SHUFFLE_UNREGISTER_REQUEST;
                }
                case 3: {
                    return SEND_SHUFFLE_DATA_REQUEST;
                }
                case 4: {
                    return GET_LOCAL_SHUFFLE_INDEX_REQUEST;
                }
                case 5: {
                    return GET_LOCAL_SHUFFLE_DATA_REQUEST;
                }
                case 6: {
                    return GET_MEMORY_SHUFFLE_DATA_REQUEST;
                }
                case 7: {
                    return SHUFFLE_COMMIT_REQUEST;
                }
                case 8: {
                    return REPORT_SHUFFLE_RESULT_REQUEST;
                }
                case 9: {
                    return GET_SHUFFLE_RESULT_REQUEST;
                }
                case 10: {
                    return GET_SHUFFLE_RESULT_FOR_MULTI_PART_REQUEST;
                }
                case 11: {
                    return FINISH_SHUFFLE_REQUEST;
                }
                case 12: {
                    return REQUIRE_BUFFER_REQUEST;
                }
                case 13: {
                    return APP_HEART_BEAT_REQUEST;
                }
                case 14: {
                    return GET_LOCAL_SHUFFLE_INDEX_RESPONSE;
                }
                case 15: {
                    return GET_LOCAL_SHUFFLE_DATA_RESPONSE;
                }
                case 16: {
                    return GET_MEMORY_SHUFFLE_DATA_RESPONSE;
                }
                case 17: {
                    return SHUFFLE_COMMIT_RESPONSE;
                }
                case 18: {
                    return GET_SHUFFLE_RESULT_RESPONSE;
                }
                case 19: {
                    return GET_SHUFFLE_RESULT_FOR_MULTI_PART_RESPONSE;
                }
                case 20: {
                    return REQUIRE_BUFFER_RESPONSE;
                }
                case -1: {
                    throw new IllegalArgumentException("User type messages cannot be decoded.");
                }
            }
            throw new IllegalArgumentException("Unknown message type: " + id);
        }

        static {
            $VALUES = new Type[]{UNKNOWN_TYPE, RPC_RESPONSE, SHUFFLE_REGISTER_REQUEST, SHUFFLE_UNREGISTER_REQUEST, SEND_SHUFFLE_DATA_REQUEST, GET_LOCAL_SHUFFLE_INDEX_REQUEST, GET_LOCAL_SHUFFLE_DATA_REQUEST, GET_MEMORY_SHUFFLE_DATA_REQUEST, SHUFFLE_COMMIT_REQUEST, REPORT_SHUFFLE_RESULT_REQUEST, GET_SHUFFLE_RESULT_REQUEST, GET_SHUFFLE_RESULT_FOR_MULTI_PART_REQUEST, FINISH_SHUFFLE_REQUEST, REQUIRE_BUFFER_REQUEST, APP_HEART_BEAT_REQUEST, GET_LOCAL_SHUFFLE_INDEX_RESPONSE, GET_LOCAL_SHUFFLE_DATA_RESPONSE, GET_MEMORY_SHUFFLE_DATA_RESPONSE, SHUFFLE_COMMIT_RESPONSE, GET_SHUFFLE_RESULT_RESPONSE, GET_SHUFFLE_RESULT_FOR_MULTI_PART_RESPONSE, REQUIRE_BUFFER_RESPONSE};
        }
    }
}

