/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.velocity.markup.html;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupCacheKeyProvider;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.resource.ResourceUtil;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.string.Strings;

public abstract class VelocityPanel
extends Panel
implements IMarkupResourceStreamProvider,
IMarkupCacheKeyProvider {
    private static final long serialVersionUID = 1L;
    private transient String stackTraceAsString;
    private transient String evaluatedTemplate;

    public static VelocityPanel forTemplateResource(String id, IModel<? extends Map> model, final IResourceStream templateResource) {
        if (templateResource == null) {
            throw new IllegalArgumentException("argument templateResource must be not null");
        }
        return new VelocityPanel(id, model){
            private static final long serialVersionUID = 1L;

            @Override
            protected IResourceStream getTemplateResource() {
                return templateResource;
            }
        };
    }

    public VelocityPanel(String id, IModel<? extends Map> model) {
        super(id, model);
    }

    private Reader getTemplateReader() {
        IResourceStream resource = this.getTemplateResource();
        if (resource == null) {
            throw new IllegalArgumentException("getTemplateResource must return a resource");
        }
        String template = ResourceUtil.readString((IResourceStream)resource);
        if (template != null) {
            return new StringReader(template);
        }
        return null;
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (!Strings.isEmpty((String)this.stackTraceAsString)) {
            this.replaceComponentTagBody(markupStream, openTag, Strings.toMultilineMarkup((CharSequence)this.stackTraceAsString));
        } else if (!this.parseGeneratedMarkup()) {
            if (this.size() > 0) {
                throw new WicketRuntimeException("Components cannot be added if the generated markup should not be parsed.");
            }
            if (this.evaluatedTemplate == null) {
                this.getMarkupResourceStream(null, null);
            }
            this.replaceComponentTagBody(markupStream, openTag, this.evaluatedTemplate);
        } else {
            super.onComponentTagBody(markupStream, openTag);
        }
    }

    private void onException(Exception exception) {
        if (this.throwVelocityExceptions()) {
            throw new WicketRuntimeException((Throwable)exception);
        }
        this.stackTraceAsString = Strings.toString((Throwable)exception);
    }

    protected boolean escapeHtml() {
        return false;
    }

    protected abstract IResourceStream getTemplateResource();

    private String evaluateVelocityTemplate(Reader templateReader) {
        if (this.evaluatedTemplate == null) {
            Map map = (Map)this.getDefaultModelObject();
            VelocityContext ctx = new VelocityContext(map);
            StringWriter writer = new StringWriter();
            String logTag = this.getId();
            try {
                Velocity.evaluate((Context)ctx, (Writer)writer, (String)logTag, (Reader)templateReader);
                this.evaluatedTemplate = writer.toString();
                if (this.escapeHtml()) {
                    this.evaluatedTemplate = Strings.escapeMarkup((CharSequence)this.evaluatedTemplate).toString();
                }
                return this.evaluatedTemplate;
            }
            catch (Exception e) {
                this.onException(e);
                return null;
            }
        }
        return this.evaluatedTemplate;
    }

    protected boolean parseGeneratedMarkup() {
        return false;
    }

    protected boolean throwVelocityExceptions() {
        return false;
    }

    public final IResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> containerClass) {
        Reader reader = this.getTemplateReader();
        if (reader == null) {
            throw new WicketRuntimeException("could not find velocity template for panel: " + this);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<wicket:panel>");
        sb.append(this.evaluateVelocityTemplate(reader));
        sb.append("</wicket:panel>");
        return new StringResourceStream((CharSequence)sb.toString());
    }

    public final String getCacheKey(MarkupContainer container, Class<?> containerClass) {
        return null;
    }

    protected void onDetach() {
        super.onDetach();
        this.stackTraceAsString = null;
        this.evaluatedTemplate = null;
    }
}

