/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.coep;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.util.lang.Args;

public class CrossOriginEmbedderPolicyConfiguration {
    private final Set<String> exemptions = new HashSet<String>();
    private final CoepMode mode;

    public CrossOriginEmbedderPolicyConfiguration(CoepMode mode, String ... exemptions) {
        this.exemptions.addAll(Arrays.asList(exemptions));
        this.mode = Args.notNull(mode, "mode");
    }

    public CrossOriginEmbedderPolicyConfiguration(CoepMode mode) {
        this.mode = Args.notNull(mode, "mode");
    }

    public Set<String> getExemptions() {
        return this.exemptions;
    }

    public CoepMode getMode() {
        return this.mode;
    }

    public String getCoepHeader() {
        return this.mode.header;
    }

    public CrossOriginEmbedderPolicyConfiguration addExemptedPath(String path) {
        this.exemptions.add(path);
        return this;
    }

    public boolean isEnabled() {
        return this.mode != CoepMode.DISABLED;
    }

    public static enum CoepMode {
        ENFORCING("Cross-Origin-Embedder-Policy"),
        REPORTING("Cross-Origin-Embedder-Policy-Report-Only"),
        DISABLED("");

        final String header;

        private CoepMode(String header) {
            this.header = header;
        }
    }
}

