/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.wicket.core.request.handler.ListenerRequestHandler;
import org.apache.wicket.core.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.ComponentInfo;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.info.PageInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.reference.ClassReference;
import org.apache.wicket.util.string.Strings;

public class MountedMapper
extends AbstractBookmarkableMapper {
    private final Supplier<Class<? extends IRequestablePage>> pageClassProvider;

    public MountedMapper(String mountPath, Class<? extends IRequestablePage> pageClass) {
        this(mountPath, pageClass, (IPageParametersEncoder)new PageParametersEncoder());
    }

    public MountedMapper(String mountPath, Supplier<Class<? extends IRequestablePage>> pageClassProvider) {
        this(mountPath, pageClassProvider, (IPageParametersEncoder)new PageParametersEncoder());
    }

    public MountedMapper(String mountPath, Class<? extends IRequestablePage> pageClass, IPageParametersEncoder pageParametersEncoder) {
        this(mountPath, new ClassReference<IRequestablePage>(pageClass), pageParametersEncoder);
    }

    public MountedMapper(String mountPath, Supplier<Class<? extends IRequestablePage>> pageClassProvider, IPageParametersEncoder pageParametersEncoder) {
        super(mountPath, pageParametersEncoder);
        Args.notNull(pageClassProvider, "pageClassProvider");
        this.pageClassProvider = pageClassProvider;
    }

    @Override
    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        Url url = request.getUrl();
        if (this.redirectFromHomePage() && this.checkHomePage(url)) {
            return new AbstractBookmarkableMapper.UrlInfo(null, this.getContext().getHomePageClass(), this.newPageParameters());
        }
        if (this.urlStartsWithMountedSegments(url)) {
            PageComponentInfo info = this.getPageComponentInfo(url);
            Class<? extends IRequestablePage> pageClass = this.getPageClass();
            PageParameters pageParameters = this.extractPageParameters(request, url);
            return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
        }
        return null;
    }

    @Override
    public Url mapHandler(IRequestHandler requestHandler) {
        ListenerRequestHandler handler;
        IRequestablePage page;
        Url url = super.mapHandler(requestHandler);
        if (url == null && requestHandler instanceof ListenerRequestHandler && this.getRecreateMountedPagesAfterExpiry() && this.checkPageInstance(page = (handler = (ListenerRequestHandler)requestHandler).getPage())) {
            Integer renderCount = null;
            if (handler.includeRenderCount()) {
                renderCount = page.getRenderCount();
            }
            String componentPath = handler.getComponentPath();
            PageInfo pageInfo = this.getPageInfo(handler);
            ComponentInfo componentInfo = new ComponentInfo(renderCount, componentPath, handler.getBehaviorIndex());
            PageComponentInfo pageComponentInfo = new PageComponentInfo(pageInfo, componentInfo);
            PageParameters parameters = this.newPageParameters();
            parameters.mergeWith(page.getPageParameters());
            AbstractBookmarkableMapper.UrlInfo urlInfo = new AbstractBookmarkableMapper.UrlInfo(pageComponentInfo, page.getClass(), parameters.mergeWith(handler.getPageParameters()));
            url = this.buildUrl(urlInfo);
        }
        return url;
    }

    @Override
    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Url url = new Url();
        for (String s : this.mountSegments) {
            url.getSegments().add(s);
        }
        this.encodePageComponentInfo(url, info.getPageComponentInfo());
        PageParameters copy = this.newPageParameters();
        copy.mergeWith(info.getPageParameters());
        if (!this.setPlaceholders(copy, url)) {
            return null;
        }
        return this.encodePageParameters(url, copy, this.pageParametersEncoder);
    }

    private boolean checkHomePage(Url url) {
        return url.getSegments().isEmpty() && url.getQueryParameters().isEmpty() && this.getPageClass().equals(this.getContext().getHomePageClass());
    }

    protected boolean redirectFromHomePage() {
        return true;
    }

    @Override
    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return false;
    }

    @Override
    protected boolean checkPageClass(Class<? extends IRequestablePage> pageClass) {
        return Objects.equals(pageClass, this.getPageClass());
    }

    private Class<? extends IRequestablePage> getPageClass() {
        return this.pageClassProvider.get();
    }

    public String toString() {
        return "MountedMapper [mountSegments=" + Strings.join("/", this.mountSegments) + "]";
    }
}

