/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.mock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.HttpHeaderCollection;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;

public class MockWebResponse
extends WebResponse {
    private final HttpHeaderCollection headers = new HttpHeaderCollection();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String redirectUrl;
    private String contentType;
    private Long contentLength;
    private StringBuilder textResponse;
    private ByteArrayOutputStream binaryResponse;
    private Integer status;
    private String errorMessage;

    @Override
    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    @Override
    public void clearCookie(Cookie cookie) {
        this.cookies.remove(cookie);
    }

    public List<Cookie> getCookies() {
        return Collections.unmodifiableList(this.cookies);
    }

    @Override
    public void sendRedirect(String url) {
        this.redirectUrl = url;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @Override
    public boolean isRedirect() {
        return this.redirectUrl != null;
    }

    @Override
    public void setContentLength(long length) {
        this.contentLength = length;
        this.setHeader("Content-Length", String.valueOf(length).intern());
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    public void setContentType(String mimeType) {
        this.contentType = mimeType;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setDateHeader(String name, Instant date) {
        Args.notNull(date, "date");
        this.headers.setDateHeader(name, date);
    }

    public Instant getDateHeader(String name) {
        Instant time = this.headers.getDateHeader(name);
        if (time == null) {
            throw new WicketRuntimeException("Date header '" + name + "' is not set.");
        }
        return time;
    }

    @Override
    public boolean isHeaderSupported() {
        return true;
    }

    @Override
    public void setHeader(String name, String value) {
        this.internalSetContentType(name, value);
        this.headers.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.internalSetContentType(name, value);
        this.headers.addHeader(name, value);
    }

    private void internalSetContentType(String name, String value) {
        if ("Content-Type".equalsIgnoreCase(name) && !this.headers.containsHeader(name)) {
            this.setContentType(value);
        }
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public boolean hasHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public Set<String> getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    @Override
    public void setStatus(int sc) {
        this.status = sc;
    }

    public Integer getStatus() {
        return this.status;
    }

    @Override
    public String encodeURL(CharSequence url) {
        return url.toString();
    }

    @Override
    public String encodeRedirectURL(CharSequence url) {
        return url.toString();
    }

    @Override
    public void write(CharSequence sequence) {
        if (this.binaryResponse != null) {
            throw new IllegalStateException("Binary response has already been initiated.");
        }
        if (this.textResponse == null) {
            this.textResponse = new StringBuilder();
        }
        this.textResponse.append(sequence);
    }

    public CharSequence getTextResponse() {
        return this.textResponse;
    }

    @Override
    public void write(byte[] array) {
        if (this.textResponse != null) {
            throw new IllegalStateException("Text response has already been initiated.");
        }
        if (this.binaryResponse == null) {
            this.binaryResponse = new ByteArrayOutputStream();
        }
        try {
            this.binaryResponse.write(array);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(byte[] array, int offset, int length) {
        if (this.textResponse != null) {
            throw new IllegalStateException("Text response has already been initiated.");
        }
        if (this.binaryResponse == null) {
            this.binaryResponse = new ByteArrayOutputStream();
        }
        this.binaryResponse.write(array, offset, length);
    }

    public byte[] getBinaryResponse() {
        if (this.binaryResponse == null) {
            return null;
        }
        byte[] bytes = this.binaryResponse.toByteArray();
        if (this.getContentLength() != null) {
            byte[] trimmed = new byte[this.getContentLength().intValue()];
            System.arraycopy(bytes, 0, trimmed, 0, this.getContentLength().intValue());
            return trimmed;
        }
        return bytes;
    }

    @Override
    public void sendError(int sc, String msg) {
        this.status = sc;
        this.errorMessage = msg;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void flush() {
    }

    @Override
    public void reset() {
        super.reset();
        if (this.binaryResponse != null) {
            this.binaryResponse = new ByteArrayOutputStream();
        }
        this.contentLength = null;
        this.contentType = null;
        if (this.cookies != null) {
            this.cookies.clear();
        }
        this.errorMessage = null;
        if (this.headers != null) {
            this.headers.clear();
        }
        this.redirectUrl = null;
        this.status = null;
        if (this.textResponse != null) {
            this.textResponse.setLength(0);
        }
    }

    @Override
    public Object getContainerResponse() {
        return this;
    }
}

