/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;

public class MultipartFormComponentListener
implements AjaxRequestTarget.IListener {
    static final String ENCTYPE_URL_ENCODED = "application/x-www-form-urlencoded";

    @Override
    public void onAfterRespond(Map<String, Component> map, AjaxRequestTarget target) {
        target.getPage().visitChildren(Form.class, (form, formVisitor) -> {
            if (form.isVisibleInHierarchy()) {
                form.visitFormComponents((formComponent, visit) -> {
                    if (formComponent.isMultiPart()) {
                        String enctype = form.isMultiPart() ? "multipart/form-data" : ENCTYPE_URL_ENCODED;
                        target.appendJavaScript(String.format("Wicket.$('%s').enctype='%s'", form.getMarkupId(), enctype));
                        visit.stop();
                    }
                });
            } else {
                formVisitor.dontGoDeeper();
            }
        });
    }
}

