/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.StringValue;

public class CombinedRequestParametersAdapter
implements IRequestParameters {
    private final IRequestParameters[] parameters;

    public CombinedRequestParametersAdapter(IRequestParameters ... parameters) {
        this.parameters = Args.notNull(parameters, "parameters");
    }

    @Override
    public Set<String> getParameterNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (IRequestParameters p : this.parameters) {
            result.addAll(p.getParameterNames());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public StringValue getParameterValue(String name) {
        for (IRequestParameters p : this.parameters) {
            StringValue value = p.getParameterValue(name);
            if (value.isNull()) continue;
            return value;
        }
        return StringValue.valueOf((String)null);
    }

    @Override
    public List<StringValue> getParameterValues(String name) {
        ArrayList<StringValue> result = new ArrayList<StringValue>();
        for (IRequestParameters p : this.parameters) {
            List<StringValue> values = p.getParameterValues(name);
            if (values == null) continue;
            for (StringValue v : values) {
                result.add(v);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(result);
    }
}

