/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.datetime;

import java.time.LocalDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.LocalDateTimeConverter;

public class LocalDateTimeTextField
extends TextField<LocalDateTime>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private final TextFormatConverter converter;

    public LocalDateTimeTextField(String id, IModel<LocalDateTime> model, final String dateTimePattern) {
        super(id, model, LocalDateTime.class);
        this.converter = new TextFormatConverter(){
            private static final long serialVersionUID = 1L;

            public DateTimeFormatter getDateTimeFormatter(Locale locale) {
                return DateTimeFormatter.ofPattern(dateTimePattern).withLocale(locale);
            }

            @Override
            public String getTextFormat(Locale locale) {
                return dateTimePattern;
            }
        };
    }

    public LocalDateTimeTextField(String id, String dateTimePattern) {
        this(id, null, dateTimePattern);
    }

    public LocalDateTimeTextField(String id, IModel<LocalDateTime> model, final FormatStyle dateStyle, final FormatStyle timeStyle) {
        super(id, model, LocalDateTime.class);
        this.converter = new TextFormatConverter(){
            private static final long serialVersionUID = 1L;

            public DateTimeFormatter getDateTimeFormatter(Locale locale) {
                return DateTimeFormatter.ofLocalizedDateTime(dateStyle, timeStyle).withLocale(locale);
            }

            @Override
            public String getTextFormat(Locale locale) {
                return DateTimeFormatterBuilder.getLocalizedDateTimePattern(dateStyle, timeStyle, IsoChronology.INSTANCE, locale);
            }
        };
    }

    public LocalDateTimeTextField(String id, FormatStyle dateStyle, FormatStyle timeStyle) {
        this(id, null, dateStyle, timeStyle);
    }

    protected IConverter<?> createConverter(Class<?> clazz) {
        if (LocalDateTime.class.isAssignableFrom(clazz)) {
            return this.converter;
        }
        return null;
    }

    public final String getTextFormat() {
        return this.converter.getTextFormat(this.getLocale());
    }

    private abstract class TextFormatConverter
    extends LocalDateTimeConverter {
        private static final long serialVersionUID = 1L;

        private TextFormatConverter() {
        }

        public abstract String getTextFormat(Locale var1);
    }
}

