/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.datetime;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.ClientInfo;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.util.lang.Args;

public class ZonedToLocalDateTimeModel
implements IModel<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    private IModel<ZonedDateTime> model;

    public ZonedToLocalDateTimeModel(IModel<ZonedDateTime> model) {
        Args.notNull(model, (String)"model");
        this.model = model;
    }

    public void detach() {
        this.model.detach();
    }

    protected ZoneId getClientTimeZone() {
        ClientInfo info = Session.get().getClientInfo();
        if (info instanceof WebClientInfo) {
            TimeZone timeZone = ((WebClientInfo)info).getProperties().getTimeZone();
            return timeZone != null ? timeZone.toZoneId() : null;
        }
        return ZoneId.systemDefault();
    }

    protected ZoneId getTargetTimeZone() {
        return ZoneId.systemDefault();
    }

    public LocalDateTime getObject() {
        ZonedDateTime zonedDateTime = (ZonedDateTime)this.model.getObject();
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.withZoneSameInstant(this.getClientTimeZone()).toLocalDateTime();
    }

    public void setObject(LocalDateTime dateTime) {
        if (dateTime == null) {
            this.model.setObject(null);
        } else {
            this.model.setObject((Object)dateTime.atZone(this.getClientTimeZone()).withZoneSameInstant(this.getTargetTimeZone()));
        }
    }
}

