/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.ResourceAggregator;
import org.apache.wicket.markup.html.IHeaderResponseDecorator;
import org.apache.wicket.util.lang.Args;

public class HeaderResponseDecoratorCollection
implements IHeaderResponseDecorator {
    private final List<IHeaderResponseDecorator> decorators = new CopyOnWriteArrayList<IHeaderResponseDecorator>();
    private IHeaderResponseDecorator resourceAggregation = ResourceAggregator::new;

    public HeaderResponseDecoratorCollection() {
        this.decorators.add(this.resourceAggregation);
    }

    public HeaderResponseDecoratorCollection add(IHeaderResponseDecorator decorator) {
        Args.notNull((Object)decorator, (String)"decorator");
        this.decorators.add(0, decorator);
        return this;
    }

    public HeaderResponseDecoratorCollection addPreResourceAggregationDecorator(IHeaderResponseDecorator decorator) {
        Args.notNull((Object)decorator, (String)"decorator");
        for (int i = 0; i < this.decorators.size(); ++i) {
            if (this.decorators.get(i) != this.resourceAggregation) continue;
            this.decorators.add(i, decorator);
            return this;
        }
        throw new IllegalStateException("no resource aggregation");
    }

    public HeaderResponseDecoratorCollection addPostProcessingDecorator(IHeaderResponseDecorator decorator) {
        Args.notNull((Object)decorator, (String)"decorator");
        this.decorators.add(decorator);
        return this;
    }

    public HeaderResponseDecoratorCollection replaceAll(IHeaderResponseDecorator decorator) {
        Args.notNull((Object)decorator, (String)"decorator");
        this.decorators.clear();
        this.resourceAggregation = null;
        this.decorators.add(decorator);
        return this;
    }

    @Override
    public IHeaderResponse decorate(IHeaderResponse response) {
        IHeaderResponse ret = response;
        for (IHeaderResponseDecorator curDecorator : this.decorators) {
            ret = curDecorator.decorate(ret);
        }
        return ret;
    }
}

