/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.ComponentNotFoundException;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.ILabelProvider;
import org.apache.wicket.markup.html.form.ILabelProviderLocator;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoLabelResolver
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AutoLabelResolver.class);
    static final String WICKET_FOR = ":for";
    static final String WICKET_AUTO = ":auto";
    public static final String LABEL_ATTR = "label_attr";
    public static final String CSS_REQUIRED_KEY = CssUtils.key(AutoLabel.class, "required");
    public static final String CSS_DISABLED_KEY = CssUtils.key(AutoLabel.class, "disabled");
    public static final String CSS_ERROR_KEY = CssUtils.key(AutoLabel.class, "error");
    private static final String CSS_DISABLED_DEFAULT = "disabled";
    private static final String CSS_REQUIRED_DEFAULT = "required";
    private static final String CSS_ERROR_DEFAULT = "error";
    public static final MetaDataKey<AutoLabelMarker> MARKER_KEY = new MetaDataKey<AutoLabelMarker>(){};

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (!tag.getId().startsWith(LABEL_ATTR)) {
            return null;
        }
        String path = tag.getAttribute(this.getWicketNamespace(markupStream) + WICKET_FOR).trim();
        Component component = AutoLabelResolver.findRelatedComponent(container, path);
        if (component == null) {
            throw new ComponentNotFoundException("Could not find form component with path '" + path + "' while trying to resolve wicket:for attribute");
        }
        if (component instanceof ILabelProviderLocator) {
            component = ((ILabelProviderLocator)((Object)component)).getAutoLabelComponent();
        }
        if (!(component instanceof ILabelProvider)) {
            throw new WicketRuntimeException("Component '" + (component == null ? "null" : component.getClass().getName()) + "', pointed to by wicket:for attribute '" + path + "', does not implement " + ILabelProvider.class.getName());
        }
        if (!component.getOutputMarkupId()) {
            component.setOutputMarkupId(true);
            if (component.hasBeenRendered()) {
                logger.warn("Component: {} is referenced via a wicket:for attribute but does not have its outputMarkupId property set to true", (Object)component.toString(false));
            }
        }
        if (component instanceof FormComponent) {
            String auto = tag.getAttribute(this.getWicketNamespace(markupStream) + WICKET_AUTO);
            boolean isAuto = Application.get().getMarkupSettings().isUpdateAutoLabelsTogetherWithFormComponent();
            isAuto = isAuto || !Strings.isEmpty((String)auto) && Boolean.parseBoolean(auto.trim());
            component.setMetaData(MARKER_KEY, new AutoLabelMarker((FormComponent)component, isAuto));
        }
        return new AutoLabel(tag.getId(), component);
    }

    private String getWicketNamespace(MarkupStream markupStream) {
        return markupStream.getWicketNamespace();
    }

    static Component findRelatedComponent(MarkupContainer container, final String path) {
        Component component = container.get(path);
        if (component != null) {
            return component;
        }
        final Component[] searched = new Component[]{null};
        while (container != null) {
            component = container.visitChildren(Component.class, new IVisitor<Component, Component>(){

                public void component(Component child, IVisit<Component> visit) {
                    if (child == searched[0]) {
                        visit.dontGoDeeper();
                        return;
                    }
                    if (path.equals(child.getId())) {
                        visit.stop((Object)child);
                        return;
                    }
                }
            });
            if (component != null) {
                return component;
            }
            searched[0] = container;
            container = container.getParent();
        }
        return null;
    }

    public static String getLabelIdFor(Component component) {
        return component.getMarkupId() + "-w-lbl";
    }

    protected static class AutoLabel
    extends TransparentWebMarkupContainer {
        private static final long serialVersionUID = 1L;
        private final Component component;

        public AutoLabel(String id, Component fc) {
            super(id);
            this.component = fc;
            this.setMarkupId(AutoLabelResolver.getLabelIdFor(this.component));
            this.setOutputMarkupId(true);
        }

        @Override
        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            tag.put("for", this.component.getMarkupId());
            if (this.component instanceof FormComponent) {
                FormComponent fc = (FormComponent)this.component;
                if (fc.isRequired()) {
                    tag.append("class", this.component.getString(CSS_REQUIRED_KEY, null, AutoLabelResolver.CSS_REQUIRED_DEFAULT), " ");
                }
                if (!fc.isValid()) {
                    tag.append("class", this.component.getString(CSS_ERROR_KEY, null, AutoLabelResolver.CSS_ERROR_DEFAULT), " ");
                }
            }
            if (!this.component.isEnabledInHierarchy()) {
                tag.append("class", this.component.getString(CSS_DISABLED_KEY, null, AutoLabelResolver.CSS_DISABLED_DEFAULT), " ");
            }
        }

        public Component getRelatedComponent() {
            return this.component;
        }
    }

    public static final class AutoLabelMarker
    implements Serializable {
        public static final short VALID = 1;
        public static final short REQUIRED = 2;
        public static final short ENABLED = 4;
        public static final short AUTO = 8;
        private short flags;

        public AutoLabelMarker(FormComponent<?> component) {
            this(component, false);
        }

        public AutoLabelMarker(FormComponent<?> component, boolean auto) {
            this.setFlag((short)1, component.isValid());
            this.setFlag((short)2, component.isRequired());
            this.setFlag((short)4, component.isEnabledInHierarchy());
            this.setFlag((short)8, auto);
        }

        @Deprecated(since="9.17.0, 10.0.0", forRemoval=true)
        public void updateFrom(FormComponent<?> component, AjaxRequestTarget target) {
            this.updateFrom(component, (IPartialPageRequestHandler)target);
        }

        public void updateFrom(FormComponent<?> component, IPartialPageRequestHandler target) {
            boolean valid = component.isValid();
            boolean required = component.isRequired();
            boolean enabled = component.isEnabledInHierarchy();
            if (this.isValid() != valid) {
                target.appendJavaScript(String.format("Wicket.DOM.toggleClass('%s', '%s', %s);", AutoLabelResolver.getLabelIdFor(component), component.getString(CSS_ERROR_KEY, null, AutoLabelResolver.CSS_ERROR_DEFAULT), !valid));
            }
            if (this.isRequired() != required) {
                target.appendJavaScript(String.format("Wicket.DOM.toggleClass('%s', '%s', %s);", AutoLabelResolver.getLabelIdFor(component), component.getString(CSS_REQUIRED_KEY, null, AutoLabelResolver.CSS_REQUIRED_DEFAULT), required));
            }
            if (this.isEnabled() != enabled) {
                target.appendJavaScript(String.format("Wicket.DOM.toggleClass('%s', '%s', %s);", AutoLabelResolver.getLabelIdFor(component), component.getString(CSS_DISABLED_KEY, null, AutoLabelResolver.CSS_DISABLED_DEFAULT), !enabled));
            }
            this.setFlag((short)1, valid);
            this.setFlag((short)2, required);
            this.setFlag((short)4, enabled);
        }

        public boolean isAuto() {
            return this.getFlag(8);
        }

        public boolean isValid() {
            return this.getFlag(1);
        }

        public boolean isEnabled() {
            return this.getFlag(4);
        }

        public boolean isRequired() {
            return this.getFlag(2);
        }

        private boolean getFlag(int flag) {
            return (this.flags & flag) != 0;
        }

        private void setFlag(short flag, boolean set) {
            this.flags = set ? (short)(this.flags | flag) : (short)(this.flags & ~flag);
        }
    }
}

