/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.form.AbstractCheckSelector;
import org.apache.wicket.markup.html.form.CheckGroup;

public class CheckGroupSelector
extends AbstractCheckSelector {
    private static final long serialVersionUID = 1L;
    private CheckGroup<?> group;

    public CheckGroupSelector(String id) {
        this(id, (CheckGroup<?>)null);
    }

    public CheckGroupSelector(String id, CheckGroup<?> group) {
        super(id);
        this.group = group;
    }

    private CheckGroup<?> getGroup() {
        CheckGroup group = this.group;
        if (group == null) {
            this.group = group = this.findParent(CheckGroup.class);
        }
        return group;
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        CheckGroup<?> group = this.getGroup();
        group.getForm().setOutputMarkupId(true);
    }

    @Override
    public boolean isEnabled() {
        CheckGroup<?> group = this.getGroup();
        if (group == null) {
            return true;
        }
        return group.isEnableAllowed() && group.isEnabledInHierarchy();
    }

    @Override
    protected CharSequence getFindCheckboxesFunction() {
        CheckGroup<?> group = this.getGroup();
        if (group == null) {
            throw new WicketRuntimeException("CheckGroupSelector component [" + this.getPath() + "] cannot find its parent CheckGroup. All CheckGroupSelector components must be a child of or below in the hierarchy of a CheckGroup component.");
        }
        return String.format("Wicket.CheckboxSelector.findCheckboxesFunction('%s','%s')", group.getForm().getMarkupId(), group.getInputName());
    }
}

