/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.XmlTag;

public class OpenCloseTagExpander
extends AbstractMarkupFilter {
    static final List<String> REPLACE_FOR_TAGS = Arrays.asList("a", "q", "sub", "sup", "abbr", "acronym", "cite", "code", "del", "dfn", "em", "ins", "kbd", "samp", "var", "label", "textarea", "tr", "td", "th", "caption", "thead", "tbody", "tfoot", "dl", "dt", "dd", "li", "ol", "ul", "h1", "h2", "h3", "h4", "h5", "h6", "i", "pre", "title", "div", "span", "p", "strong", "b", "e", "select", "article", "aside", "details", "summary", "figure", "figcaption", "footer", "header", "hgroup", "mark", "meter", "nav", "progress", "ruby", "rt", "rp", "section", "audio", "video", "canvas", "datalist", "output", "header-items");
    private ComponentTag next = null;

    @Override
    public MarkupElement nextElement() throws ParseException {
        if (this.next != null) {
            ComponentTag rtn = this.next;
            this.next = null;
            return rtn;
        }
        return super.nextElement();
    }

    @Override
    protected MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        String name;
        if (tag.isOpenClose() && this.contains(name = tag.getName()) && this.onFound(tag)) {
            this.next = new ComponentTag(tag.getName(), XmlTag.TagType.CLOSE);
            if (this.getWicketNamespace().equals(tag.getNamespace())) {
                this.next = new WicketTag(this.next);
            }
            this.next.setNamespace(tag.getNamespace());
            this.next.setOpenTag(tag);
            this.next.setModified(true);
        }
        return tag;
    }

    protected boolean onFound(ComponentTag tag) {
        tag.setType(XmlTag.TagType.OPEN);
        tag.setModified(true);
        return true;
    }

    protected boolean contains(String name) {
        return REPLACE_FOR_TAGS.contains(name.toLowerCase(Locale.ROOT));
    }
}

