/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.DelegatingPageStore;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;

public class CachingPageStore
extends DelegatingPageStore {
    private final IPageStore cache;

    public CachingPageStore(IPageStore delegate, IPageStore cache) {
        super(delegate);
        this.cache = cache;
    }

    public IPageStore getCache() {
        return this.cache;
    }

    @Override
    public IManageablePage getPage(IPageContext context, int id) {
        IManageablePage page = this.cache.getPage(context, id);
        if (page != null) {
            return page;
        }
        return this.getDelegate().getPage(context, id);
    }

    @Override
    public void addPage(IPageContext context, IManageablePage page) {
        this.cache.addPage(context, page);
        this.getDelegate().addPage(context, page);
    }

    @Override
    public void removePage(IPageContext context, IManageablePage page) {
        this.cache.removePage(context, page);
        this.getDelegate().removePage(context, page);
    }

    @Override
    public void removeAllPages(IPageContext context) {
        this.cache.removeAllPages(context);
        this.getDelegate().removeAllPages(context);
    }

    @Override
    public void revertPage(IPageContext context, IManageablePage page) {
        this.cache.revertPage(context, page);
        this.getDelegate().revertPage(context, page);
    }

    @Override
    public void detach(IPageContext context) {
        this.cache.detach(context);
        this.getDelegate().detach(context);
    }

    @Override
    public void destroy() {
        this.cache.destroy();
        this.getDelegate().destroy();
    }
}

