/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.Instant;
import javax.imageio.ImageIO;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.lang.Args;

public abstract class DynamicImageResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private String format = "png";
    private Instant lastModifiedTime;

    public DynamicImageResource() {
    }

    public DynamicImageResource(String format) {
        this.setFormat(format);
    }

    public final synchronized String getFormat() {
        return this.format;
    }

    public final synchronized void setFormat(String format) {
        Args.notNull((Object)format, (String)"format");
        this.format = format;
    }

    protected synchronized void setLastModifiedTime(Instant time) {
        this.lastModifiedTime = time;
    }

    protected byte[] toImageData(BufferedImage image) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, this.format, out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Unable to convert dynamic image to stream", e);
        }
    }

    protected abstract byte[] getImageData(IResource.Attributes var1);

    protected void configureResponse(AbstractResource.ResourceResponse response, IResource.Attributes attributes) {
    }

    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        if (this.lastModifiedTime != null) {
            response.setLastModified(this.lastModifiedTime);
        } else {
            response.setLastModified(Instant.now());
        }
        if (response.dataNeedsToBeWritten(attributes)) {
            response.setContentDisposition(ContentDisposition.INLINE);
            final byte[] imageData = this.getImageData(attributes);
            if (imageData == null) {
                response.setError(404);
            } else {
                response.setContentType("image/" + this.getFormat());
                response.setWriteCallback(new AbstractResource.WriteCallback(){

                    @Override
                    public void writeData(IResource.Attributes attributes) {
                        attributes.getResponse().write(imageData);
                    }
                });
                this.configureResponse(response, attributes);
            }
        }
        return response;
    }
}

