/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.util.regex.Pattern;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class PatternValidator
implements IValidator<String> {
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;
    private boolean reverse = false;

    public PatternValidator(String pattern) {
        this(Pattern.compile(pattern));
    }

    public PatternValidator(String pattern, int flags) {
        this(Pattern.compile(pattern, flags));
    }

    public PatternValidator(Pattern pattern) {
        this.pattern = pattern;
    }

    public PatternValidator(MetaPattern pattern) {
        this(pattern.pattern());
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public PatternValidator setReverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public String toString() {
        return "[PatternValidator pattern = " + this.pattern + "]";
    }

    @Override
    public void validate(IValidatable<String> validatable) {
        if (this.pattern.matcher(validatable.getValue()).matches() == this.reverse) {
            ValidationError error = new ValidationError(this);
            error.setVariable("pattern", this.pattern.pattern());
            validatable.error(this.decorate(error, validatable));
        }
    }

    protected IValidationError decorate(IValidationError error, IValidatable<String> validatable) {
        return error;
    }
}

