/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.ConstantPopulation;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.OldAbstractCoalescentLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Collections;
import java.util.List;

@Deprecated
public class SkylineLikelihood
extends OldAbstractCoalescentLikelihood
implements Citable {
    public static final String SKYLINE_LIKELIHOOD = "skyLineLikelihood";
    public static final String POPULATION_SIZES = "populationSizes";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("populationSizes", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("populationTree", new XMLSyntaxRule[]{new ElementRule(TreeModel.class)})};

        @Override
        public String getParserName() {
            return SkylineLikelihood.SKYLINE_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2 = xMLObject.getChild(SkylineLikelihood.POPULATION_SIZES);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild("populationTree");
            TreeModel treeModel = (TreeModel)xMLObject2.getChild(TreeModel.class);
            return new SkylineLikelihood((Tree)treeModel, parameter);
        }

        @Override
        public String getParserDescription() {
            return "This element represents the likelihood of the tree given the population size vector.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    Parameter popSizeParameter = null;
    public static Citation CITATION = new Citation(new Author[]{new Author("AJ", "Drummond"), new Author("A", "Rambaut"), new Author("B", "Shapiro"), new Author("OG", "Pybus")}, "Bayesian coalescent inference of past population dynamics from molecular sequences", 2005, "Mol Biol Evol", 22, 1185, 1192);

    public SkylineLikelihood(Tree tree, Parameter parameter) {
        super(SKYLINE_LIKELIHOOD);
        this.popSizeParameter = parameter;
        int n = tree.getExternalNodeCount();
        int n2 = parameter.getDimension();
        if (n - n2 != 1) {
            throw new IllegalArgumentException("Number of tips (" + n + ") must be one greater than number of pop sizes (" + n2 + ")");
        }
        this.tree = tree;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        this.addVariable(parameter);
        this.setupIntervals();
        this.addStatistic(new OldAbstractCoalescentLikelihood.DeltaStatistic());
    }

    @Override
    public double calculateLogLikelihood() {
        if (!this.intervalsKnown) {
            this.setupIntervals();
        }
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        ConstantPopulation constantPopulation = new ConstantPopulation(Units.Type.YEARS);
        for (int i = 0; i < this.intervalCount; ++i) {
            constantPopulation.setN0(this.popSizeParameter.getParameterValue(n));
            if (this.getIntervalType(i) == OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT) {
                ++n;
            }
            d += SkylineLikelihood.calculateIntervalLikelihood(constantPopulation, this.intervals[i], d2, this.lineageCounts[i], this.getIntervalType(i));
            int n2 = this.getCoalescentEvents(i) - 1;
            for (int j = 0; j < n2; ++j) {
                constantPopulation.setN0(this.popSizeParameter.getParameterValue(n));
                d += SkylineLikelihood.calculateIntervalLikelihood(constantPopulation, 0.0, d2, this.lineageCounts[i] - j - 1, OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT);
                ++n;
            }
            d2 += this.intervals[i];
        }
        return d;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Bayesian Skyline Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

