/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

@Deprecated
public abstract class AbstractTreeParameterModel<T>
extends AbstractModel
implements TreeTrait<T> {
    protected final TreeModel tree;
    protected final Parameter parameter;
    private int rootNodeNumber;
    private int storedRootNodeNumber;
    private boolean includeRoot = false;
    private boolean includeTips = true;
    private final TreeTrait.Intent intent;

    public AbstractTreeParameterModel(TreeModel treeModel, Parameter parameter, boolean bl, boolean bl2) {
        this(treeModel, parameter, bl, bl2, TreeTrait.Intent.BRANCH);
    }

    public AbstractTreeParameterModel(TreeModel treeModel, Parameter parameter, boolean bl, boolean bl2, TreeTrait.Intent intent) {
        super("treeParameterModel");
        this.tree = treeModel;
        this.parameter = parameter;
        this.includeRoot = bl;
        this.includeTips = bl2;
        this.intent = intent;
        int n = parameter.getDimension();
        int n2 = this.getParameterSize();
        if (n != n2) {
            parameter.setDimension(n2);
        }
        this.addModel(treeModel);
        this.addVariable(parameter);
        this.storedRootNodeNumber = this.rootNodeNumber = treeModel.getRoot().getNumber();
    }

    public abstract int getParameterSize();

    protected Parameter getParameter() {
        return this.parameter;
    }

    protected boolean checkNode(Tree tree, NodeRef nodeRef) {
        assert (!tree.isRoot(nodeRef) && !this.doesIncludeRoot()) : "root node doesn't have a parameter value!";
        assert (tree.getRoot().getNumber() == this.rootNodeNumber) : "INTERNAL ERROR! node with number " + this.rootNodeNumber + " should be the root node.";
        assert (!tree.isExternal(nodeRef) && !this.includeTips) : "tip nodes do not have parameter values!";
        return true;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree) {
            this.handleRootMove();
        }
    }

    protected boolean doesIncludeRoot() {
        return this.includeRoot;
    }

    protected boolean doesIncludeTips() {
        return this.includeTips;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        int n2 = this.getNodeNumberFromParameterIndex(n);
        assert (this.tree.getNode(n2).getNumber() == n2);
        this.fireModelChanged(variable, n2);
    }

    @Override
    protected void storeState() {
        this.storedRootNodeNumber = this.rootNodeNumber;
    }

    @Override
    protected void restoreState() {
        this.rootNodeNumber = this.storedRootNodeNumber;
    }

    @Override
    protected void acceptState() {
    }

    public abstract T getNodeValue(Tree var1, NodeRef var2);

    public abstract void setNodeValue(Tree var1, NodeRef var2, T var3);

    protected int getNodeNumberFromParameterIndex(int n) {
        int n2 = n;
        if (!this.includeRoot && n >= this.tree.getRoot().getNumber()) {
            ++n2;
        }
        if (!this.includeTips) {
            n2 += this.tree.getExternalNodeCount();
        }
        return n2;
    }

    protected int getParameterIndexFromNodeNumber(int n) {
        int n2 = n;
        if (!this.includeRoot && n > this.tree.getRoot().getNumber()) {
            --n2;
        }
        if (!this.includeTips) {
            n2 -= this.tree.getExternalNodeCount();
        }
        return n2;
    }

    private void handleRootMove() {
        if (!this.includeRoot) {
            int n = this.tree.getRoot().getNumber();
            if (this.rootNodeNumber > n) {
                double d = this.parameter.getParameterValue(n);
                int n2 = Math.min(this.parameter.getDimension() - 1, this.rootNodeNumber);
                for (int i = n; i < n2; ++i) {
                    this.parameter.setParameterValue(i, this.parameter.getParameterValue(i + 1));
                }
                this.parameter.setParameterValue(n2, d);
            } else if (this.rootNodeNumber < n) {
                int n3 = Math.min(this.parameter.getDimension() - 1, n);
                double d = this.parameter.getParameterValue(n3);
                for (int i = n3; i > this.rootNodeNumber; --i) {
                    this.parameter.setParameterValue(i, this.parameter.getParameterValue(i - 1));
                }
                this.parameter.setParameterValue(this.rootNodeNumber, d);
            }
            this.rootNodeNumber = n;
        }
    }

    public TreeModel getTreeModel() {
        return this.tree;
    }

    @Override
    public String getTraitName() {
        return this.parameter.getId();
    }

    @Override
    public TreeTrait.Intent getIntent() {
        return this.intent;
    }

    @Override
    public Class getTraitClass() {
        return Double.class;
    }

    @Override
    public boolean getLoggable() {
        return true;
    }

    @Override
    public abstract T getTrait(Tree var1, NodeRef var2);

    @Override
    public abstract String getTraitString(Tree var1, NodeRef var2);
}

