/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.arima.x13.OrderSpec;
import ec.tstoolkit.modelling.arima.x13.X13Exception;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Map;
import java.util.Objects;

public class AutoModelSpec
implements Cloneable,
InformationSetSerializable {
    public static final String ENABLED = "enabled";
    public static final String ACCEPTDEFAULT = "acceptdefault";
    public static final String MIXED = "mixed";
    public static final String BALANCED = "balanced";
    public static final String CHECKMU = "checkmu";
    public static final String HR = "hrinitial";
    public static final String LJUNGBOXLIMIT = "ljungboxlimit";
    public static final String REDUCECV = "reducecv";
    public static final String UB1 = "ub1";
    public static final String UB2 = "ub2";
    public static final String CANCEL = "cancel";
    public static final String ARMALIMIT = "armalimit";
    public static final String UBFINAL = "ubfinal";
    public static final String PERCENTRSE = "percentRSE";
    public static final String ARMA = "arma";
    public static final String DIFF = "diff";
    private boolean enabled_ = false;
    private OrderSpec diff_;
    private OrderSpec order_;
    private boolean acceptdef_ = false;
    private boolean checkmu_ = true;
    private boolean mixed_ = true;
    private boolean balanced_ = false;
    private boolean hr_ = false;
    private double cancel_ = 0.1;
    private double fct_ = 1.0126582278481011;
    private double pcr_ = 0.95;
    private double predcv_ = 0.14286;
    private double tsig_ = 1.0;
    private double ub1_ = 1.0416666666666667;
    private double ub2_ = 0.88;
    private double ubfinal_ = 1.05;
    public static final double DEF_LJUNGBOX = 0.95;
    public static final double DEF_TSIG = 1.0;
    public static final double DEF_PREDCV = 0.14286;
    public static final double DEF_UBFINAL = 1.05;
    public static final double DEF_UB1 = 1.0416666666666667;
    public static final double DEF_UB2 = 0.88;
    public static final double DEF_CANCEL = 0.1;
    public static final double DEF_FCT = 1.0126582278481011;
    public static final boolean DEF_ACCEPTDEF = false;
    public static final boolean DEF_CHECKMU = true;
    public static final boolean DEF_MIXED = true;
    public static final boolean DEF_BALANCED = false;
    public static final boolean DEF_HR = false;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, CANCEL), Double.class);
        dic.put(InformationSet.item(prefix, UB1), Double.class);
        dic.put(InformationSet.item(prefix, UB2), Double.class);
        dic.put(InformationSet.item(prefix, ARMALIMIT), Double.class);
        dic.put(InformationSet.item(prefix, UBFINAL), Double.class);
        dic.put(InformationSet.item(prefix, LJUNGBOXLIMIT), Double.class);
        dic.put(InformationSet.item(prefix, REDUCECV), Double.class);
        dic.put(InformationSet.item(prefix, PERCENTRSE), Double.class);
        dic.put(InformationSet.item(prefix, ENABLED), Boolean.class);
        dic.put(InformationSet.item(prefix, ACCEPTDEFAULT), Boolean.class);
        dic.put(InformationSet.item(prefix, MIXED), Boolean.class);
        dic.put(InformationSet.item(prefix, CHECKMU), Boolean.class);
        dic.put(InformationSet.item(prefix, BALANCED), Boolean.class);
        dic.put(InformationSet.item(prefix, HR), Boolean.class);
        OrderSpec.fillDictionary(InformationSet.item(prefix, ARMA), dic);
        OrderSpec.fillDictionary(InformationSet.item(prefix, DIFF), dic);
    }

    public AutoModelSpec() {
    }

    public AutoModelSpec(boolean enabled) {
        this.enabled_ = enabled;
    }

    public void reset() {
        this.diff_ = null;
        this.order_ = null;
        this.enabled_ = false;
        this.acceptdef_ = false;
        this.checkmu_ = true;
        this.mixed_ = true;
        this.balanced_ = false;
        this.hr_ = false;
        this.cancel_ = 0.1;
        this.fct_ = 1.0126582278481011;
        this.pcr_ = 0.95;
        this.predcv_ = 0.14286;
        this.tsig_ = 1.0;
        this.ub1_ = 1.0416666666666667;
        this.ub2_ = 0.88;
        this.ubfinal_ = 1.05;
    }

    public AutoModelSpec clone() {
        try {
            AutoModelSpec spec = (AutoModelSpec)super.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean isAcceptDefault() {
        return this.acceptdef_;
    }

    public void setAcceptDefault(boolean value) {
        this.acceptdef_ = value;
    }

    public boolean isCheckMu() {
        return this.checkmu_;
    }

    public void setCheckMu(boolean value) {
        this.checkmu_ = value;
    }

    public OrderSpec getArma() {
        return this.order_;
    }

    public void setArma(OrderSpec value) {
        this.order_ = value;
    }

    public OrderSpec getDiff() {
        return this.diff_;
    }

    public void setDiff(OrderSpec value) {
        this.diff_ = value;
    }

    public boolean isMixed() {
        return this.mixed_;
    }

    public void setMixed(boolean value) {
        this.mixed_ = value;
    }

    public double getLjungBoxLimit() {
        return this.pcr_;
    }

    public void setLjungBoxLimit(double value) {
        this.pcr_ = value;
    }

    public double getArmaSignificance() {
        return this.tsig_;
    }

    public void setArmaSignificance(double value) {
        if (value < 0.5) {
            throw new X13Exception("Arma T-value limit must be greater than .5");
        }
        this.tsig_ = value;
    }

    public double getPercentRSE() {
        return this.fct_;
    }

    public void setPercentRSE(double value) {
        if (value < 1.0) {
            throw new X13Exception("Must be greater than .5");
        }
        this.fct_ = value;
    }

    public boolean isBalanced() {
        return this.balanced_;
    }

    public void setBalanced(boolean value) {
        this.balanced_ = value;
    }

    public boolean isHannanRissannen() {
        return this.hr_;
    }

    public void setHannanRissanen(boolean value) {
        this.hr_ = value;
    }

    public double getPercentReductionCV() {
        return this.predcv_;
    }

    public void setPercentReductionCV(double value) {
        if (value < 0.05 || value > 0.3) {
            throw new X13Exception("Percent reduction of critical value must be in [0.05, .3]");
        }
        this.predcv_ = value;
    }

    public double getInitialUnitRootLimit() {
        return this.ub1_;
    }

    public void setInitialUnitRootLimit(double value) {
        if (value <= 1.0) {
            throw new X13Exception("Initial unit root limit must be greater than 1");
        }
        this.ub1_ = value;
    }

    public double getFinalUnitRootLimit() {
        return this.ub2_;
    }

    public void setFinalUnitRootLimit(double value) {
        if (value >= 1.0) {
            throw new X13Exception("Final unit root limit must be less than 1");
        }
        this.ub2_ = value;
    }

    public double getCancelationLimit() {
        return this.cancel_;
    }

    public void setCancelationLimit(double value) {
        if (value < 0.0 || value > 0.2) {
            throw new X13Exception("Cancelation limit must be in [0, .2]");
        }
        this.cancel_ = value;
    }

    public double getUnitRootLimit() {
        return this.ubfinal_;
    }

    public void setUnitRootLimit(double value) {
        if (value < 1.0) {
            throw new X13Exception("Unit root limit must be greater than 1");
        }
        this.ubfinal_ = value;
    }

    public boolean isDefault() {
        return !this.enabled_ && !this.acceptdef_ && this.diff_ == null && this.order_ == null && this.tsig_ == 1.0 && this.pcr_ == 0.95 && this.predcv_ == 0.14286 && this.ubfinal_ == 1.05 && this.checkmu_ && this.mixed_ && !this.balanced_ && this.cancel_ == 0.1 && this.fct_ == 1.0126582278481011 && this.ub1_ == 1.0416666666666667 && this.ub2_ == 0.88;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void setEnabled(boolean value) {
        this.enabled_ = value;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof AutoModelSpec && this.equals((AutoModelSpec)obj);
    }

    private boolean equals(AutoModelSpec other) {
        return this.enabled_ == other.enabled_ && this.acceptdef_ == other.acceptdef_ && Objects.equals(this.diff_, other.diff_) && Objects.equals(this.order_, other.order_) && this.balanced_ == other.balanced_ && this.checkmu_ == other.checkmu_ && this.mixed_ == other.mixed_ && this.hr_ == other.hr_ && this.tsig_ == other.tsig_ && this.pcr_ == other.pcr_ && this.predcv_ == other.predcv_ && this.ub1_ == other.ub1_ && this.ub2_ == other.ub2_ && this.cancel_ == other.cancel_ && this.ubfinal_ == other.ubfinal_ && this.fct_ == other.fct_;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Jdk6.Double.hashCode(this.pcr_);
        hash = 79 * hash + Jdk6.Double.hashCode(this.predcv_);
        hash = 79 * hash + Jdk6.Double.hashCode(this.tsig_);
        hash = 79 * hash + Jdk6.Double.hashCode(this.ubfinal_);
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet osinfo;
        InformationSet info = new InformationSet();
        info.add(ENABLED, Boolean.valueOf(this.enabled_));
        if (verbose || this.acceptdef_) {
            info.add(ACCEPTDEFAULT, Boolean.valueOf(this.acceptdef_));
        }
        if (verbose || !this.mixed_) {
            info.add(MIXED, Boolean.valueOf(this.mixed_));
        }
        if (verbose || this.balanced_) {
            info.add(BALANCED, Boolean.valueOf(this.balanced_));
        }
        if (verbose || this.hr_) {
            info.add(HR, Boolean.valueOf(this.hr_));
        }
        if (verbose || !this.checkmu_) {
            info.add(CHECKMU, Boolean.valueOf(this.checkmu_));
        }
        if (verbose || this.pcr_ != 0.95) {
            info.add(LJUNGBOXLIMIT, Double.valueOf(this.pcr_));
        }
        if (verbose || this.predcv_ != 0.14286) {
            info.add(REDUCECV, Double.valueOf(this.predcv_));
        }
        if (verbose || this.ub1_ != 1.0416666666666667) {
            info.add(UB1, Double.valueOf(this.ub1_));
        }
        if (verbose || this.ub2_ != 0.88) {
            info.add(UB2, Double.valueOf(this.ub2_));
        }
        if (verbose || this.cancel_ != 0.1) {
            info.add(CANCEL, Double.valueOf(this.cancel_));
        }
        if (verbose || this.tsig_ != 1.0) {
            info.add(ARMALIMIT, Double.valueOf(this.tsig_));
        }
        if (verbose || this.ubfinal_ != 1.05) {
            info.add(UBFINAL, Double.valueOf(this.ubfinal_));
        }
        if (verbose || this.fct_ != 1.0126582278481011) {
            info.add(PERCENTRSE, Double.valueOf(this.fct_));
        }
        if ((verbose || this.order_ != null) && this.order_ != null && (osinfo = this.order_.write(verbose)) != null) {
            info.add(ARMA, osinfo);
        }
        if ((verbose || this.diff_ != null) && this.diff_ != null && (osinfo = this.diff_.write(verbose)) != null) {
            info.add(DIFF, osinfo);
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            InformationSet osinfo;
            Double fct;
            Double ubf;
            Double tsig;
            Double cancel;
            Double ub2;
            Double ub1;
            Double pc;
            Double pcr;
            Boolean mu;
            Boolean hr;
            Boolean balanced;
            Boolean mixed;
            Boolean fal;
            this.reset();
            Boolean enabled = info.get(ENABLED, Boolean.class);
            if (enabled != null) {
                this.enabled_ = enabled;
            }
            if ((fal = info.get(ACCEPTDEFAULT, Boolean.class)) != null) {
                this.acceptdef_ = fal;
            }
            if ((mixed = info.get(MIXED, Boolean.class)) != null) {
                this.mixed_ = mixed;
            }
            if ((balanced = info.get(BALANCED, Boolean.class)) != null) {
                this.balanced_ = balanced;
            }
            if ((hr = info.get(HR, Boolean.class)) != null) {
                this.hr_ = hr;
            }
            if ((mu = info.get(CHECKMU, Boolean.class)) != null) {
                this.checkmu_ = mu;
            }
            if ((pcr = info.get(LJUNGBOXLIMIT, Double.class)) != null) {
                this.pcr_ = pcr;
            }
            if ((pc = info.get(REDUCECV, Double.class)) != null) {
                this.predcv_ = pc;
            }
            if ((ub1 = info.get(UB1, Double.class)) != null) {
                this.ub1_ = ub1;
            }
            if ((ub2 = info.get(UB2, Double.class)) != null) {
                this.ub2_ = ub2;
            }
            if ((cancel = info.get(CANCEL, Double.class)) != null) {
                this.cancel_ = cancel;
            }
            if ((tsig = info.get(ARMALIMIT, Double.class)) != null) {
                this.tsig_ = tsig;
            }
            if ((ubf = info.get(UBFINAL, Double.class)) != null) {
                this.ubfinal_ = ubf;
            }
            if ((fct = info.get(PERCENTRSE, Double.class)) != null) {
                this.fct_ = fct;
            }
            if ((osinfo = info.getSubSet(ARMA)) != null) {
                this.order_ = new OrderSpec(0, 0, OrderSpec.Type.Fixed);
                if (!this.order_.read(osinfo)) {
                    return false;
                }
            }
            if ((osinfo = info.getSubSet(DIFF)) != null) {
                this.diff_ = new OrderSpec(0, 0, OrderSpec.Type.Fixed);
                if (!this.diff_.read(osinfo)) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

