/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixStorage;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.BaseDiffuseSmoother;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.SmoothingResults;

public class DisturbanceSmoother
extends BaseDiffuseSmoother {
    private int m_nres;
    private int[] m_R;
    private DataBlock m_u;
    private Matrix m_uVar;
    private Matrix m_Q;
    private Matrix m_W;
    private Matrix m_WQ;
    private boolean m_qinit;
    private MatrixStorage m_P;
    private DataBlockStorage m_sres;
    private double[] m_smoothations;
    private double[] m_vsmoothations;

    public SmoothingResults calcSmoothedStates() {
        SmoothingResults sm = new SmoothingResults(true, false);
        sm.prepare(this.m_data.getCount(), this.m_r);
        DataBlock a = new DataBlock(this.m_r);
        Matrix Pf0 = new Matrix(this.m_r, this.m_r);
        this.m_ssf.Pf0(Pf0.subMatrix());
        a.product(Pf0.rows(), this.m_Rf);
        if (this.m_data.getInitialState() != null) {
            a.add(new DataBlock(this.m_data.getInitialState()));
        }
        if (this.m_ssf.isDiffuse()) {
            Matrix Pi0 = new Matrix(this.m_r, this.m_r);
            this.m_ssf.Pi0(Pi0.subMatrix());
            DataBlock ai = new DataBlock(this.m_r);
            ai.product(Pi0.rows(), this.m_Ri);
            a.add(ai);
        }
        int pos = 0;
        sm.save(pos, a, null, this.m_smoothations[pos], this.m_vsmoothations[pos]);
        while (++pos < this.m_data.getCount()) {
            DataBlock sres;
            this.m_ssf.TX(pos - 1, a);
            if (this.loadResInfo(pos - 1, false) && !(sres = this.m_sres.block(pos)).isZero()) {
                int i;
                if (this.m_W != null) {
                    int k;
                    double u;
                    if (this.m_R != null) {
                        for (i = 0; i < this.m_nres; ++i) {
                            u = sres.get(i);
                            for (k = 0; k < this.m_R.length; ++k) {
                                a.add(this.m_R[k], this.m_W.get(k, i) * u);
                            }
                        }
                    } else {
                        for (i = 0; i < this.m_nres; ++i) {
                            u = sres.get(i);
                            for (k = 0; k < this.m_r; ++k) {
                                a.add(k, this.m_W.get(k, i) * u);
                            }
                        }
                    }
                } else if (this.m_R != null) {
                    for (i = 0; i < this.m_R.length; ++i) {
                        a.add(this.m_R[i], sres.get(i));
                    }
                } else {
                    for (i = 0; i < this.m_r; ++i) {
                        a.add(i, sres.get(i));
                    }
                }
            }
            sm.save(pos, a, null, this.m_smoothations[pos], this.m_vsmoothations[pos]);
        }
        return sm;
    }

    @Override
    protected void clear() {
        super.clear();
        this.m_qinit = false;
        this.m_Q = null;
        this.m_R = null;
        this.m_W = null;
        this.m_WQ = null;
        this.m_uVar = null;
        this.clearResults();
    }

    protected void clearResults() {
        this.m_sres = null;
        this.m_P = null;
    }

    public double[] getSmoothations() {
        return this.m_smoothations;
    }

    public double[] getSmoothationsVariance() {
        return this.m_vsmoothations;
    }

    @Override
    protected void initSmoother() {
        super.initSmoother();
        this.m_nres = this.m_ssf.getTransitionResDim();
        this.m_u = new DataBlock(this.m_nres);
        int rescount = this.m_ssf.getTransitionResCount();
        int resdim = this.m_ssf.getTransitionResDim();
        if (this.m_ssf.hasR()) {
            this.m_R = new int[rescount];
        }
        if (this.m_ssf.hasW()) {
            this.m_W = new Matrix(rescount, resdim);
        }
        this.m_Q = new Matrix(resdim, resdim);
        this.prepareResults();
    }

    protected void iterateSmoother() {
        if (this.m_pos >= this.m_enddiffuse) {
            this.iterateR();
            if (this.m_bCalcVar) {
                this.iterateN();
            }
        } else {
            this.iterateInitialR();
            if (this.m_bCalcVar) {
                this.iterateInitialN();
            }
        }
        if (this.m_pos > 0 && this.loadResInfo(this.m_pos - 1, true)) {
            this.iterateU();
            if (this.m_bCalcVar) {
                this.iterateUVar();
            }
        } else {
            this.m_u.set(0.0);
            if (this.m_bCalcVar) {
                this.m_uVar.subMatrix().set(0.0);
            }
        }
    }

    protected void iterateU() {
        if (this.m_R != null) {
            for (int i = 0; i < this.m_u.getLength(); ++i) {
                double u = 0.0;
                for (int j = 0; j < this.m_R.length; ++j) {
                    u += this.m_Rf.get(this.m_R[j]) * this.m_WQ.get(j, i);
                }
                this.m_u.set(i, u);
            }
        } else {
            for (int i = 0; i < this.m_u.getLength(); ++i) {
                double u = 0.0;
                for (int j = 0; j < this.m_r; ++j) {
                    u += this.m_Rf.get(j) * this.m_WQ.get(j, i);
                }
                this.m_u.set(i, u);
            }
        }
    }

    protected void iterateUVar() {
        if (this.m_R != null) {
            Matrix N = new Matrix(this.m_R.length, this.m_R.length);
            for (int i = 0; i < this.m_R.length; ++i) {
                for (int j = 0; j < this.m_R.length; ++j) {
                    N.set(i, j, this.m_Nf.get(this.m_R[i], this.m_R[j]));
                }
            }
            this.m_uVar = SymmetricMatrix.quadraticForm(N, this.m_WQ);
        } else {
            this.m_uVar = SymmetricMatrix.quadraticForm(this.m_Nf, this.m_WQ);
        }
        this.m_uVar.chs();
        this.m_uVar.add(this.m_Q);
    }

    private boolean loadResInfo(int pos, boolean wq) {
        if (!this.m_ssf.hasTransitionRes(pos)) {
            return false;
        }
        if (this.m_qinit) {
            return true;
        }
        if (this.m_ssf.isTransitionResidualTimeInvariant()) {
            this.m_qinit = true;
        }
        if (this.m_R != null) {
            SubArrayOfInt R = SubArrayOfInt.create(this.m_R);
            R.set(0);
            this.m_ssf.R(pos, R);
        }
        if (this.m_W != null) {
            this.m_W.set(0.0);
            this.m_ssf.W(pos, this.m_W.subMatrix());
        }
        if (wq) {
            this.m_Q.set(0.0);
            this.m_ssf.Q(this.m_pos - 1, this.m_Q.subMatrix());
            this.m_WQ = this.m_W != null ? this.m_W.times(this.m_Q) : this.m_Q.clone();
        }
        return true;
    }

    protected void prepareResults() {
        int n = this.m_data.getCount();
        this.clearResults();
        if (this.m_nres > 0) {
            this.m_sres = new DataBlockStorage(this.m_nres, n);
        }
        if (this.m_bCalcVar && this.m_nres > 0) {
            this.m_P = new MatrixStorage(this.m_nres, n);
        }
        this.m_smoothations = new double[n];
        this.m_vsmoothations = new double[n];
    }

    public boolean process(ISsfData data) {
        return this.process(data, null);
    }

    public boolean process(ISsfData data, DiffuseFilteringResults frslts) {
        this.clear();
        if (this.m_ssf == null) {
            return false;
        }
        this.m_frslts = null;
        if (frslts == null) {
            frslts = new DiffuseFilteringResults(true);
            Filter<ISsf> filter = new Filter<ISsf>();
            filter.setSsf(this.m_ssf);
            if (!filter.process(data, frslts)) {
                return false;
            }
        }
        this.m_frslts = frslts;
        this.m_data = data;
        this.initSmoother();
        if (this.m_ssf.isTimeInvariant()) {
            this.loadModelInfo();
        }
        while (this.m_pos >= 0) {
            if (!this.m_ssf.isTimeInvariant() || this.m_pos == this.m_enddiffuse - 1) {
                this.loadModelInfo();
            }
            this.loadInfo();
            this.iterateSmoother();
            this.saveResults();
            --this.m_pos;
        }
        return true;
    }

    protected void saveResults() {
        if (this.m_uVar != null) {
            this.m_P.save(this.m_pos, this.m_uVar);
        }
        this.m_sres.save(this.m_pos, this.m_u);
        this.m_smoothations[this.m_pos] = this.m_c;
        this.m_vsmoothations[this.m_pos] = this.m_cvar;
    }

    public DataBlock sdisturbances(int t) {
        return this.m_sres.block(t);
    }

    public double[] smoothedSDisturbance(int idx, boolean bstudentized) {
        if (this.m_sres == null || this.m_P == null && bstudentized) {
            return null;
        }
        double[] c = new double[this.m_data.getCount()];
        if (!bstudentized) {
            for (int i = 0; i < c.length; ++i) {
                c[i] = this.m_sres.block(i).get(idx);
            }
        } else {
            for (int i = 0; i < c.length; ++i) {
                c[i] = this.m_sres.block(i).get(idx) / Math.sqrt(this.m_P.matrix(i).get(idx, idx));
            }
        }
        return c;
    }

    public SubMatrix svar(int t) {
        return this.m_P.matrix(t);
    }
}

