/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.gann;

import java.util.Vector;
import keel.Algorithms.Neural_Networks.gann.Data;
import keel.Algorithms.Neural_Networks.gann.Network;
import keel.Algorithms.Neural_Networks.gann.OpenDataset;
import keel.Algorithms.Neural_Networks.gann.SetupParameters;
import org.core.Randomize;

public class Genesis {
    public static void main(String[] args) {
        if (args.length <= 0) {
            System.err.println("No parameters file");
            System.exit(1);
        }
        SetupParameters global = new SetupParameters();
        global.LoadParameters(args[0]);
        OpenDataset train = new OpenDataset();
        OpenDataset test = null;
        OpenDataset validation = null;
        train.processClassifierDataset(global.train_file, true);
        global.n_test_patterns = 0;
        global.n_train_patterns = train.getndatos();
        if (global.test_data) {
            test = new OpenDataset();
            test.processClassifierDataset(global.test_file, false);
            global.n_test_patterns = test.getndatos();
        }
        global.n_val_patterns = 0;
        if (global.val_data) {
            validation = new OpenDataset();
            validation.processClassifierDataset(global.val_file, false);
            global.n_val_patterns = validation.getndatos();
        }
        global.Ninputs = 0;
        for (int i = 0; i < train.getnentradas(); ++i) {
            if (train.getTiposAt(i) == 0) {
                Vector in_values = train.getRangosVar(i);
                global.Ninputs += in_values.size();
                continue;
            }
            ++global.Ninputs;
        }
        if (train.getTiposAt(train.getnentradas()) != 0) {
            global.Noutputs = train.getnsalidas();
        } else {
            Vector out_values = train.getRangosVar(train.getnentradas());
            global.Noutputs = out_values.size();
        }
        Data data = new Data(global.Ninputs + global.Noutputs, global.n_train_patterns, global.n_test_patterns, global.n_val_patterns);
        global.Nhidden[global.Nhidden_layers] = global.Noutputs;
        Genesis.DatasetToArray(data.train, train);
        if (global.test_data) {
            Genesis.DatasetToArray(data.test, test);
        }
        if (global.val_data) {
            Genesis.DatasetToArray(data.validation, validation);
        }
        if (global.tipify_inputs) {
            data.TipifyInputData(global);
        }
        if (global.transfer[global.Nhidden_layers].compareToIgnoreCase("Htan") == 0 && global.problem.compareToIgnoreCase("Classification") == 0) {
            int j;
            int i;
            for (i = 0; i < global.n_train_patterns; ++i) {
                for (j = 0; j < global.Noutputs; ++j) {
                    if (data.train[i][j + global.Ninputs] != 0.0) continue;
                    data.train[i][j + global.Ninputs] = -1.0;
                }
            }
            if (global.test_data) {
                for (i = 0; i < global.n_test_patterns; ++i) {
                    for (j = 0; j < global.Noutputs; ++j) {
                        if (data.test[i][j + global.Ninputs] != 0.0) continue;
                        data.test[i][j + global.Ninputs] = -1.0;
                    }
                }
            }
            if (global.val_data) {
                for (i = 0; i < global.n_val_patterns; ++i) {
                    for (j = 0; j < global.Noutputs; ++j) {
                        if (data.validation[i][j + global.Ninputs] != 0.0) continue;
                        data.validation[i][j + global.Ninputs] = -1.0;
                    }
                }
            }
        }
        if (global.problem.compareToIgnoreCase("Regression") == 0) {
            double ubound = 1.0;
            double lbound = global.transfer[global.Nhidden_layers].compareToIgnoreCase("Log") == 0 ? 0.0 : -1.0;
            data.ScaleOutputData(global, lbound, ubound);
        }
        Network neural = new Network(global);
        if (global.verbose) {
            neural.PrintWeights();
        }
        if (global.cross_validation) {
            neural.TrainNetworkWithCrossvalidation(global, data);
        } else {
            neural.TrainNetwork(global, data.train, global.n_train_patterns);
        }
        if (global.save) {
            neural.SaveNetwork("network", false);
        }
        if (global.verbose) {
            neural.PrintWeights();
            double res = neural.TestNetworkInClassification(global, data.train, global.n_train_patterns);
            System.out.println("Final network training accuracy: " + 100.0 * res);
            if (global.val_data) {
                res = neural.TestNetworkInClassification(global, data.validation, global.n_val_patterns);
                System.out.println("Final network validation accuracy: " + 100.0 * res);
            }
            if (global.test_data) {
                res = neural.TestNetworkInClassification(global, data.test, global.n_test_patterns);
                System.out.println("Final network test accuracy: " + 100.0 * res);
            }
        }
        neural.SaveOutputFile(global.train_output, data.train, global.n_train_patterns, global.problem);
        if (global.test_data) {
            neural.SaveOutputFile(global.test_output, data.test, global.n_test_patterns, global.problem);
        }
    }

    public static void DatasetToArray(double[][] array, OpenDataset dataset) {
        int pos2 = 0;
        for (int i = 0; i < dataset.getndatos(); ++i) {
            int k;
            String[] cats;
            String line = dataset.getDatosAt(i);
            int pos1 = 1;
            int offset = 0;
            for (int j = 0; j < dataset.getnentradas(); ++j) {
                pos2 = line.indexOf(",", pos1);
                if (dataset.getTiposAt(j) == 0) {
                    Vector values = dataset.getRangosVar(j);
                    cats = new String[values.size()];
                    for (k = 0; k < values.size(); ++k) {
                        cats[k] = values.elementAt(k).toString();
                    }
                    for (k = 0; k < values.size(); ++k) {
                        array[i][offset + k] = line.substring(pos1, pos2).compareToIgnoreCase(cats[k]) == 0 ? 1.0 : 0.0;
                    }
                    offset += values.size();
                } else {
                    try {
                        array[i][offset] = Double.parseDouble(line.substring(pos1, pos2));
                    }
                    catch (NumberFormatException NumberFormatException2) {
                        array[i][offset] = 0.0;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                    ++offset;
                }
                pos1 = pos2 + 1;
            }
            pos1 = line.indexOf(",", pos2);
            String category = line.substring(pos1 + 1, line.length());
            if (dataset.getTiposAt(dataset.getnentradas()) != 0) {
                pos1 = 0;
                for (int k2 = 0; k2 < dataset.getnsalidas() - 1; ++k2) {
                    pos2 = category.indexOf(",", pos1);
                    array[i][offset + k2] = Double.parseDouble(category.substring(pos1, pos2));
                    pos1 = pos2 + 1;
                }
                try {
                    array[i][offset + dataset.getnsalidas() - 1] = Double.parseDouble(category.substring(pos1));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            Vector out_values = dataset.getRangosVar(dataset.getnentradas());
            cats = new String[out_values.size()];
            for (k = 0; k < out_values.size(); ++k) {
                cats[k] = out_values.elementAt(k).toString();
            }
            for (int j = 0; j < out_values.size(); ++j) {
                array[i][offset + j] = category.compareToIgnoreCase(cats[j]) == 0 ? 1.0 : 0.0;
            }
        }
    }

    public static double frandom(double min, double max) {
        return Randomize.Randdouble(min, max);
    }

    public static int irandom(double min, double max) {
        return (int)Randomize.Randdouble(min, max);
    }
}

