/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.IPLDE;

import java.util.ArrayList;
import java.util.Arrays;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class IPLDEGenerator
extends PrototypeGenerator {
    private int k;
    private int PopulationSize;
    private int ParticleSize;
    private int MaxIter;
    private int iterBasicDE;
    private double ScalingFactor;
    private double CrossOverRate;
    private int Strategy;
    private String CrossoverType;
    private double[] tau = new double[4];
    protected int numberOfClass;
    protected int numberOfPrototypes;
    private String[] paramsOfInitialReducction = null;
    private int iterSFGSS;
    private int iterSFHC;

    public IPLDEGenerator(PrototypeSet _trainingDataSet, int neigbors, int poblacion, int perc, int iteraciones, double F, double CR, int strg) {
        super(_trainingDataSet);
        this.algorithmName = "IPLDE";
        this.k = neigbors;
        this.PopulationSize = poblacion;
        this.ParticleSize = perc;
        this.MaxIter = iteraciones;
        this.numberOfPrototypes = this.getSetSizeFromPercentage(perc);
        this.ScalingFactor = F;
        this.CrossOverRate = CR;
        this.Strategy = strg;
    }

    public IPLDEGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "IPLDE";
        this.k = parameters.getNextAsInt();
        this.iterBasicDE = parameters.getNextAsInt();
        this.iterSFGSS = parameters.getNextAsInt();
        this.iterSFHC = parameters.getNextAsInt();
        this.ScalingFactor = parameters.getNextAsDouble();
        this.CrossOverRate = parameters.getNextAsDouble();
        this.tau[0] = parameters.getNextAsDouble();
        this.tau[1] = parameters.getNextAsDouble();
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.print("\nIsaac dice:  " + this.k + " Swar= " + this.PopulationSize + " Particle=  " + this.ParticleSize + " Maxiter= " + this.MaxIter + " CR=  " + this.CrossOverRate + " CrossverType = " + this.CrossoverType + "\n");
    }

    public PrototypeSet mutant(PrototypeSet population, double SFi) {
        PrototypeSet mutant = new PrototypeSet(population.clone());
        block6: for (int i = 0; i < population.size(); ++i) {
            PrototypeSet mismaClase = this.trainingDataSet.getFromClass(((Prototype)population.get(i)).getOutput(0));
            PrototypeSet aux = new PrototypeSet();
            if (mismaClase.size() < 5) {
                for (int j = mismaClase.size(); j < 5; ++j) {
                    Prototype Perturbance = new Prototype((Prototype)population.get(i));
                    for (int k = 0; k < Perturbance.numberOfInputs(); ++k) {
                        Perturbance.setInput(k, ((Prototype)population.get(i)).getInput(k) + RandomGenerator.Randdouble(-0.01 * (double)j, 0.01 * (double)j));
                    }
                    aux.add(Perturbance);
                }
                mismaClase.add(aux);
            }
            int[] lista = new int[mismaClase.size()];
            this.inic_vector_sin(lista, i);
            this.desordenar_vector_sin(lista);
            Prototype r1 = (Prototype)mismaClase.get(lista[0]);
            Prototype r2 = (Prototype)mismaClase.get(lista[1]);
            Prototype r3 = (Prototype)mismaClase.get(lista[2]);
            Prototype r4 = (Prototype)mismaClase.get(lista[3]);
            Prototype r5 = (Prototype)mismaClase.get(lista[4]);
            switch (this.Strategy) {
                case 1: {
                    Prototype resta = r2.sub(r3);
                    Prototype producto = resta.mul(SFi);
                    mutant.set(i, producto.add(r1));
                    continue block6;
                }
                case 2: {
                    Prototype resta = r1.sub(r2);
                    Prototype nearest = (Prototype)KNN.getNearestNeighborsWithSameClassAs((Prototype)population.get(i), this.trainingDataSet, 1).get(0);
                    Prototype resta2 = nearest.sub((Prototype)population.get(i));
                    Prototype producto = resta.mul(SFi);
                    Prototype producto2 = resta.mul(SFi);
                    producto = producto.add(producto2);
                    mutant.set(i, ((Prototype)population.get(i)).add(producto));
                    continue block6;
                }
                case 3: {
                    Prototype resta = r2.sub(r3);
                    Prototype resta2 = r1.sub((Prototype)population.get(i));
                    double aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
                    Prototype producto = resta.mul(SFi * aleatorio);
                    Prototype producto2 = resta2.mul(aleatorio);
                    producto = producto.add(producto2);
                    mutant.set(i, producto.add((Prototype)population.get(i)));
                    continue block6;
                }
                case 4: {
                    Prototype resta = r2.sub(r3);
                    Prototype resta2 = r4.sub(r5);
                    Prototype producto = resta.mul(SFi);
                    Prototype producto2 = resta2.mul(SFi);
                    producto = producto.add(producto2);
                    mutant.set(i, producto.add(r1));
                }
            }
        }
        mutant.applyThresholds();
        return mutant;
    }

    public double lsff(double Fi, double CRi, PrototypeSet population) {
        double FitnessFi = 0.0;
        PrototypeSet mutation = new PrototypeSet(population.size());
        mutation = this.mutant(population, Fi);
        PrototypeSet crossover = new PrototypeSet(mutation);
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(crossover);
        FitnessFi = IPLDEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
        return FitnessFi;
    }

    public PrototypeSet SFGSS(PrototypeSet population, double CRi) {
        double a = 0.1;
        double b = 1.0;
        double fi1 = 0.0;
        double fi2 = 0.0;
        double fitnessFi1 = 0.0;
        double fitnessFi2 = 0.0;
        double phi = (1.0 + Math.sqrt(5.0)) / 5.0;
        for (int i = 0; i < this.iterSFGSS; ++i) {
            fi1 = b - (b - a) / phi;
            fi2 = a + (b - a) / phi;
            fitnessFi1 = this.lsff(fi1, CRi, population);
            if (fitnessFi1 > (fitnessFi2 = this.lsff(fi2, CRi, population))) {
                b = fi2;
                continue;
            }
            a = fi1;
        }
        double scaling = fitnessFi1 > fitnessFi2 ? fi1 : fi2;
        PrototypeSet mutation = new PrototypeSet(population.size());
        mutation = this.mutant(population, scaling);
        PrototypeSet crossover = new PrototypeSet(mutation);
        return crossover;
    }

    public PrototypeSet SFHC(PrototypeSet population, double SFi, double CRi) {
        double h = 0.5;
        for (int i = 0; i < this.iterSFHC; ++i) {
            double bestFi;
            double fitnessFi1 = this.lsff(SFi - h, CRi, population);
            double fitnessFi2 = this.lsff(SFi, CRi, population);
            double fitnessFi3 = this.lsff(SFi + h, CRi, population);
            if (fitnessFi1 >= fitnessFi2 && fitnessFi1 >= fitnessFi3) {
                bestFi = SFi - h;
            } else if (fitnessFi2 >= fitnessFi1 && fitnessFi2 >= fitnessFi3) {
                bestFi = SFi;
                h /= 2.0;
            } else {
                bestFi = SFi;
            }
            SFi = bestFi;
        }
        PrototypeSet mutation = new PrototypeSet(population.size());
        mutation = this.mutant(population, SFi);
        PrototypeSet crossover = new PrototypeSet(mutation);
        return crossover;
    }

    public PrototypeSet basicDE(PrototypeSet myTrain) {
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(myTrain);
        double fitness = IPLDEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
        double[] randj = new double[5];
        for (int j = 0; j < 5; ++j) {
            randj[j] = RandomGenerator.Randdouble(0.0, 1.0);
        }
        for (int i = 0; i < this.iterBasicDE; ++i) {
            PrototypeSet modificados;
            block8: {
                block6: {
                    block7: {
                        modificados = new PrototypeSet(myTrain);
                        if (i % 1000 != 0) break block6;
                        if (!(randj[4] < this.tau[0])) break block7;
                        modificados = this.SFGSS(myTrain, this.CrossOverRate);
                        break block8;
                    }
                    if (!(this.tau[0] <= randj[4]) || !(randj[4] < this.tau[1])) break block8;
                    modificados = this.SFHC(myTrain, this.ScalingFactor, this.CrossOverRate);
                    break block8;
                }
                this.ScalingFactor = 0.1 + 0.9 * RandomGenerator.Randdouble(0.0, 1.0);
                for (int j = 0; j < myTrain.size(); ++j) {
                    PrototypeSet mismaClase = this.trainingDataSet.getFromClass(((Prototype)myTrain.get(j)).getOutput(0));
                    PrototypeSet aux = new PrototypeSet();
                    if (mismaClase.size() < 3) {
                        for (int l = mismaClase.size(); l < 5; ++l) {
                            Prototype Perturbance = new Prototype((Prototype)myTrain.get(j));
                            for (int k = 0; k < Perturbance.numberOfInputs(); ++k) {
                                Perturbance.setInput(k, ((Prototype)myTrain.get(j)).getInput(k) + RandomGenerator.Randdouble(-0.01 * (double)l, 0.01 * (double)l));
                            }
                            aux.add(Perturbance);
                        }
                        mismaClase.add(aux);
                    }
                    ArrayList<Integer> indexes = RandomGenerator.generateDifferentRandomIntegers(0, mismaClase.size() - 1);
                    Prototype r1 = (Prototype)mismaClase.get(indexes.get(0));
                    Prototype r2 = (Prototype)mismaClase.get(indexes.get(1));
                    Prototype r3 = (Prototype)mismaClase.get(indexes.get(2));
                    Prototype resta = r2.sub(r3);
                    Prototype resta2 = r1.sub((Prototype)myTrain.get(j));
                    double aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
                    Prototype producto = resta.mul(this.ScalingFactor * aleatorio);
                    Prototype producto2 = resta2.mul(aleatorio);
                    producto = producto.add(producto2);
                    Prototype crossover = producto.add((Prototype)myTrain.get(j));
                    crossover.applyThresholds();
                    modificados.set(j, crossover);
                }
            }
            nominalPopulation = new PrototypeSet();
            nominalPopulation.formatear(modificados);
            double trialFitness = IPLDEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
            if (!(trialFitness > fitness)) continue;
            fitness = trialFitness;
            myTrain = new PrototypeSet(modificados.clone());
        }
        return myTrain;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet nominalPopulation;
        System.out.print("\nThe algorithm  IPADE is starting...\n Computing...\n");
        this.Strategy = 3;
        PrototypeSet solucion = new PrototypeSet();
        PrototypeSet[] Clases = new PrototypeSet[this.numberOfClass];
        double[] fitnessClass = new double[this.numberOfClass];
        for (int i = 0; i < this.numberOfClass; ++i) {
            if (this.trainingDataSet.getFromClass(i).size() <= 0) continue;
            Clases[i] = new PrototypeSet(this.trainingDataSet.getFromClass(i).clone());
            System.out.println("Size ->" + Clases[i].size());
            Prototype centroid = Clases[i].avg();
            solucion.add(centroid);
        }
        solucion = this.basicDE(solucion);
        double Fitness = IPLDEGenerator.accuracy(solucion, this.trainingDataSet);
        boolean[] claseMarcada = new boolean[this.numberOfClass];
        boolean[] fin = new boolean[this.numberOfClass];
        Arrays.fill(claseMarcada, false);
        Arrays.fill(fin, true);
        int[] iterOptimizada = new int[this.numberOfClass];
        Arrays.fill(iterOptimizada, 1);
        int iter = 0;
        while (!Arrays.equals(claseMarcada, fin)) {
            double minFitness = Double.MAX_VALUE;
            int objetivo = -1;
            for (int j = 0; j < this.numberOfClass; ++j) {
                if (this.trainingDataSet.getFromClass(j).size() > 1) {
                    fitnessClass[j] = IPLDEGenerator.accuracy(solucion, this.trainingDataSet.getFromClass(j));
                    if (fitnessClass[j] < minFitness && !claseMarcada[j]) {
                        minFitness = fitnessClass[j];
                        objetivo = j;
                    }
                    if (fitnessClass[j] != 100.0) continue;
                    claseMarcada[j] = true;
                    continue;
                }
                claseMarcada[j] = true;
            }
            if (!claseMarcada[objetivo]) {
                PrototypeSet solucion2 = new PrototypeSet(solucion.clone());
                solucion2.add(this.trainingDataSet.farthestTo(solucion.getFromClass(objetivo).getRandom()));
                PrototypeSet tester = this.basicDE(solucion2).clone();
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(solucion);
                Fitness = IPLDEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(tester);
                double trialFitness = IPLDEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                if (trialFitness > Fitness) {
                    int n = objetivo;
                    iterOptimizada[n] = iterOptimizada[n] + 1;
                    solucion = new PrototypeSet(tester.clone());
                    Fitness = trialFitness;
                } else {
                    claseMarcada[objetivo] = true;
                }
            }
            ++iter;
        }
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(solucion);
        double trialFitness = IPLDEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
        System.out.println("Final Fitness = " + trialFitness);
        System.out.println("Reduction %, result set = " + (double)(this.trainingDataSet.size() - solucion.size()) * 100.0 / (double)this.trainingDataSet.size() + "\n");
        return solucion;
    }

    public static void main(String[] args) {
        Parameters.setUse("IPLDE", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        IPLDEGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "number of neighbors", 1.0, 2.147483647E9);
        int swarm = Parameters.assertExtendedArgAsInt(args, 4, "swarm size", 1.0, 2.147483647E9);
        int particle = Parameters.assertExtendedArgAsInt(args, 5, "particle size", 1.0, 2.147483647E9);
        int iter = Parameters.assertExtendedArgAsInt(args, 6, "max iter", 1.0, 2.147483647E9);
        IPLDEGenerator generator = new IPLDEGenerator(training, k, swarm, particle, iter, 0.5, 0.5, 1);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

