/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Eclat;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Eclat.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Eclat.EclatProcess;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Eclat.myDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Eclat.parseParameters;
import org.core.Files;

public class Eclat {
    private myDataset trans;
    private String rulesFilename;
    private String valuesFilename;
    private String valuesOrderFilename;
    private String fileTime;
    private String fileHora;
    private String namedataset;
    private EclatProcess proc;
    private ArrayList<AssociationRule> associationRules;
    private int nPartitionForNumericAttributes;
    private double minSupport;
    private double minConfidence;
    long startTime;
    long totalTime;
    private boolean somethingWrong = false;

    public Eclat() {
    }

    public Eclat(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.rulesFilename = parameters.getAssociationRulesFile();
        this.valuesFilename = parameters.getOutputFile(0);
        this.valuesOrderFilename = parameters.getOutputFile(1);
        this.fileTime = parameters.getOutputFile(0).substring(0, parameters.getOutputFile(0).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(0).substring(0, parameters.getOutputFile(0).lastIndexOf(47)) + "/hora.txt";
        this.nPartitionForNumericAttributes = Integer.parseInt(parameters.getParameter(0));
        try {
            System.out.println("\nReading the transaction set: " + parameters.getTransactionsInputFile());
            this.trans = new myDataset(this.nPartitionForNumericAttributes);
            this.trans.readDataSet(parameters.getTransactionsInputFile());
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input transaction set: " + e);
            this.somethingWrong = true;
        }
        this.minSupport = Double.parseDouble(parameters.getParameter(1));
        this.minConfidence = Double.parseDouble(parameters.getParameter(2));
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found");
            System.err.println("Aborting the program");
        } else {
            this.proc = new EclatProcess(this.trans, this.minSupport, this.minConfidence);
            this.proc.run();
            this.associationRules = this.proc.generateRulesSet();
            try {
                double[] step_values = this.trans.getSteps();
                PrintWriter rules_writer = new PrintWriter(this.rulesFilename);
                PrintWriter values_writer = new PrintWriter(this.valuesFilename);
                PrintWriter valuesOrder_writer = new PrintWriter(this.valuesOrderFilename);
                rules_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                rules_writer.println("<rules>");
                values_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                values_writer.println("<values>");
                valuesOrder_writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                valuesOrder_writer.println("<values>");
                valuesOrder_writer.print("Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\n");
                for (int r = 0; r < this.associationRules.size(); ++r) {
                    int i;
                    AssociationRule a_r = this.associationRules.get(r);
                    rules_writer.println("<rule id=\"" + r + "\">");
                    values_writer.println("<rule id=\"" + r + "\" rule_support=\"" + EclatProcess.roundDouble(a_r.getRuleSupport(), 2) + "\" antecedent_support=\"" + EclatProcess.roundDouble(a_r.getAntecedentSupport(), 2) + "\" consequent_support=\"" + EclatProcess.roundDouble(a_r.getConsequentSupport(), 2) + "\" confidence=\"" + EclatProcess.roundDouble(a_r.getConfidence(), 2) + "\" lift=\"" + EclatProcess.roundDouble(a_r.getLift(), 2) + "\" conviction=\"" + EclatProcess.roundDouble(a_r.getConv(), 2) + "\" certainFactor=\"" + EclatProcess.roundDouble(a_r.getCF(), 2) + "\" netConf=\"" + EclatProcess.roundDouble(a_r.getNetConf(), 2) + "\" yulesQ=\"" + EclatProcess.roundDouble(a_r.getYulesQ(), 2) + "\" nAttributes=\"" + (a_r.getAntecedent().size() + a_r.getConsequent().size()) + "\"/>");
                    rules_writer.println("<antecedents>");
                    ArrayList<Integer> terms = a_r.getAntecedent();
                    for (i = 0; i < terms.size(); ++i) {
                        this.createRule(terms.get(i), step_values, rules_writer);
                    }
                    rules_writer.println("</antecedents>");
                    rules_writer.println("<consequents>");
                    terms = a_r.getConsequent();
                    for (i = 0; i < terms.size(); ++i) {
                        this.createRule(terms.get(i), step_values, rules_writer);
                    }
                    rules_writer.println("</consequents>");
                    rules_writer.println("</rule>");
                    valuesOrder_writer.print(this.printRule(a_r));
                }
                rules_writer.println("</rules>");
                values_writer.println("</values>");
                valuesOrder_writer.print("</values>");
                rules_writer.close();
                values_writer.close();
                valuesOrder_writer.close();
                this.totalTime = System.currentTimeMillis() - this.startTime;
                this.writeTime();
                System.out.println("\nAlgorithm Finished");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public String printRule(AssociationRule rule) {
        String ruleString = "";
        int lenghtrule = rule.getAntecedent().size() + rule.getConsequent().size();
        ruleString = ruleString + "" + EclatProcess.roundDouble(rule.getRuleSupport(), 2) + "\t" + EclatProcess.roundDouble(rule.getAntecedentSupport(), 2) + "\t" + EclatProcess.roundDouble(rule.getConsequentSupport(), 2) + "\t" + EclatProcess.roundDouble(rule.getConfidence(), 2) + "\t" + EclatProcess.roundDouble(rule.getLift(), 2) + "\t" + EclatProcess.roundDouble(rule.getConv(), 2) + "\t" + EclatProcess.roundDouble(rule.getCF(), 2) + "\t" + EclatProcess.roundDouble(rule.getNetConf(), 2) + "\t" + EclatProcess.roundDouble(rule.getYulesQ(), 2) + "\t" + lenghtrule + "\n";
        return ruleString;
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.namedataset + this.rulesFilename + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.rulesFilename + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void createRule(int fake_value, double[] step_values, PrintWriter w) {
        int id_attr = fake_value % this.trans.getnVars();
        int true_value = (fake_value - id_attr) / this.trans.getnVars();
        w.print("<attribute name=\"" + this.trans.getAttributeName(id_attr) + "\" value=\"");
        if (this.trans.getAttributeType(id_attr) == 0) {
            w.print(this.trans.getNominalValue(id_attr, true_value));
        } else {
            w.print("[" + (this.trans.getMin(id_attr) + step_values[id_attr] * (double)true_value) + ", " + (this.trans.getMin(id_attr) + step_values[id_attr] * (double)(true_value + 1)) + "]");
        }
        w.println("\"/>");
    }
}

