/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import moa.cluster.Clustering;
import moa.evaluation.MeasureCollection;
import moa.evaluation.MembershipMatrix;
import moa.gui.visualization.DataPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntropyCollection
extends MeasureCollection {
    private boolean debug = false;
    private final double beta = 1.0;

    @Override
    protected String[] getNames() {
        String[] names = new String[]{"GT cross entropy", "FC cross entropy", "Homogeneity", "Completeness", "V-Measure", "VarInformation"};
        return names;
    }

    @Override
    protected boolean[] getDefaultEnabled() {
        boolean[] defaults = new boolean[]{false, false, false, false, false, false};
        return defaults;
    }

    @Override
    public void evaluateClustering(Clustering fclustering, Clustering hClustering, ArrayList<DataPoint> points) throws Exception {
        double homogeneity;
        MembershipMatrix mm = new MembershipMatrix(fclustering, points);
        int numClasses = mm.getNumClasses();
        int numCluster = fclustering.size() + 1;
        int n = mm.getTotalEntries();
        double FCentropy = 0.0;
        if (numCluster > 1) {
            for (int fc = 0; fc < numCluster; ++fc) {
                double weight = (double)mm.getClusterSum(fc) / (double)n;
                if (!(weight > 0.0)) continue;
                FCentropy += weight * Math.log10(weight);
            }
            FCentropy /= -1.0 * Math.log10(numCluster);
        }
        if (this.debug) {
            System.out.println("FC entropy " + FCentropy);
        }
        double GTentropy = 0.0;
        if (numClasses > 1) {
            for (int hc = 0; hc < numClasses; ++hc) {
                double weight = (double)mm.getClassSum(hc) / (double)n;
                if (!(weight > 0.0)) continue;
                GTentropy += weight * Math.log10(weight);
            }
            GTentropy /= -1.0 * Math.log10(numClasses);
        }
        if (this.debug) {
            System.out.println("GT entropy " + GTentropy);
        }
        double FCcrossEntropy = 0.0;
        for (int fc = 0; fc < numCluster; ++fc) {
            double e = 0.0;
            int clusterWeight = mm.getClusterSum(fc);
            if (clusterWeight <= 0) continue;
            for (int hc = 0; hc < numClasses; ++hc) {
                double p = (double)mm.getClusterClassWeight(fc, hc) / (double)clusterWeight;
                if (p == 0.0) continue;
                e += p * Math.log10(p);
            }
            FCcrossEntropy += (double)clusterWeight / (double)n * e;
        }
        if (numCluster > 1) {
            FCcrossEntropy /= -1.0 * Math.log10(numCluster);
        }
        this.addValue("FC cross entropy", 1.0 - FCcrossEntropy);
        if (this.debug) {
            System.out.println("FC cross entropy " + (1.0 - FCcrossEntropy));
        }
        double GTcrossEntropy = 0.0;
        for (int hc = 0; hc < numClasses; ++hc) {
            double e = 0.0;
            int classWeight = mm.getClassSum(hc);
            if (classWeight > 0) {
                for (int fc = 0; fc < numCluster; ++fc) {
                    double p = (double)mm.getClusterClassWeight(fc, hc) / (double)classWeight;
                    if (p == 0.0) continue;
                    e += p * Math.log10(p);
                }
            }
            GTcrossEntropy += (double)classWeight / (double)n * e;
        }
        if (numClasses > 1) {
            GTcrossEntropy /= -1.0 * Math.log10(numClasses);
        }
        this.addValue("GT cross entropy", 1.0 - GTcrossEntropy);
        if (this.debug) {
            System.out.println("GT cross entropy " + (1.0 - GTcrossEntropy));
        }
        if ((homogeneity = FCentropy == 0.0 ? 1.0 : 1.0 - FCcrossEntropy / FCentropy) > 1.0 || homogeneity < 0.0) {
            this.addValue("Homogeneity", -1.0);
        } else {
            this.addValue("Homogeneity", homogeneity);
        }
        double completeness = GTentropy == 0.0 ? 1.0 : 1.0 - GTcrossEntropy / GTentropy;
        this.addValue("Completeness", completeness);
        double vmeasure = 2.0 * homogeneity * completeness / (1.0 * homogeneity + completeness);
        if (vmeasure > 1.0 || homogeneity < 0.0) {
            this.addValue("V-Measure", -1.0);
        } else {
            this.addValue("V-Measure", vmeasure);
        }
        double mutual = 0.0;
        for (int i = 0; i < numCluster; ++i) {
            for (int j = 0; j < numClasses; ++j) {
                if (mm.getClusterClassWeight(i, j) == 0) continue;
                double m = Math.log10((double)mm.getClusterClassWeight(i, j) / (double)mm.getClusterSum(i) / (double)mm.getClassSum(j) * (double)n);
                m *= (double)mm.getClusterClassWeight(i, j) / (double)n;
                if (this.debug) {
                    System.out.println("(" + j + "/" + j + "): " + m);
                }
                mutual += m;
            }
        }
        if (numClasses > 1) {
            mutual /= Math.log10(numClasses);
        }
        double varInfo = 1.0;
        if (FCentropy + GTentropy > 0.0) {
            varInfo = 2.0 * mutual / (FCentropy + GTentropy);
        }
        if (this.debug) {
            System.out.println("mutual " + mutual + " / VI " + varInfo);
        }
        this.addValue("VarInformation", varInfo);
    }
}

