/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.CachedMetric;
import cc.mallet.types.SparseVector;
import java.util.HashMap;

public class NormalizedDotProductMetric
implements CachedMetric {
    HashMap hash = new HashMap();

    @Override
    public double distance(SparseVector a, SparseVector b) {
        double ret = a.dotProduct(b) / (a.twoNorm() * b.twoNorm());
        return 1.0 - ret;
    }

    @Override
    public double distance(SparseVector a, int hashCodeA, SparseVector b, int hashCodeB) {
        Double cachedA = (Double)this.hash.get(new Integer(hashCodeA));
        Double cachedB = (Double)this.hash.get(new Integer(hashCodeB));
        if (a == null || b == null) {
            return 1.0;
        }
        if (cachedA == null) {
            cachedA = new Double(a.dotProduct(a));
            this.hash.put(new Integer(hashCodeA), cachedA);
        }
        if (cachedB == null) {
            cachedB = new Double(b.dotProduct(b));
            this.hash.put(new Integer(hashCodeB), cachedB);
        }
        double ab = a.dotProduct(b);
        if (cachedA == null || cachedB == null) {
            throw new IllegalStateException("cachedValues null");
        }
        double ret = a.dotProduct(b) / Math.sqrt(cachedA * cachedB);
        return 1.0 - ret;
    }
}

