/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.RankingPathElement;
import org.jgrapht.alg.RankingPathElementList;

class KShortestPathsIterator<V, E>
implements Iterator<Set<V>> {
    private V endVertex;
    private Graph<V, E> graph;
    private int k;
    private Set<V> prevImprovedVertices;
    private Map<V, RankingPathElementList<V, E>> prevSeenDataContainer;
    private Map<V, RankingPathElementList<V, E>> seenDataContainer;
    private V startVertex;
    private boolean startVertexEncountered;

    public KShortestPathsIterator(Graph<V, E> graph, V v, V v2, int n) {
        this.assertKShortestPathsIterator(graph, v);
        this.graph = graph;
        this.startVertex = v;
        this.endVertex = v2;
        this.k = n;
        this.seenDataContainer = new HashMap<V, RankingPathElementList<V, E>>();
        this.prevSeenDataContainer = new HashMap<V, RankingPathElementList<V, E>>();
        this.prevImprovedVertices = new HashSet<V>();
    }

    @Override
    public boolean hasNext() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        return !this.prevImprovedVertices.isEmpty();
    }

    @Override
    public Set<V> next() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            HashSet hashSet = new HashSet();
            for (V v : this.prevImprovedVertices) {
                if (v.equals(this.endVertex)) continue;
                this.updateOutgoingVertices(v, hashSet);
            }
            this.savePassData(hashSet);
            return hashSet;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    RankingPathElementList<V, E> getPathElements(V v) {
        return this.seenDataContainer.get(v);
    }

    private void addFirstPath(V v, E e) {
        RankingPathElementList<V, E> rankingPathElementList = this.createSeenData(v, e);
        this.seenDataContainer.put((RankingPathElementList<V, E>)v, (RankingPathElementList<RankingPathElementList<V, E>, E>)rankingPathElementList);
    }

    private void assertKShortestPathsIterator(Graph<V, E> graph, V v) {
        if (graph == null) {
            throw new NullPointerException("graph is null");
        }
        if (v == null) {
            throw new NullPointerException("startVertex is null");
        }
    }

    private RankingPathElementList<V, E> createSeenData(V v, E e) {
        V v2 = Graphs.getOppositeVertex(this.graph, e, v);
        RankingPathElementList<V, E> rankingPathElementList = this.prevSeenDataContainer.get(v2);
        RankingPathElementList<V, E> rankingPathElementList2 = new RankingPathElementList<V, E>(this.graph, this.k, rankingPathElementList, e);
        return rankingPathElementList2;
    }

    private Set<E> edgesOf(V v) {
        if (this.graph instanceof DirectedGraph) {
            return ((DirectedGraph)this.graph).outgoingEdgesOf(v);
        }
        return this.graph.edgesOf(v);
    }

    private void encounterStartVertex() {
        RankingPathElementList<V, E> rankingPathElementList = new RankingPathElementList<V, E>(this.graph, this.k, new RankingPathElement(this.startVertex));
        this.seenDataContainer.put((RankingPathElementList<V, E>)this.startVertex, (RankingPathElementList<RankingPathElementList<V, E>, E>)rankingPathElementList);
        this.prevSeenDataContainer.put((RankingPathElementList<V, E>)this.startVertex, (RankingPathElementList<RankingPathElementList<V, E>, E>)rankingPathElementList);
        this.prevImprovedVertices.add(this.startVertex);
        this.startVertexEncountered = true;
    }

    private void savePassData(Set<V> set) {
        for (V v : set) {
            RankingPathElementList<V, E> rankingPathElementList = new RankingPathElementList<V, E>(this.seenDataContainer.get(v));
            this.prevSeenDataContainer.put((RankingPathElementList<V, E>)v, (RankingPathElementList<RankingPathElementList<V, E>, E>)rankingPathElementList);
        }
        this.prevImprovedVertices = set;
    }

    private boolean tryToAddNewPaths(V v, E e) {
        RankingPathElementList<V, E> rankingPathElementList = this.seenDataContainer.get(v);
        V v2 = Graphs.getOppositeVertex(this.graph, e, v);
        RankingPathElementList<V, E> rankingPathElementList2 = this.prevSeenDataContainer.get(v2);
        return rankingPathElementList.addPathElements(rankingPathElementList2, e);
    }

    private void updateOutgoingVertices(V v, Set<V> set) {
        for (E e : this.edgesOf(v)) {
            V v2 = Graphs.getOppositeVertex(this.graph, e, v);
            if (v2 == this.startVertex) continue;
            if (this.seenDataContainer.containsKey(v2)) {
                boolean bl = this.tryToAddNewPaths(v2, e);
                if (!bl) continue;
                set.add(v2);
                continue;
            }
            this.addFirstPath(v2, e);
            set.add(v2);
        }
    }
}

