/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.data.parsers;

import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.data.DataTable;
import eu.kliegr.ac1.rule.Data;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class CSVparser {
    private static final Logger LOGGER = Logger.getLogger(CSVparser.class.getName());
    public static final String weirdCharacter = new String(Character.toChars(65279));

    public static Data parseFromCSVwithHeader(String path, String targetColName, ArrayList<AttributeType> attributeTypes, String IDcolumnName, String sep) throws FileNotFoundException, Exception {
        LOGGER.log(Level.INFO, "Parsing csv file:{0}", path);
        Stream<String> firstLine = Files.lines(Paths.get(path, new String[0]));
        Stream<String[]> firstLineTokenized = firstLine.map(line -> line.replaceAll(weirdCharacter, "").split(sep)).map(stringarr -> {
            for (int i = 0; i < ((String[])stringarr).length; ++i) {
                stringarr[i] = CSVparser.removeEnclosingQuotes(stringarr[i]);
            }
            return stringarr;
        });
        Data rmi = new Data();
        DataTable dataTable = rmi.newDataTable(firstLineTokenized.findFirst().get(), targetColName, attributeTypes, IDcolumnName);
        Stream<String> allLines = Files.lines(Paths.get(path, new String[0]));
        Stream<String[]> tokenized = allLines.map(line -> line.replaceAll(weirdCharacter, "").split(sep));
        tokenized.skip(1L).forEach(items -> {
            for (int i = 0; i < ((String[])items).length; ++i) {
                items[i] = CSVparser.removeEnclosingQuotes(items[i]);
            }
            try {
                dataTable.addTransaction((String[])items);
            }
            catch (NumberFormatException e) {
                LOGGER.severe("Skipping transaction - possibly missing value");
            }
        });
        LOGGER.log(Level.INFO, "Loaded transactions:{0}", dataTable.getLoadedTransactionCount());
        return rmi;
    }

    public static String removeEnclosingQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private CSVparser() {
    }
}

