/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.graph;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.ListenableGraph;
import org._3pq.jgrapht.event.GraphEdgeChangeEvent;
import org._3pq.jgrapht.event.GraphListener;
import org._3pq.jgrapht.event.GraphVertexChangeEvent;
import org._3pq.jgrapht.event.VertexSetListener;
import org._3pq.jgrapht.graph.GraphDelegator;

public class DefaultListenableGraph
extends GraphDelegator
implements ListenableGraph,
Cloneable {
    private static final long serialVersionUID = 3977575900898471984L;
    private ArrayList m_graphListeners = new ArrayList();
    private ArrayList m_vertexSetListeners = new ArrayList();
    private FlyweightEdgeEvent m_reuseableEdgeEvent;
    private FlyweightVertexEvent m_reuseableVertexEvent;
    private boolean m_reuseEvents;

    public DefaultListenableGraph(Graph graph) {
        this(graph, false);
    }

    public DefaultListenableGraph(Graph graph, boolean bl) {
        super(graph);
        this.m_reuseEvents = bl;
        this.m_reuseableEdgeEvent = new FlyweightEdgeEvent(this, -1, null);
        this.m_reuseableVertexEvent = new FlyweightVertexEvent(this, -1, null);
        if (graph instanceof ListenableGraph) {
            throw new IllegalArgumentException("base graph cannot be listenable");
        }
    }

    public void setReuseEvents(boolean bl) {
        this.m_reuseEvents = bl;
    }

    public boolean isReuseEvents() {
        return this.m_reuseEvents;
    }

    public Edge addEdge(Object object, Object object2) {
        Edge edge = super.addEdge(object, object2);
        if (edge != null) {
            this.fireEdgeAdded(edge);
        }
        return edge;
    }

    public boolean addEdge(Edge edge) {
        boolean bl = super.addEdge(edge);
        if (bl) {
            this.fireEdgeAdded(edge);
        }
        return bl;
    }

    public void addGraphListener(GraphListener graphListener) {
        this.addToListenerList(this.m_graphListeners, graphListener);
    }

    public boolean addVertex(Object object) {
        boolean bl = super.addVertex(object);
        if (bl) {
            this.fireVertexAdded(object);
        }
        return bl;
    }

    public void addVertexSetListener(VertexSetListener vertexSetListener) {
        this.addToListenerList(this.m_vertexSetListeners, vertexSetListener);
    }

    public Object clone() {
        try {
            DefaultListenableGraph defaultListenableGraph = (DefaultListenableGraph)super.clone();
            defaultListenableGraph.m_graphListeners = new ArrayList();
            defaultListenableGraph.m_vertexSetListeners = new ArrayList();
            return defaultListenableGraph;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new RuntimeException("internal error");
        }
    }

    public Edge removeEdge(Object object, Object object2) {
        Edge edge = super.removeEdge(object, object2);
        if (edge != null) {
            this.fireEdgeRemoved(edge);
        }
        return edge;
    }

    public boolean removeEdge(Edge edge) {
        boolean bl = super.removeEdge(edge);
        if (bl) {
            this.fireEdgeRemoved(edge);
        }
        return bl;
    }

    public void removeGraphListener(GraphListener graphListener) {
        this.m_graphListeners.remove(graphListener);
    }

    public boolean removeVertex(Object object) {
        if (this.containsVertex(object)) {
            List list = this.edgesOf(object);
            Edge[] edgeArray = new Edge[list.size()];
            list.toArray(edgeArray);
            this.removeAllEdges(edgeArray);
            super.removeVertex(object);
            this.fireVertexRemoved(object);
            return true;
        }
        return false;
    }

    public void removeVertexSetListener(VertexSetListener vertexSetListener) {
        this.m_vertexSetListeners.remove(vertexSetListener);
    }

    protected void fireEdgeAdded(Edge edge) {
        GraphEdgeChangeEvent graphEdgeChangeEvent = this.createGraphEdgeChangeEvent(23, edge);
        for (int i = 0; i < this.m_graphListeners.size(); ++i) {
            GraphListener graphListener = (GraphListener)this.m_graphListeners.get(i);
            graphListener.edgeAdded(graphEdgeChangeEvent);
        }
    }

    protected void fireEdgeRemoved(Edge edge) {
        GraphEdgeChangeEvent graphEdgeChangeEvent = this.createGraphEdgeChangeEvent(24, edge);
        for (int i = 0; i < this.m_graphListeners.size(); ++i) {
            GraphListener graphListener = (GraphListener)this.m_graphListeners.get(i);
            graphListener.edgeRemoved(graphEdgeChangeEvent);
        }
    }

    protected void fireVertexAdded(Object object) {
        VertexSetListener vertexSetListener;
        int n;
        GraphVertexChangeEvent graphVertexChangeEvent = this.createGraphVertexChangeEvent(13, object);
        for (n = 0; n < this.m_vertexSetListeners.size(); ++n) {
            vertexSetListener = (VertexSetListener)this.m_vertexSetListeners.get(n);
            vertexSetListener.vertexAdded(graphVertexChangeEvent);
        }
        for (n = 0; n < this.m_graphListeners.size(); ++n) {
            vertexSetListener = (GraphListener)this.m_graphListeners.get(n);
            vertexSetListener.vertexAdded(graphVertexChangeEvent);
        }
    }

    protected void fireVertexRemoved(Object object) {
        VertexSetListener vertexSetListener;
        int n;
        GraphVertexChangeEvent graphVertexChangeEvent = this.createGraphVertexChangeEvent(14, object);
        for (n = 0; n < this.m_vertexSetListeners.size(); ++n) {
            vertexSetListener = (VertexSetListener)this.m_vertexSetListeners.get(n);
            vertexSetListener.vertexRemoved(graphVertexChangeEvent);
        }
        for (n = 0; n < this.m_graphListeners.size(); ++n) {
            vertexSetListener = (GraphListener)this.m_graphListeners.get(n);
            vertexSetListener.vertexRemoved(graphVertexChangeEvent);
        }
    }

    private void addToListenerList(List list, EventListener eventListener) {
        if (!list.contains(eventListener)) {
            list.add(eventListener);
        }
    }

    private GraphEdgeChangeEvent createGraphEdgeChangeEvent(int n, Edge edge) {
        if (this.m_reuseEvents) {
            this.m_reuseableEdgeEvent.setType(n);
            this.m_reuseableEdgeEvent.setEdge(edge);
            return this.m_reuseableEdgeEvent;
        }
        return new GraphEdgeChangeEvent(this, n, edge);
    }

    private GraphVertexChangeEvent createGraphVertexChangeEvent(int n, Object object) {
        if (this.m_reuseEvents) {
            this.m_reuseableVertexEvent.setType(n);
            this.m_reuseableVertexEvent.setVertex(object);
            return this.m_reuseableVertexEvent;
        }
        return new GraphVertexChangeEvent(this, n, object);
    }

    private static class FlyweightVertexEvent
    extends GraphVertexChangeEvent {
        private static final long serialVersionUID = 3257848787857585716L;

        public FlyweightVertexEvent(Object object, int n, Object object2) {
            super(object, n, object2);
        }

        protected void setType(int n) {
            this.m_type = n;
        }

        protected void setVertex(Object object) {
            this.m_vertex = object;
        }
    }

    private static class FlyweightEdgeEvent
    extends GraphEdgeChangeEvent {
        private static final long serialVersionUID = 3907207152526636089L;

        public FlyweightEdgeEvent(Object object, int n, Edge edge) {
            super(object, n, edge);
        }

        protected void setEdge(Edge edge) {
            this.m_edge = edge;
        }

        protected void setType(int n) {
            this.m_type = n;
        }
    }
}

