/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

public class IntCircularQueue {
    private int[] elementData;
    private int head = 0;
    private int tail = 0;
    private int size = 0;
    private int capacity;

    private static int closestGreater2n(int size) {
        if (size == 0) {
            return 2;
        }
        int _size = Integer.highestOneBit(size) << 1;
        assert (_size >= size);
        return _size;
    }

    public IntCircularQueue(int size) {
        size = IntCircularQueue.closestGreater2n(size);
        this.elementData = new int[size];
        this.capacity = size;
    }

    private int convert(int base, int delta) {
        return base + delta & this.capacity - 1;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }

    public int get(int index) {
        return this.elementData[this.convert(index, this.head)];
    }

    public boolean addFirst(int e) {
        this.head = this.convert(this.head, -1);
        this.elementData[this.head] = e;
        ++this.size;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
        return true;
    }

    public boolean addLast(int e) {
        this.elementData[this.tail] = e;
        ++this.size;
        this.tail = this.convert(this.tail, 1);
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
        return true;
    }

    public int pollFirst() {
        int pos = this.convert(this.head, 0);
        int tmp = this.elementData[pos];
        if (pos == this.head) {
            this.head = this.convert(this.head, 1);
        }
        --this.size;
        return tmp;
    }

    public int pollLast() {
        int pos = this.convert(this.tail, -1);
        int tmp = this.elementData[pos];
        this.tail = pos;
        --this.size;
        return tmp;
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.capacity;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        int[] a = new int[newCapacity];
        System.arraycopy(this.elementData, p, a, 0, r);
        System.arraycopy(this.elementData, 0, a, r, p);
        this.elementData = a;
        this.head = 0;
        this.tail = n;
        this.capacity = newCapacity;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("{");
        for (int i = 0; i < this.size - 1; ++i) {
            int pos = this.convert(this.head + i, 0);
            buf.append(this.elementData[pos]);
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }
}

