/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.sum.PropSum;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;

public class PropSumFullBool
extends PropSum {
    protected PropSumFullBool(BoolVar[] variables, int pos, Operator o, int b, boolean reactOnFineEvent) {
        super(variables, pos, o, b, PropagatorPriority.BINARY, reactOnFineEvent);
    }

    public PropSumFullBool(BoolVar[] variables, int pos, Operator o, int b) {
        this(variables, pos, o, b, false);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.INSTANTIATE.getMask();
    }

    @Override
    protected void prepare() {
        int k;
        int i;
        int lb = 0;
        int ub = 0;
        for (i = 0; i < this.pos; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                k = ((IntVar[])this.vars)[i].getLB();
                lb += k;
                ub += k;
                continue;
            }
            ++ub;
        }
        while (i < this.l) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                k = ((IntVar[])this.vars)[i].getLB();
                lb -= k;
                ub -= k;
            } else {
                --lb;
            }
            ++i;
        }
        this.sumLB = lb;
        this.sumUB = ub;
    }

    @Override
    protected void filterOnEq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (F2 <= 0 || E <= 0) {
            int ub;
            int lb;
            int i;
            for (i = 0; i < this.pos; ++i) {
                lb = ((IntVar[])this.vars)[i].getLB();
                if (F2 <= 0 && ((IntVar[])this.vars)[i].updateUpperBound(F2 + lb, (ICause)this)) {
                    ++E;
                }
                ub = ((IntVar[])this.vars)[i].getUB();
                if (E > 0 || !((IntVar[])this.vars)[i].updateLowerBound(ub - E, (ICause)this)) continue;
                ++F2;
            }
            while (i < this.l) {
                lb = ((IntVar[])this.vars)[i].getUB();
                if (F2 <= 0 && ((IntVar[])this.vars)[i].updateLowerBound(-F2 + lb, (ICause)this)) {
                    --E;
                }
                ub = ((IntVar[])this.vars)[i].getLB();
                if (E <= 0 && ((IntVar[])this.vars)[i].updateUpperBound(ub + E, (ICause)this)) {
                    --F2;
                }
                ++i;
            }
        }
    }

    @Override
    protected void filterOnLeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (F2 <= 0) {
            int lb;
            int i;
            for (i = 0; i < this.pos; ++i) {
                lb = ((IntVar[])this.vars)[i].getLB();
                if (!((IntVar[])this.vars)[i].updateUpperBound(F2 + lb, (ICause)this)) continue;
                ++E;
            }
            while (i < this.l) {
                lb = ((IntVar[])this.vars)[i].getUB();
                if (((IntVar[])this.vars)[i].updateLowerBound(-F2 + lb, (ICause)this)) {
                    --E;
                }
                ++i;
            }
        }
        if (E <= 0) {
            this.setPassive();
        }
    }

    @Override
    protected void filterOnGeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (E <= 0) {
            int ub;
            int i;
            for (i = 0; i < this.pos; ++i) {
                ub = ((IntVar[])this.vars)[i].getUB();
                if (!((IntVar[])this.vars)[i].updateLowerBound(ub - E, (ICause)this)) continue;
                ++F2;
            }
            while (i < this.l) {
                ub = ((IntVar[])this.vars)[i].getLB();
                if (((IntVar[])this.vars)[i].updateUpperBound(ub + E, (ICause)this)) {
                    --F2;
                }
                ++i;
            }
        }
        if (F2 <= 0) {
            this.setPassive();
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(this.pos == 0 ? "-" : "").append(((IntVar[])this.vars)[0].getName());
        for (i = 1; i < this.pos; ++i) {
            linComb.append(" + ").append(((IntVar[])this.vars)[i].getName());
        }
        while (i < this.l) {
            linComb.append(" - ").append(((IntVar[])this.vars)[i].getName());
            ++i;
        }
        linComb.append(" ").append((Object)this.o).append(" ").append(this.b);
        return linComb.toString();
    }

    @Override
    protected PropSum opposite() {
        BoolVar[] bvars = new BoolVar[((IntVar[])this.vars).length];
        System.arraycopy(this.vars, 0, bvars, 0, bvars.length);
        return new PropSumFullBool(bvars, this.pos, PropSumFullBool.nop(this.o), this.b + PropSumFullBool.nb(this.o), this.reactToFineEvt);
    }
}

