/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.functions;

import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.classifiers.AbstractMultiLabelLearner;
import moa.classifiers.MultiLabelClassifier;
import moa.classifiers.rules.multilabel.functions.AMRulesFunction;
import moa.core.Measurement;

public class DominantLabelsClassifier
extends AbstractMultiLabelLearner
implements MultiLabelClassifier,
AMRulesFunction {
    private static final long serialVersionUID = 1L;
    private double[] countVector;
    private double numInstances;

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public void resetWithMemory() {
    }

    @Override
    public void selectOutputsToLearn(int[] outputAttributes) {
        int n = outputAttributes.length;
        double[] newCountVector = new double[n];
        for (int i = 0; i < n; ++i) {
            newCountVector[i] = this.countVector[outputAttributes[i]];
        }
        newCountVector = this.countVector;
    }

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance instance) {
        int numOutputs = instance.numberOutputTargets();
        if (this.countVector == null) {
            this.countVector = new double[numOutputs];
        }
        double weight = instance.weight();
        for (int i = 0; i < numOutputs; ++i) {
            int n = i;
            this.countVector[n] = this.countVector[n] + weight * instance.valueOutputAttribute(i);
        }
        this.numInstances += weight;
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance inst) {
        int numOutputs = inst.numOutputAttributes();
        MultiLabelPrediction p = new MultiLabelPrediction(numOutputs);
        if (this.countVector != null) {
            for (int i = 0; i < numOutputs; ++i) {
                double frac = this.countVector[i] / this.numInstances;
                p.setVote(i, 1, frac);
                p.setVote(i, 0, 1.0 - frac);
            }
        }
        return p;
    }

    @Override
    public void resetLearningImpl() {
        this.countVector = null;
        this.numInstances = 0.0;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }
}

