/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.dialogs;

import java.util.Vector;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.logging.ApplicationLog;
import org.af.commons.logging.LoggingSystem;
import org.af.commons.tools.StringTools;
import org.mutoss.config.Configuration;
import org.mutoss.gui.RControl;
import org.mutoss.gui.dialogs.ErrorDialogChooseLevelBase;

public class ErrorDialogChooseLevel
extends ErrorDialogChooseLevelBase {
    public ErrorDialogChooseLevel(String msg, Object e, boolean fatal) {
        super(msg, e, fatal);
    }

    public String getSubjectShort() {
        return "Crossover " + Configuration.getInstance().getGeneralConfig().getVersionNumber() + " (R " + Configuration.getInstance().getGeneralConfig().getRVersionNumber() + ") " + "bug report from " + System.getProperty("user.name", "<unknown user name>") + " on " + System.getProperty("os.name", "<unknown OS>");
    }

    protected String getErrorReport(int level) {
        if (level == 0) {
            return "Please reconsider reporting this error.";
        }
        String text = this.subjectShort + " : " + this.message + "\n" + this.getSep("R TraceBack") + this.getTraceBack() + "\n" + this.getSep("Java Stacktrace") + this.stacktrace;
        if (level == 1) {
            return text;
        }
        Vector rhistory = new Vector();
        for (int i = 0; i < RControl.getR().getHistory().size(); ++i) {
            rhistory.add(RControl.getR().getHistory().get(i));
        }
        text = text + this.getSep("R Session Info") + this.getRSessionInfo() + this.getSep("R GUI History") + StringTools.collapseStringList(rhistory, (String)"\n");
        if (level == 2) {
            return text;
        }
        text = text + this.getSep("System Info") + this.getSystemInfo() + this.getSep("R Options") + this.getROptions();
        return text;
    }

    public static void main(String[] args) {
        LoggingSystem.init((String)"/org/mutoss/gui/commons-logging.properties", (boolean)true, (boolean)false, (ApplicationLog)new ApplicationLog());
        ErrorHandler.init((String)"rohmeyer@small-projects.de", (String)"http://www.algorithm-forge.com/report/bugreport.php", (boolean)true, (boolean)true, ErrorDialogChooseLevel.class);
        RControl.getRControl(true);
        RControl.getR().eval("plot(z=1:100)");
        throw new RuntimeException("This is a test.");
    }
}

