/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.impl.DSIDataEngine;
import com.amazon.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.amazon.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IQueryExecutor;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.dsi.dataengine.utilities.OrderType;
import com.amazon.dsi.exceptions.ParsingException;
import com.amazon.jdbc.utils.ParseQueryUtils;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCallableStatementParser;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGBatchQueryExecutor;
import com.amazon.redshift.dataengine.PGCatalogQueryBuilder;
import com.amazon.redshift.dataengine.PGEscaper;
import com.amazon.redshift.dataengine.PGQueryExecutor;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.dataengine.metadata.PGJDBCTypeInfoMetadataSource;
import com.amazon.redshift.dataengine.metadata.PGMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGProcedureColumnsMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGTablePrivilegesMetadatSourceFromQuery;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PGDataEngine
extends DSIDataEngine {
    private PGClient m_client;
    private PGJDBCStatement m_statement;
    private ILogger m_log;
    private boolean m_isDirectExecution;
    private int m_socketTimeoutMS;
    private PGJDBCSettings m_settings;
    private PGEscaper m_jdbcEscaper = new PGEscaper();
    private PGMessagingContext m_getColumnsSchemaTableColumn;
    private PGMessagingContext m_getColumnsSchemaTable;
    private PGMessagingContext m_getColumnsSchemaColumn;
    private PGMessagingContext m_getColumnsSchema;
    private PGMessagingContext m_getColumnsSchemaTableColumnExt;
    private PGMessagingContext m_getColumnsSchemaTableExt;
    private PGMessagingContext m_getColumnsSchemaColumnExt;
    private PGMessagingContext m_getColumnsSchemaExt;
    private PGMessagingContext m_getColumnsTableColumnExt;
    private PGMessagingContext m_getColumnsTableExt;
    private PGMessagingContext m_getColumnsColumnExt;
    private PGMessagingContext m_getColumnsNoParams;
    private PGMessagingContext m_getTablesSchemaTableTypes;
    private PGMessagingContext m_getTablesSchemaTable;
    private PGMessagingContext m_getTablesSchemaTypes;
    private PGMessagingContext m_getTablesSchema;
    private PGMessagingContext m_getTablesSchemaTableTypesExt;
    private PGMessagingContext m_getTablesSchemaTableExt;
    private PGMessagingContext m_getTablesSchemaTypesExt;
    private PGMessagingContext m_getTablesSchemaExt;
    private PGMessagingContext m_getTablesTableTypesExt;
    private PGMessagingContext m_getTablesTableExt;
    private PGMessagingContext m_getTablesTypesExt;
    private PGMessagingContext m_getTablesNoParams;
    private PGMessagingContext m_getCatalogs;
    private PGMessagingContext m_getSchemas;

    public PGDataEngine(PGJDBCStatement pGJDBCStatement, PGClient pGClient, PGJDBCSettings pGJDBCSettings, ILogger iLogger, int n) {
        super(pGJDBCStatement);
        this.m_statement = pGJDBCStatement;
        this.m_log = iLogger;
        this.m_client = pGClient;
        this.m_settings = pGJDBCSettings;
        this.m_isDirectExecution = false;
        this.m_socketTimeoutMS = n;
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, list);
        return new PGBatchQueryExecutor(null, list, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, true);
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        List<String> list;
        if (this.m_statement.isCallableStatement()) {
            try {
                PGCallableStatementParser pGCallableStatementParser = new PGCallableStatementParser();
                pGCallableStatementParser.Translate(string);
                this.m_statement.sethasReturnQuestionMark(pGCallableStatementParser.isReturnParameter());
                return new PGQueryExecutor(this.m_jdbcEscaper.apply(string), this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (1 == (list = ParseQueryUtils.splitQueries(string, true)).size()) {
            return new PGQueryExecutor(this.m_jdbcEscaper.apply(list.get(0)), this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            String string3 = this.m_jdbcEscaper.apply(string2);
            arrayList.add(string3);
        }
        return new PGBatchQueryExecutor(string, arrayList, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, false);
    }

    @Override
    public void setDirectExecute() {
        this.m_isDirectExecution = true;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        if (MetadataSourceID.PRIMARY_KEYS == metadataSourceID) {
            return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, OrderType.NONE);
        }
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, orderType);
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        switch (metadataSourceID) {
            case TYPE_INFO: {
                return new PGJDBCTypeInfoMetadataSource(this.getLog());
            }
            case TABLETYPE_ONLY: {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("TABLE");
                arrayList.add("VIEW");
                arrayList.add("SEQUENCE");
                arrayList.add("INDEX");
                arrayList.add("SYSTEM TABLE");
                arrayList.add("SYSTEM TOAST TABLE");
                arrayList.add("TEMPORARY TABLE");
                arrayList.add("EXTERNAL TABLE");
                arrayList.add("SYSTEM VIEW");
                arrayList.add("TEMPORARY VIEW");
                arrayList.add("SYSTEM INDEX");
                arrayList.add("SYSTEM TOAST INDEX");
                arrayList.add("TEMPORARY INDEX");
                arrayList.add("TEMPORARY SEQUENCE");
                arrayList.add("TYPE");
                return new DSITableTypeOnlyMetadataSource(this.getLog(), arrayList);
            }
            case TABLES: {
                this.setHasExtSchemaPatternMatch(map);
                return this.runGetTables(metadataSourceID, map);
            }
            case COLUMNS: {
                this.setHasExtSchemaPatternMatch(map);
                return this.runGetColumns(metadataSourceID, map);
            }
            case CATALOG_ONLY: {
                if (null == this.m_getCatalogs) {
                    String string3 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getCatalogs = this.m_client.prepareStatement(string3, null, true);
                }
                this.m_client.executePreparedStatement(this.m_getCatalogs, 0, 0, true, null, 0);
                return new PGMetadatSourceFromQuery(metadataSourceID, this.m_getCatalogs, 0, this.m_log);
            }
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: {
                if (null == this.m_getSchemas) {
                    String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getSchemas = this.m_client.prepareStatement(string4, null, true);
                }
                this.m_client.executePreparedStatement(this.m_getSchemas, 0, 0, true, null, 0);
                return new PGMetadatSourceFromQuery(metadataSourceID, this.m_getSchemas, 0, this.m_log);
            }
            case FOREIGN_KEYS: 
            case PRIMARY_KEYS: {
                String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                PGMessagingContext pGMessagingContext = this.m_client.prepareStatement(string5, null, true);
                return this.executePreparedCatalogFunction(metadataSourceID, map, pGMessagingContext);
            }
            case TABLE_PRIVILEGES: {
                String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                PGMessagingContext pGMessagingContext = this.m_client.prepareStatement(string6, null, true);
                byte[][] byArray = this.getCatalogQueryParameters(metadataSourceID, map);
                this.m_client.executePreparedStatement(pGMessagingContext, 0, 0, true, byArray, 0);
                return new PGTablePrivilegesMetadatSourceFromQuery(pGMessagingContext, this.m_log);
            }
            case PROCEDURES: {
                String string7 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                PGMessagingContext pGMessagingContext = this.m_client.prepareStatement(string7, null, true);
                return this.executePreparedCatalogFunction(metadataSourceID, map, pGMessagingContext);
            }
            case PROCEDURE_COLUMNS: {
                String string8 = PGCoreUtils.SERVER_VERSION;
                int n = Integer.parseInt(string8.split("\\.")[0]);
                int n2 = Integer.parseInt(string8.split("\\.")[1]);
                if (n >= 8 && n2 >= 4) {
                    String string9 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    PGMessagingContext pGMessagingContext = this.m_client.prepareStatement(string9, null, true);
                    return this.executePreparedCatalogFunction(metadataSourceID, map, pGMessagingContext);
                }
                String string10 = PGCatalogQueryBuilder.buildProcedureColumnsQueryForOldPostgres(map);
                PGMessagingContext pGMessagingContext = this.m_client.prepareStatement(string10, null, true);
                byte[][] byArray = this.getCatalogQueryParameters(metadataSourceID, map);
                this.m_client.executePreparedStatement(pGMessagingContext, 0, 0, true, byArray, 0);
                return new PGProcedureColumnsMetadatSourceFromQuery(pGMessagingContext, 0, this.m_log);
            }
            case FUNCTIONS_JDBC4: {
                if (!PGCoreUtils.REDSHIFT_SERVER) {
                    String string11 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    PGMessagingContext pGMessagingContext = this.m_client.prepareStatement(string11, null, true);
                    return this.executePreparedCatalogFunction(metadataSourceID, map, pGMessagingContext);
                }
                return new DSIEmptyMetadataSource(this.getLog());
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }

    public void setHasExtSchemaPatternMatch(Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        if (null != string && !string.equals("")) {
            PGMessagingContext pGMessagingContext = this.m_client.prepareStatement("select 1 from svv_external_schemas where schemaname like ? ", null, true);
            byte[][] byArray = new byte[1][0];
            byArray[0] = string.getBytes();
            this.m_client.executePreparedStatement(pGMessagingContext, 0, 0, true, byArray, 0);
            PGResultSet pGResultSet = new PGResultSet(pGMessagingContext, this.m_log);
            pGResultSet.closeCursor();
            this.m_settings.m_hasExtSchemaPatternMatch = pGResultSet.getRowCount() > 0L;
        } else {
            this.m_settings.m_hasExtSchemaPatternMatch = true;
        }
    }

    public IMetadataSource runGetTables(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        if (null != string3 && !string3.equals("")) {
            bl3 = true;
            object = string3.split(",");
            if (13 == ((String[])object).length) {
                bl4 = true;
            }
        }
        if (bl3 && !bl4) {
            object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            PGMessagingContext pGMessagingContext = this.m_client.prepareStatement((String)object, null, true);
            return this.executePreparedCatalogFunction(metadataSourceID, map, pGMessagingContext);
        }
        if (!this.m_settings.m_hasExtSchemaPatternMatch && bl) {
            if (bl2) {
                if (bl4) {
                    if (null == this.m_getTablesSchemaTableTypes) {
                        object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_getTablesSchemaTableTypes = this.m_client.prepareStatement((String)object, null, true);
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesSchemaTableTypes);
                }
                if (null == this.m_getTablesSchemaTable) {
                    object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getTablesSchemaTable = this.m_client.prepareStatement((String)object, null, true);
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesSchemaTable);
            }
            if (bl4) {
                if (null == this.m_getTablesSchemaTypes) {
                    object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getTablesSchemaTypes = this.m_client.prepareStatement((String)object, null, true);
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesSchemaTypes);
            }
            if (null == this.m_getTablesSchema) {
                object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_getTablesSchema = this.m_client.prepareStatement((String)object, null, true);
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesSchema);
        }
        if (bl) {
            if (bl2) {
                if (bl4) {
                    if (null == this.m_getTablesSchemaTableTypesExt) {
                        object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_getTablesSchemaTableTypesExt = this.m_client.prepareStatement((String)object, null, true);
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesSchemaTableTypesExt);
                }
                if (null == this.m_getTablesSchemaTableExt) {
                    object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getTablesSchemaTableExt = this.m_client.prepareStatement((String)object, null, true);
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesSchemaTableExt);
            }
            if (bl4) {
                if (null == this.m_getTablesSchemaTypesExt) {
                    object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getTablesSchemaTypesExt = this.m_client.prepareStatement((String)object, null, true);
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesSchemaTypesExt);
            }
            if (null == this.m_getTablesSchemaExt) {
                object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_getTablesSchemaExt = this.m_client.prepareStatement((String)object, null, true);
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesSchemaExt);
        }
        if (bl2) {
            if (bl4) {
                if (null == this.m_getTablesTableTypesExt) {
                    object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getTablesTableTypesExt = this.m_client.prepareStatement((String)object, null, true);
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesTableTypesExt);
            }
            if (null == this.m_getTablesTableExt) {
                object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_getTablesTableExt = this.m_client.prepareStatement((String)object, null, true);
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesTableExt);
        }
        if (bl4) {
            if (null == this.m_getTablesTypesExt) {
                object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_getTablesTypesExt = this.m_client.prepareStatement((String)object, null, true);
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesTypesExt);
        }
        if (null == this.m_getTablesNoParams) {
            object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_getTablesNoParams = this.m_client.prepareStatement((String)object, null, true);
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getTablesNoParams);
    }

    public IMetadataSource runGetColumns(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        if (null != string3 && !string3.equals("")) {
            bl3 = true;
        }
        if (!this.m_settings.m_hasExtSchemaPatternMatch && bl) {
            if (bl2) {
                if (bl3) {
                    if (null == this.m_getColumnsSchemaTableColumn) {
                        String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_getColumnsSchemaTableColumn = this.m_client.prepareStatement(string4, null, true);
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsSchemaTableColumn);
                }
                if (null == this.m_getColumnsSchemaTable) {
                    String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getColumnsSchemaTable = this.m_client.prepareStatement(string5, null, true);
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsSchemaTable);
            }
            if (bl3) {
                if (null == this.m_getColumnsSchemaColumn) {
                    String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getColumnsSchemaColumn = this.m_client.prepareStatement(string6, null, true);
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsSchemaColumn);
            }
            if (null == this.m_getColumnsSchema) {
                String string7 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_getColumnsSchema = this.m_client.prepareStatement(string7, null, true);
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsSchema);
        }
        if (bl) {
            if (bl2) {
                if (bl3) {
                    if (null == this.m_getColumnsSchemaTableColumnExt) {
                        String string8 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_getColumnsSchemaTableColumnExt = this.m_client.prepareStatement(string8, null, true);
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsSchemaTableColumnExt);
                }
                if (null == this.m_getColumnsSchemaTableExt) {
                    String string9 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getColumnsSchemaTableExt = this.m_client.prepareStatement(string9, null, true);
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsSchemaTableExt);
            }
            if (bl3) {
                if (null == this.m_getColumnsSchemaColumnExt) {
                    String string10 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getColumnsSchemaColumnExt = this.m_client.prepareStatement(string10, null, true);
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsSchemaColumnExt);
            }
            if (null == this.m_getColumnsSchemaExt) {
                String string11 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_getColumnsSchemaExt = this.m_client.prepareStatement(string11, null, true);
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsSchemaExt);
        }
        if (bl2) {
            if (bl3) {
                if (null == this.m_getColumnsTableColumnExt) {
                    String string12 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_getColumnsTableColumnExt = this.m_client.prepareStatement(string12, null, true);
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsTableColumnExt);
            }
            if (null == this.m_getColumnsTableExt) {
                String string13 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_getColumnsTableExt = this.m_client.prepareStatement(string13, null, true);
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsTableExt);
        }
        if (bl3) {
            if (null == this.m_getColumnsColumnExt) {
                String string14 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_getColumnsColumnExt = this.m_client.prepareStatement(string14, null, true);
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsColumnExt);
        }
        if (null == this.m_getColumnsNoParams) {
            String string15 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_getColumnsNoParams = this.m_client.prepareStatement(string15, null, true);
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_getColumnsNoParams);
    }

    public IMetadataSource executePreparedCatalogFunction(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, PGMessagingContext pGMessagingContext) throws ErrorException {
        byte[][] byArray = this.getCatalogQueryParameters(metadataSourceID, map);
        this.m_client.executePreparedStatement(pGMessagingContext, 0, 0, true, byArray, 0);
        return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
    }

    private byte[][] getCatalogQueryParameters(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        Object object2;
        int n = map.size();
        int n2 = 0;
        n2 += map.containsKey((Object)MetadataSourceColumnTag.CATALOG_NAME) ? 1 : 0;
        n2 += map.containsKey((Object)MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME) ? 1 : 0;
        n2 += map.containsKey((Object)MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME) ? 1 : 0;
        for (Object object2 : map.keySet()) {
            if (object2.equals((Object)MetadataSourceColumnTag.CATALOG_NAME) || object2.equals((Object)MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME) || object2.equals((Object)MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME) || null != map.get(object2) && !map.get(object2).isEmpty()) continue;
            ++n2;
        }
        if (n < n2) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_CATALOG_FUNC_ARG_ERR.name(), map.keySet().toString());
        }
        int n3 = n - n2;
        object2 = new byte[n3][];
        int n4 = 0;
        switch (metadataSourceID) {
            case TABLES: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string2 && !string2.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string2.getBytes();
                }
                if (null != string3 && !string3.isEmpty()) {
                    String[] stringArray = string3.split(",");
                    if (1 < stringArray.length) {
                        object2 = (byte[][])Arrays.copyOf(object2, ((MetadataSourceColumnTag)object2).length - 1 + stringArray.length);
                        int n5 = 0;
                        while (((MetadataSourceColumnTag)object2).length > n4) {
                            object2[n4++] = (MetadataSourceColumnTag)stringArray[n5++].getBytes();
                        }
                    } else {
                        object2[n4++] = (MetadataSourceColumnTag)stringArray[0].getBytes();
                    }
                }
                return object2;
            }
            case COLUMNS: {
                if (this.m_settings.m_hasExtSchemaPatternMatch) {
                    String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                    String string4 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                    String string5 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
                    if (null != string && !string.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                    }
                    if (null != string4 && !string4.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)string4.getBytes();
                    }
                    if (null != string5 && !string5.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)string5.getBytes();
                    }
                } else {
                    object2 = new byte[n3 * 2][];
                    String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                    String string6 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                    String string7 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
                    if (null != string && !string.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)string.getBytes();
                        object2[n3 + n4++] = (MetadataSourceColumnTag)string.getBytes();
                    }
                    if (null != string6 && !string6.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)string6.getBytes();
                        object2[n3 + n4++] = (MetadataSourceColumnTag)string6.getBytes();
                    }
                    if (null != string7 && !string7.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)string7.getBytes();
                        object2[n3 + n4++] = (MetadataSourceColumnTag)string7.getBytes();
                    }
                }
                return object2;
            }
            case FOREIGN_KEYS: {
                String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
                String string8 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
                String string9 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
                String string10 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string8 && !string8.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string8.getBytes();
                }
                if (null != string9 && !string9.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string9.toLowerCase().getBytes();
                }
                if (null != string10 && !string10.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string10.getBytes();
                }
                return object2;
            }
            case PRIMARY_KEYS: {
                String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
                String string11 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
                if (null != string11) {
                    object2[n4++] = (MetadataSourceColumnTag)string11.toLowerCase().getBytes();
                }
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.toLowerCase().getBytes();
                }
                return object2;
            }
            case PROCEDURES: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string12 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string12 && !string12.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string12.getBytes();
                }
                return object2;
            }
            case FUNCTIONS_JDBC4: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string13 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string13 && !string13.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string13.getBytes();
                }
                return object2;
            }
            case PROCEDURE_COLUMNS: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string14 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string14 && !string14.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string14.getBytes();
                }
                return object2;
            }
            case TABLE_PRIVILEGES: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string15 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string15 && !string15.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string15.getBytes();
                }
                return object2;
            }
        }
        return object2;
    }
}

