/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

public class Timer {
    private long start = 0L;
    private long stop = 0L;
    private long nanoStart = 0L;
    private long nanoStop = 0L;

    public void start() {
        this.nanoStart = System.nanoTime();
        this.start = System.currentTimeMillis();
    }

    public void stop() {
        this.nanoStop = System.nanoTime();
        this.stop = System.currentTimeMillis();
    }

    public void update() {
        this.nanoStop = System.nanoTime();
        this.stop = System.currentTimeMillis();
    }

    public long calibrate(double d) {
        long l = System.currentTimeMillis() - this.start;
        return Math.round((double)l / d * (1.0 - d));
    }

    public double toSeconds() {
        this.update();
        return Timer.toSeconds(this.stop - this.start);
    }

    public double toMilliSeconds() {
        this.update();
        return this.stop - this.start;
    }

    public double toNanoSeconds() {
        this.update();
        return this.nanoStop - this.nanoStart;
    }

    public static double toSeconds(long l) {
        return (double)l / 1000.0;
    }

    public static double toMinutes(long l) {
        return Timer.toSeconds(l) / 60.0;
    }

    public static double toHours(long l) {
        return Timer.toMinutes(l) / 60.0;
    }

    public static double toDays(long l) {
        return Timer.toHours(l) / 24.0;
    }

    public String toString() {
        this.update();
        return Timer.toString(this.stop - this.start);
    }

    public static String toString(long l) {
        if (Timer.toDays(l) > 1.0) {
            return Timer.toDays(l) + " days";
        }
        if (Timer.toHours(l) > 1.0) {
            return Timer.toHours(l) + " hours";
        }
        if (Timer.toMinutes(l) > 1.0) {
            return Timer.toMinutes(l) + " minutes";
        }
        return Timer.toSeconds(l) + " seconds";
    }
}

