## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height = 7
)

## ----setup--------------------------------------------------------------------


## ----cggpcreate---------------------------------------------------------------
library(CGGP)
# Create the initial design
d <- 6
mod <- CGGPcreate(d=d, batchsize=100)
mod

## -----------------------------------------------------------------------------
str(mod$design)

## -----------------------------------------------------------------------------
f <- function(x){x[1]*x[2] + x[3]^2 + (x[2]+.5)*sin(2*pi*x[4])}
Y <- apply(mod$design, 1, f)

## ----cggpfit------------------------------------------------------------------
mod <- CGGPfit(mod, Y)
mod

## ----cggppred-----------------------------------------------------------------
xp <- matrix(runif(d*100), ncol=d)
str(CGGPpred(CGGP=mod, xp=xp))

## ----cggpappend---------------------------------------------------------------
mod <- CGGPappend(mod, 200, "MAP")
mod

## ----updatefit----------------------------------------------------------------
Ynew <- apply(mod$design_unevaluated, 1, f)
mod <- CGGPfit(mod, Ynew=Ynew)
mod

## ----plotblocks---------------------------------------------------------------
CGGPplotblocks(mod)

## ----plothist-----------------------------------------------------------------
CGGPplothist(mod)

## ----plotcorr-----------------------------------------------------------------
CGGPplotcorr(mod)

## ----plotslice----------------------------------------------------------------
CGGPplotslice(mod)

