/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat.matrix;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import umontreal.iro.lecuyer.stat.FunctionOfMultipleMeansTally;
import umontreal.iro.lecuyer.stat.matrix.MatrixOfStatProbes;
import umontreal.iro.lecuyer.util.MultivariateFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixOfFunctionOfMultipleMeansTallies<E extends FunctionOfMultipleMeansTally>
extends MatrixOfStatProbes<E> {
    double[][][] temp;

    public MatrixOfFunctionOfMultipleMeansTallies(int n, int n2) {
        super(n, n2);
    }

    public MatrixOfFunctionOfMultipleMeansTallies(String string, int n, int n2) {
        super(string, n, n2);
    }

    public static MatrixOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally> create(MultivariateFunction multivariateFunction, int n, int n2, int n3) {
        MatrixOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally> matrixOfFunctionOfMultipleMeansTallies = new MatrixOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally>(n2, n3);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                matrixOfFunctionOfMultipleMeansTallies.set(i, j, new FunctionOfMultipleMeansTally(multivariateFunction, n));
            }
        }
        return matrixOfFunctionOfMultipleMeansTallies;
    }

    public void add(double[][][] dArray) {
        if (dArray.length != this.rows()) {
            throw new IllegalArgumentException("The length of the given array must correspond to the number of rows in the matrix");
        }
        if (this.collect) {
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i].length != this.columns()) {
                    throw new IllegalArgumentException("The length of the array x[" + i + "] must correspond to the number of columns in the matrix");
                }
                for (int j = 0; j < dArray[i].length; ++j) {
                    ((FunctionOfMultipleMeansTally)this.get(i, j)).add(dArray[i][j]);
                }
            }
        }
    }

    public void add(DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D.rows() != this.rows()) {
            throw new IllegalArgumentException("The number of rows of the given matrix must correspond to the number of rows in the matrix of probes");
        }
        if (doubleMatrix3D.columns() != this.columns()) {
            throw new IllegalArgumentException("The number of columns of the given matrix must correspond to the number of columns in the matrix of probes");
        }
        if (this.collect) {
            for (int i = 0; i < this.rows(); ++i) {
                for (int j = 0; j < doubleMatrix3D.columns(); ++j) {
                    ((FunctionOfMultipleMeansTally)this.get(i, j)).add(doubleMatrix3D.viewSlice(i).viewRow(j).toArray());
                }
            }
        }
    }

    public void addSameDimension(DoubleMatrix2D ... doubleMatrix2DArray) {
        int n;
        int n2 = this.rows();
        int n3 = this.columns();
        int n4 = this.getDimension();
        if (doubleMatrix2DArray.length != n4) {
            throw new IllegalArgumentException("The length of the given array must be " + n4 + " while its actual length is " + doubleMatrix2DArray.length);
        }
        if (doubleMatrix2DArray.length == 0 || n2 == 0 || n3 == 0) {
            return;
        }
        if (n2 != doubleMatrix2DArray[0].rows() || n3 != doubleMatrix2DArray[0].columns()) {
            throw new IllegalArgumentException("The given matrices must have the same dimensions");
        }
        for (n = 0; n < doubleMatrix2DArray.length - 1; ++n) {
            if (doubleMatrix2DArray[n].rows() == doubleMatrix2DArray[n + 1].rows() && doubleMatrix2DArray[n].columns() == doubleMatrix2DArray[n + 1].columns()) continue;
            throw new IllegalArgumentException("The given arrays must have the same length");
        }
        if (this.temp == null || this.temp.length != n2 || this.temp[0].length != n3 || this.temp[0][0].length != n4) {
            this.temp = new double[n2][n3][n4];
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    this.temp[n][i][j] = doubleMatrix2DArray[j].getQuick(n, i);
                }
            }
        }
        this.add(this.temp);
    }

    public int getDimension() {
        if (this.rows() == 0 || this.columns() == 0) {
            return 0;
        }
        FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(0, 0);
        return functionOfMultipleMeansTally == null ? 0 : functionOfMultipleMeansTally.getDimension();
    }

    public int numberObs() {
        if (this.rows() == 0 || this.columns() == 0) {
            return 0;
        }
        FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(0, 0);
        return functionOfMultipleMeansTally == null ? 0 : functionOfMultipleMeansTally.numberObs();
    }

    public boolean areAllNumberObsEqual() {
        int n = this.rows();
        int n2 = this.columns();
        int n3 = this.numberObs();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(i, j);
                if (functionOfMultipleMeansTally.numberObs() == n3) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void average(DoubleMatrix2D doubleMatrix2D) {
        super.average(doubleMatrix2D);
        for (int i = 0; i < doubleMatrix2D.rows(); ++i) {
            for (int j = 0; j < doubleMatrix2D.columns(); ++j) {
                if (Double.isNaN(doubleMatrix2D.getQuick(i, j)) || ((FunctionOfMultipleMeansTally)this.get(i, j)).numberObs() != 0) continue;
                doubleMatrix2D.setQuick(i, j, Double.NaN);
            }
        }
    }

    public void variance(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + doubleMatrix2D.rows());
        }
        if (doubleMatrix2D.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + doubleMatrix2D.columns());
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(i, j);
                doubleMatrix2D.setQuick(i, j, functionOfMultipleMeansTally != null && functionOfMultipleMeansTally.numberObs() >= 2 ? functionOfMultipleMeansTally.variance() : Double.NaN);
            }
        }
    }

    public void standardDeviation(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + doubleMatrix2D.rows());
        }
        if (doubleMatrix2D.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + doubleMatrix2D.columns());
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                FunctionOfMultipleMeansTally functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)this.get(i, j);
                doubleMatrix2D.setQuick(i, j, functionOfMultipleMeansTally != null && functionOfMultipleMeansTally.numberObs() >= 2 ? functionOfMultipleMeansTally.standardDeviation() : Double.NaN);
            }
        }
    }

    @Override
    public MatrixOfFunctionOfMultipleMeansTallies<E> clone() {
        MatrixOfFunctionOfMultipleMeansTallies matrixOfFunctionOfMultipleMeansTallies = (MatrixOfFunctionOfMultipleMeansTallies)super.clone();
        if (this.temp != null) {
            matrixOfFunctionOfMultipleMeansTallies.temp = new double[this.temp.length][this.temp[0].length][this.temp[0].length];
            for (int i = 0; i < this.temp.length; ++i) {
                int n = 0;
                while (n < this.temp[i].length) {
                    for (int j = 0; j < this.temp[i][n].length; ++j) {
                        matrixOfFunctionOfMultipleMeansTallies.temp[i][n][j] = this.temp[i][n][j];
                    }
                    ++i;
                }
            }
        }
        return matrixOfFunctionOfMultipleMeansTallies;
    }
}

