/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import umontreal.iro.lecuyer.util.PrintfFormat;

public class TableFormat {
    public static final int PLAIN = 0;
    public static final int MATHEMATICA = 1;
    public static final int MATLAB = 2;
    private static int Style = 0;
    private static char OuvrantMat = (char)32;
    private static char FermantMat = (char)32;
    private static char OuvrantVec = (char)32;
    private static char FermantVec = (char)32;
    private static char SepareVec = (char)32;
    private static char SepareElem = (char)32;

    private TableFormat() {
    }

    public static String format(int[] nArray, int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 > 1) {
            stringBuffer.append("Elements  " + n + "  to  " + n2 + "\n\n");
            for (int i = n; i <= n2; ++i) {
                stringBuffer.append(PrintfFormat.d(n4, nArray[i]));
                if ((i + 1 - n) % n3 != 0) continue;
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        } else {
            stringBuffer.append("\n Index        Element\n");
            for (int i = n; i <= n2; ++i) {
                stringBuffer.append(PrintfFormat.d(6, i) + "   " + PrintfFormat.d(12, nArray[i]));
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String format(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 > 1) {
            stringBuffer.append("Elements  " + n + "  to  " + n2 + "\n\n");
            for (int i = n; i <= n2; ++i) {
                stringBuffer.append(PrintfFormat.format(n4, n5, n6, dArray[i]));
                if ((i + 1 - n) % n3 != 0) continue;
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        } else {
            stringBuffer.append("\n Index            Element\n");
            for (int i = n; i <= n2; ++i) {
                stringBuffer.append(PrintfFormat.d(6, i) + "   " + PrintfFormat.format(n4, n5, n6, dArray[i]) + "\n");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private static void fixeDelim(int n) {
        Style = n;
        switch (n) {
            case 1: {
                OuvrantMat = (char)123;
                FermantMat = (char)125;
                OuvrantVec = (char)123;
                FermantVec = (char)125;
                SepareVec = (char)44;
                SepareElem = (char)44;
                break;
            }
            case 2: {
                OuvrantMat = (char)91;
                FermantMat = (char)93;
                OuvrantVec = (char)32;
                FermantVec = (char)32;
                SepareVec = (char)32;
                SepareElem = (char)32;
                break;
            }
            default: {
                OuvrantMat = (char)32;
                FermantMat = (char)32;
                OuvrantVec = (char)32;
                FermantVec = (char)32;
                SepareVec = (char)32;
                SepareElem = (char)32;
            }
        }
    }

    public static String format(int[][] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        TableFormat.fixeDelim(n7);
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > 0) {
            stringBuffer.append(string + " = ");
        }
        stringBuffer.append(OuvrantMat + "\n");
        for (int i = n; i <= n2; ++i) {
            stringBuffer.append(OuvrantVec);
            for (int j = n3; j <= n4; ++j) {
                stringBuffer.append(PrintfFormat.d(n5, nArray[i][j]));
                if (j >= n4) continue;
                stringBuffer.append(SepareElem);
            }
            stringBuffer.append(FermantVec);
            if (i >= n2) continue;
            stringBuffer.append(SepareVec + "\n");
        }
        stringBuffer.append(FermantMat + "\n\n");
        return stringBuffer.toString();
    }

    public static String format(double[][] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        TableFormat.fixeDelim(n7);
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > 0) {
            stringBuffer.append(string + " = ");
        }
        double d = Math.pow(10.0, n6);
        stringBuffer.append(OuvrantMat + "\n");
        for (int i = n; i <= n2; ++i) {
            stringBuffer.append(OuvrantVec);
            for (int j = n3; j <= n4; ++j) {
                stringBuffer.append(' ');
                switch (n7) {
                    case 1: {
                        String string2;
                        double d2 = dArray[i][j];
                        if (d2 != 0.0 && Math.abs(d2) < 0.1 || Math.abs(d2) > d) {
                            string2 = PrintfFormat.G(0, n6, d2);
                            int n8 = string2.indexOf(69);
                            if (n8 != -1) {
                                string2 = string2.substring(0, n8) + "*10^(" + string2.substring(n8 + 1) + ")";
                            }
                        } else {
                            string2 = PrintfFormat.f(0, n6, d2);
                        }
                        string2 = PrintfFormat.s(n5, string2);
                        break;
                    }
                    default: {
                        stringBuffer.append(PrintfFormat.G(n5, n6, dArray[i][j]));
                    }
                }
                if (j >= n4) continue;
                stringBuffer.append(SepareElem);
            }
            stringBuffer.append(FermantVec);
            if (i >= n2) continue;
            stringBuffer.append(SepareVec + "\n");
        }
        stringBuffer.append(FermantMat + "\n");
        return stringBuffer.toString();
    }
}

