/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.DT_GA;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Decision_Trees.DT_GA.Individuo;
import keel.Algorithms.Decision_Trees.DT_GA.Regla;
import keel.Algorithms.Decision_Trees.DT_GA.myDataset;
import org.core.Randomize;

public class Poblacion {
    ArrayList<Individuo> cromosomas = new ArrayList();
    ArrayList<Individuo> hijos;
    ArrayList<Regla> reglas;
    myDataset train;
    int nGenerations;
    int popSize;
    int nEjemplos;
    double crossProb;
    double mutProb;
    double mejor_fitness;
    int[] ejemplos;
    int[] selectos;
    double infoG;
    double[] norm_acc;

    public boolean BETTER(double a, double b) {
        return a > b;
    }

    public Poblacion() {
        this.mejor_fitness = 0.0;
    }

    public Poblacion(int codigoRegla, Regla r, int nGenerations, int popSize, double crossProb, double mutProb, myDataset train, String clase) {
        int i;
        this.hijos = new ArrayList();
        this.reglas = new ArrayList();
        this.train = train;
        boolean[] atributos = new boolean[train.getnInputs()];
        for (i = 0; i < atributos.length; ++i) {
            atributos[i] = true;
        }
        for (i = 0; i < r.size(); ++i) {
            atributos[r.antecedente.get((int)i).getAtributo()] = false;
        }
        this.nGenerations = nGenerations;
        this.popSize = popSize;
        this.crossProb = crossProb;
        this.mutProb = mutProb;
        this.nEjemplos = r.cubiertos();
        this.ejemplos = (int[])r.ejemplosCubiertos.clone();
        this.mejor_fitness = 0.0;
        this.selectos = new int[popSize];
        this.inicializaPoblacion(atributos, clase, codigoRegla);
        this.calculaInfoG();
    }

    public Poblacion(boolean[] ejemplosTr, int nGenerations, int popSize, double crossProb, double mutProb, myDataset train, double[] norm_acc) {
        this.hijos = new ArrayList();
        this.reglas = new ArrayList();
        this.train = train;
        this.escogerEjemplos(ejemplosTr);
        this.nGenerations = nGenerations;
        this.popSize = popSize;
        this.crossProb = crossProb;
        this.mutProb = mutProb;
        this.mejor_fitness = 0.0;
        this.selectos = new int[popSize];
        this.norm_acc = (double[])norm_acc.clone();
    }

    private void inicializaPoblacion(boolean[] atributos, String clase, int codigoRegla) {
        for (int i = 0; i < this.popSize; ++i) {
            Individuo ind = new Individuo(atributos, clase, this.train, codigoRegla);
            this.cromosomas.add(ind);
        }
    }

    private void inicializaPoblacion() {
        for (int i = 0; i < this.popSize; ++i) {
            int semilla = this.ejemplos[Randomize.RandintClosed(0, this.nEjemplos - 1)];
            Individuo ind = new Individuo(this.train, semilla);
            this.cromosomas.add(ind);
        }
    }

    public String printString() {
        String cadena = new String("");
        for (int i = 0; i < this.popSize; ++i) {
            cadena = cadena + "Chromosome[" + (i + 1) + "]: " + this.cromosomas.get(i).printString();
        }
        return cadena;
    }

    public void GA_Small() {
        this.clasifica(this.cromosomas, 0);
        for (int i = 0; i < this.nGenerations; ++i) {
            this.selection();
            this.crossover();
            this.mutation();
            this.rule_pruning();
            this.clasifica(this.hijos, i);
            this.elitist();
        }
        Collections.sort(this.cromosomas);
        this.reglas.add(this.cromosomas.get(0).convertir());
    }

    private void clasifica(ArrayList<Individuo> individuos, int generation) {
        boolean entrar = false;
        for (int i = 0; i < individuos.size(); ++i) {
            double fitness;
            if (!individuos.get((int)i).n_e || !((fitness = individuos.get(i).clasifica(this.ejemplos, this.nEjemplos)) > this.mejor_fitness)) continue;
            this.mejor_fitness = fitness;
            entrar = true;
        }
        if (entrar) {
            System.out.println("Best Fitness obtained in generation[" + generation + "]: " + this.mejor_fitness);
        }
    }

    void torneo(int indice, int cromosoma1, int cromosoma2) {
        this.selectos[indice] = this.BETTER(this.cromosomas.get((int)cromosoma1).fitness, this.cromosomas.get((int)cromosoma2).fitness) ? cromosoma1 : cromosoma2;
    }

    private void selection() {
        int inicio;
        this.hijos.clear();
        for (int i = inicio = 0; i < this.cromosomas.size(); ++i) {
            int aleatorio2;
            int aleatorio1 = Randomize.RandintClosed(0, this.cromosomas.size() - 1);
            while (aleatorio1 == (aleatorio2 = Randomize.RandintClosed(0, this.cromosomas.size() - 1))) {
            }
            this.torneo(i, aleatorio1, aleatorio2);
        }
    }

    private void elitist() {
        Collections.sort(this.cromosomas);
        Individuo mejor = this.cromosomas.get(0).clone();
        this.cromosomas.clear();
        this.cromosomas.add(mejor);
        int posicion = Randomize.RandintClosed(0, this.hijos.size() - 1);
        this.hijos.remove(posicion);
        for (int i = 0; i < this.hijos.size(); ++i) {
            Individuo nuevo = this.hijos.get(i).clone();
            this.cromosomas.add(nuevo);
        }
    }

    private void crossover() {
        for (int i = 0; i < this.selectos.length / 2; ++i) {
            Individuo padre = this.cromosomas.get(this.selectos[i]);
            Individuo madre = this.cromosomas.get(this.selectos[i + 1]);
            if (Randomize.Rand() < this.crossProb) {
                int puntoCorte = Randomize.RandintClosed(1, padre.size() - 2);
                Individuo hijo1 = new Individuo(padre, madre, puntoCorte);
                Individuo hijo2 = new Individuo(madre, padre, puntoCorte);
                this.hijos.add(hijo1);
                this.hijos.add(hijo2);
                continue;
            }
            this.hijos.add(padre.clone());
            this.hijos.add(madre.clone());
        }
    }

    private void mutation() {
        for (int i = 0; i < this.hijos.size(); ++i) {
            if (!this.hijos.get((int)i).n_e) continue;
            this.hijos.get(i).mutar(this.mutProb);
        }
    }

    public int numEjemplos(int clase) {
        int n_ejemplos = 0;
        for (int i = 0; i < this.nEjemplos; ++i) {
            if (clase != this.train.getOutputAsInteger(this.ejemplos[i])) continue;
            ++n_ejemplos;
        }
        return n_ejemplos;
    }

    private void calculaInfoG() {
        int c = this.train.getnClasses();
        double sum = 0.0;
        for (int i = 0; i < c; ++i) {
            double aux = 1.0 * (double)this.numEjemplos(i) / (double)this.nEjemplos;
            sum += aux * (Math.log(aux) / Math.log(2.0));
        }
        this.infoG = -sum;
    }

    private void rule_pruning() {
        for (int i = 0; i < this.hijos.size(); ++i) {
            this.hijos.get(i).pruning(this.infoG, this.nEjemplos, this.ejemplos);
        }
    }

    public void escogerEjemplos(boolean[] ejemplos) {
        this.nEjemplos = 0;
        this.ejemplos = new int[ejemplos.length];
        for (int i = 0; i < ejemplos.length; ++i) {
            if (!ejemplos[i]) continue;
            this.ejemplos[this.nEjemplos] = i;
            ++this.nEjemplos;
        }
    }

    public void GA_Large() {
        System.out.println("#Examples Remaining in Training-Set-2 -> " + this.nEjemplos);
        while (this.nEjemplos > 5) {
            this.mejor_fitness = 0.0;
            this.cromosomas.clear();
            this.hijos.clear();
            this.inicializaPoblacion();
            this.clasificaLarge(this.cromosomas, 0);
            for (int i = 0; i < this.nGenerations; ++i) {
                this.selection();
                this.crossover();
                this.mutation();
                this.rule_pruning_large();
                this.clasificaLarge(this.hijos, i);
                this.elitist();
            }
            Collections.sort(this.cromosomas);
            this.reglas.add(this.cromosomas.get(0).convertir());
            this.niching();
        }
    }

    private void clasificaLarge(ArrayList<Individuo> individuos, int generation) {
        boolean entrar = false;
        for (int i = 0; i < individuos.size(); ++i) {
            double fitness;
            if (!individuos.get((int)i).n_e || !((fitness = individuos.get(i).clasificaLarge(this.ejemplos, this.nEjemplos)) > this.mejor_fitness)) continue;
            this.mejor_fitness = fitness;
            entrar = true;
        }
    }

    private void rule_pruning_large() {
        for (int i = 0; i < this.hijos.size(); ++i) {
            this.hijos.get(i).pruning(this.norm_acc);
        }
    }

    private void niching() {
        Regla r = this.reglas.get(this.reglas.size() - 1);
        r.cubrirEjemplos();
        int[] ejsCubiertosOK = new int[this.train.size()];
        ejsCubiertosOK = (int[])r.ejemplosBienCubiertos.clone();
        int ejemplosOK = r.cubiertosOK();
        for (int i = 0; i < this.nEjemplos; ++i) {
            boolean salir = false;
            for (int j = 0; j < ejemplosOK && !salir; ++j) {
                salir = ejsCubiertosOK[j] == this.ejemplos[i];
            }
            if (!salir) continue;
            this.ejemplos[i] = this.ejemplos[this.nEjemplos - 1];
            --this.nEjemplos;
            --i;
        }
    }

    public ArrayList<Regla> dameReglas() {
        return this.reglas;
    }
}

