/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.ErlangDist;
import umontreal.iro.lecuyer.probdist.ExponentialDist;
import umontreal.iro.lecuyer.randvar.ErlangGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ErlangConvolutionGen
extends ErlangGen {
    public ErlangConvolutionGen(RandomStream s, int k, double lambda) {
        super(s, null);
        this.setParams(k, lambda);
    }

    public ErlangConvolutionGen(RandomStream s, int k) {
        this(s, k, 1.0);
    }

    public ErlangConvolutionGen(RandomStream s, ErlangDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getK(), dist.getLambda());
        }
    }

    public double nextDouble() {
        return ErlangConvolutionGen.convolution(this.stream, this.k, this.lambda);
    }

    public static double nextDouble(RandomStream s, int k, double lambda) {
        return ErlangConvolutionGen.convolution(s, k, lambda);
    }

    private static double convolution(RandomStream s, int k, double lambda) {
        double x = 0.0;
        for (int i = 0; i < k; ++i) {
            x += ExponentialDist.inverseF(lambda, s.nextDouble());
        }
        return x;
    }
}

