/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Classifier;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelVector;
import cc.mallet.types.MatrixOps;

public class ClassifierEnsemble
extends Classifier {
    Classifier[] ensemble;
    double[] weights;

    public ClassifierEnsemble(Classifier[] classifiers, double[] weights) {
        this.ensemble = new Classifier[classifiers.length];
        for (int i = 0; i < classifiers.length; ++i) {
            if (i > 0 && this.ensemble[i - 1].getLabelAlphabet() != classifiers[i].getLabelAlphabet()) {
                throw new IllegalStateException("LabelAlphabet's do not match.");
            }
            this.ensemble[i] = classifiers[i];
        }
        System.arraycopy(classifiers, 0, this.ensemble, 0, classifiers.length);
        this.weights = (double[])weights.clone();
    }

    @Override
    public Classification classify(Instance instance) {
        int numLabels = this.ensemble[0].getLabelAlphabet().size();
        double[] scores = new double[numLabels];
        for (int i = 0; i < this.ensemble.length; ++i) {
            Classification c = this.ensemble[i].classify(instance);
            c.getLabelVector().addTo(scores, this.weights[i]);
        }
        ClassifierEnsemble.expNormalize(scores);
        return new Classification(instance, this, new LabelVector(this.ensemble[0].getLabelAlphabet(), scores));
    }

    private static void expNormalize(double[] a) {
        int i;
        double max = MatrixOps.max(a);
        double sum = 0.0;
        for (i = 0; i < a.length; ++i) {
            assert (!Double.isNaN(a[i]));
            a[i] = Math.exp(a[i] - max);
            sum += a[i];
        }
        i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] / sum;
        }
    }
}

