/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.IStateVector;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.StoredInt;
import choco.kernel.memory.trailing.trail.StoredVectorTrail;

public final class StoredVector<E>
implements IStateVector<E> {
    private Object[] elementData;
    public int[] worldStamps;
    private StoredInt size;
    private final EnvironmentTrailing environment;
    protected final StoredVectorTrail myTrail;

    public StoredVector(EnvironmentTrailing env) {
        int initialCapacity = 8;
        int w = env.getWorldIndex();
        this.environment = env;
        this.elementData = new Object[initialCapacity];
        this.worldStamps = new int[initialCapacity];
        this.size = new StoredInt(env, 0);
        this.myTrail = env.getVectorTrail();
    }

    public StoredVector(int[] entries) {
        throw new UnsupportedOperationException();
    }

    private boolean rangeCheck(int index) {
        return index < this.size.get() && index >= 0;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int[] oldStamps = this.worldStamps;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            this.worldStamps = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size.get());
            System.arraycopy(oldStamps, 0, this.worldStamps, 0, this.size.get());
        }
    }

    @Override
    public boolean add(E i) {
        int newsize = this.size.get() + 1;
        this.ensureCapacity(newsize);
        this.size.set(newsize);
        this.elementData[newsize - 1] = i;
        this.worldStamps[newsize - 1] = this.environment.getWorldIndex();
        return true;
    }

    @Override
    public void removeLast() {
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public E get(int index) {
        if (this.rangeCheck(index)) {
            return (E)this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public E set(int index, E val) {
        if (this.rangeCheck(index)) {
            assert (this.worldStamps[index] <= this.environment.getWorldIndex());
            Object oldValue = this.elementData[index];
            if (val != oldValue) {
                int oldStamp = this.worldStamps[index];
                if (oldStamp < this.environment.getWorldIndex()) {
                    this.myTrail.savePreviousState(this, index, oldValue, oldStamp);
                    this.worldStamps[index] = this.environment.getWorldIndex();
                }
                this.elementData[index] = val;
            }
            return (E)oldValue;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    public E _set(int index, Object val, int stamp) {
        assert (this.rangeCheck(index));
        Object oldval = this.elementData[index];
        this.elementData[index] = val;
        this.worldStamps[index] = stamp;
        return (E)oldval;
    }
}

