/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui.main;

import com.qarks.util.files.diff.ui.DiffPanel;
import com.qarks.util.files.diff.ui.DiffProvider;
import com.qarks.util.files.diff.ui.DirDiffPanel;
import com.qarks.util.files.diff.ui.MergePanel;
import com.qarks.util.stream.FileHelper;
import com.qarks.util.ui.swing.FileChooserUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class DiffMergePanel
extends JPanel
implements DiffProvider {
    private DirDiffPanel dirDiffEditor;
    private DiffPanel diffEditor;
    private MergePanel mergeEditor;
    private JTabbedPane tabbedPane = new JTabbedPane();

    public DiffMergePanel() {
        this.diffEditor = new DiffPanel("");
        this.mergeEditor = new MergePanel("-", "-", "");
        this.dirDiffEditor = new DirDiffPanel(this);
        this.diffEditor.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.mergeEditor.setBorder(new EmptyBorder(10, 10, 10, 10));
        JButton jButton = new JButton("Save merge");
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.mergeEditor.addExternalButton(jButton);
        jPanel.add((Component)this.mergeEditor, "Center");
        this.tabbedPane.add((Component)this.diffEditor, "File Diff");
        this.tabbedPane.add((Component)this.dirDiffEditor, "Folder Diff");
        this.tabbedPane.add((Component)jPanel, "3-Way Merge");
        this.setLayout(new GridLayout(1, 1));
        this.add(this.tabbedPane);
        this.diffEditor.enableFileDrop();
        this.mergeEditor.enableFileDrop();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = FileChooserUtilities.selectFile(DiffMergePanel.this.mergeEditor, "Save merged file", true, null, null);
                if (file != null) {
                    String string = DiffMergePanel.this.mergeEditor.getMergedFileContent();
                    try {
                        FileHelper.writeContentToFile(string, file);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object[] objectArray = new Object[]{"Ok"};
                        JOptionPane.showOptionDialog(DiffMergePanel.this.mergeEditor, "An error occured: " + iOException.getMessage(), "Save merge to file", -1, 0, null, objectArray, objectArray[0]);
                    }
                }
            }
        });
    }

    @Override
    public void compareFiles(Component component, File file, File file2) {
        this.tabbedPane.setSelectedIndex(0);
        this.diffEditor.launchDiff(file, file2);
    }

    public void doDirDiff() {
        this.tabbedPane.setSelectedIndex(1);
        this.dirDiffEditor.compareFolders();
    }

    public void doDiff() {
        this.tabbedPane.setSelectedIndex(0);
        this.diffEditor.openInputDialog(SwingUtilities.getWindowAncestor(this), null, null);
    }

    public void doMerge() {
        this.tabbedPane.setSelectedIndex(2);
        this.mergeEditor.openInputDialog(SwingUtilities.getWindowAncestor(this), null, null, null);
    }

    public String getMergeResult() {
        return this.mergeEditor.getMergedFileContent();
    }
}

