/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.http;

import com.qarks.util.PreferenceManager;
import com.qarks.util.stream.Base64Helper;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class ProxySettings {
    public static final String USES_PROXY = "com.qarks.websearch.proxy.set";
    public static final String PROXY_HOST = "com.qarks.websearch.proxy.host";
    public static final String PROXY_PORT = "com.qarks.websearch.proxy.port";
    public static final String PROXY_LOGIN = "com.qarks.websearch.proxy.login";
    public static final String PROXY_PASSWORD = "com.qarks.websearch.proxy.password";
    public static final String PROXY_EXCLUDE = "com.qarks.websearch.proxy.exclude";

    public static void getAndApplyProxySettings(PreferenceManager preferenceManager) throws IOException {
        boolean bl = "true".equals(preferenceManager.getProperty(USES_PROXY, "false"));
        System.setProperty("http.proxySet", bl ? "true" : "false");
        if (bl) {
            String string = preferenceManager.getProperty(PROXY_HOST, "");
            System.setProperty("http.proxyHost", string);
            System.setProperty("socksProxyHost", string);
            String string2 = preferenceManager.getProperty(PROXY_PORT, "");
            System.setProperty("http.proxyPort", string2);
            System.setProperty("socksProxyPort ", string2);
            final String string3 = preferenceManager.getProperty(PROXY_LOGIN, "");
            System.setProperty("http.proxyUser", string3);
            final String string4 = Base64Helper.convertBase64StringToString(preferenceManager.getProperty(PROXY_PASSWORD, ""));
            System.setProperty("http.proxyPassword", string4);
            String string5 = preferenceManager.getProperty(PROXY_EXCLUDE, "");
            System.setProperty("http.nonProxyHosts", string5);
            if (bl) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(string3, string4.toCharArray());
                    }
                });
            }
        } else {
            System.setProperty("http.proxyHost", "");
            System.setProperty("socksProxyHost", "");
            System.setProperty("http.proxyUser", "");
            System.setProperty("http.proxyPassword", "");
            System.setProperty("http.nonProxyHosts", "");
        }
    }

    public static void setProxySettings(PreferenceManager preferenceManager, boolean bl, String string, int n, String string2, String string3, String string4) throws IOException {
        preferenceManager.setProperty(USES_PROXY, bl ? "true" : "false");
        preferenceManager.setProperty(PROXY_HOST, string);
        preferenceManager.setProperty(PROXY_PORT, Integer.toString(n));
        preferenceManager.setProperty(PROXY_LOGIN, string2);
        preferenceManager.setProperty(PROXY_PASSWORD, Base64Helper.convertStringToBase64String(string3));
        preferenceManager.setProperty(PROXY_EXCLUDE, string4);
        preferenceManager.flush();
        ProxySettings.getAndApplyProxySettings(preferenceManager);
    }
}

