/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semver4j.SemverException;
import org.semver4j.internal.Tokenizers;

public class StrictParser {
    private static final Pattern pattern = Pattern.compile(Tokenizers.STRICT);
    private static final BigInteger maxInt = BigInteger.valueOf(Integer.MAX_VALUE);

    public Version parse(String version) {
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            throw new SemverException(String.format(Locale.ROOT, "Version [%s] is not valid semver.", version));
        }
        int major = this.parseInt(matcher.group(1));
        int minor = this.parseInt(matcher.group(2));
        int patch = this.parseInt(matcher.group(3));
        List<String> preRelease = this.convertToList(matcher.group(4));
        List<String> build = this.convertToList(matcher.group(5));
        return new Version(major, minor, patch, preRelease, build);
    }

    private int parseInt(String maybeInt) {
        BigInteger secureNumber = new BigInteger(maybeInt);
        if (maxInt.compareTo(secureNumber) < 0) {
            throw new SemverException(String.format(Locale.ROOT, "Value [%s] is too big.", maybeInt));
        }
        return secureNumber.intValueExact();
    }

    private List<String> convertToList(String toList) {
        return toList == null ? Collections.emptyList() : Arrays.asList(toList.split("\\."));
    }

    public static class Version {
        private final int major;
        private final int minor;
        private final int patch;
        private final List<String> preRelease;
        private final List<String> build;

        Version(int major, int minor, int patch, List<String> preRelease, List<String> build) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.preRelease = preRelease;
            this.build = build;
        }

        Version(int major, int minor, int patch) {
            this(major, minor, patch, Collections.emptyList(), Collections.emptyList());
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public List<String> getPreRelease() {
            return this.preRelease;
        }

        public List<String> getBuild() {
            return this.build;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version that = (Version)o;
            return this.major == that.major && Objects.equals(this.minor, that.minor) && Objects.equals(this.patch, that.patch) && Objects.equals(this.preRelease, that.preRelease) && Objects.equals(this.build, that.build);
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.patch, this.preRelease, this.build);
        }

        public String toString() {
            return new StringJoiner(", ", Version.class.getSimpleName() + "[", "]").add("major=" + this.major).add("minor=" + this.minor).add("patch=" + this.patch).add("preRelease=" + this.preRelease).add("build=" + this.build).toString();
        }
    }
}

