## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ggsegmentedtotalbar)

## ----example------------------------------------------------------------------
# Example data frame
df_ex <- data.frame(
  group = c("A", "A","A","B", "B","B","C","C","C","D","D","D"),
  segment = c("X","Y","Z", "X","Y","Z", "X","Y","Z","X","Y","Z"),
  value = c(10, 20, 30, 40,50,60, 70,80,90, 100, 110, 120),
  total = c(60,60,60, 150,150,150, 240,240,240, 360,360,360)
)

## ----example1-----------------------------------------------------------------
# Create the segmented total bar plot
p <- ggsegmentedtotalbar(df_ex, "group", "segment", "value", "total")
# Print the plot
print(p)

## ----example2-----------------------------------------------------------------
# Create the segmented total bar plot with labels
p <- ggsegmentedtotalbar(df_ex, "group", "segment", "value", "total",
                         label = TRUE, label_size = 4, label_color = "black")
# Print the plot
print(p)

## ----example3-----------------------------------------------------------------
# Create the segmented total bar plot with labels and different total box. 
p <- ggsegmentedtotalbar(df_ex, "group", "segment", "value", "total",
                         label = TRUE, label_size = 4, label_color = "black",
                         alpha = 0.2, color = "steelblue")
# Print the plot
print(p)

## ----example4-----------------------------------------------------------------
# Create the segmented total bar plot with labels and different total box.
p <- ggsegmentedtotalbar(df_ex, "group", "segment", "value", "total",
                         label = TRUE, label_size = 4, label_color = "black",
                         alpha = 0.2, color = "steelblue") +
  ggplot2::labs(title = "Segmented Total Bar Plot with Custom Annotations",
                x = "Group", y= "Value") +
  ggplot2::theme_test() +
  ggplot2::theme(
    plot.title = ggplot2::element_text(hjust = 0.5),
    axis.text.x = ggplot2::element_text(face= "bold", hjust = 1),
    axis.text.y = ggplot2::element_text(face= "bold", hjust = 1),
    legend.position = "top",
    legend.title = ggplot2::element_blank(),
  )

# Print the plot
print(p)

