## ----config, echo = FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  tidy = TRUE,
  cache = FALSE,
  dev = "png"
)

## ----install-github, eval = FALSE---------------------------------------------
#  devtools::install_github("jichunxie/sifinet")

## ----load_data----------------------------------------------------------------
# Load package
library(SiFINeT)

# Load data

data <- readRDS("toy_matrix.rds")
sifi_obj <- create_SiFINeT_object(
  counts = data,
  gene.name = NULL,
  meta.data = NULL,
  data.name = NULL,
  sparse = FALSE,
  rowfeature = TRUE
)

## ----network1-----------------------------------------------------------------
# estimate the quantiles
sifi_obj <- quantile_thres(sifi_obj)
sifi_obj <- feature_coexp(sifi_obj)

## ----network2-----------------------------------------------------------------
# build the co-expression network
sifi_obj <- create_network(sifi_obj,
  alpha = 0.05, manual = FALSE,
  least_edge_prop = 0.01
)

## ----network3-----------------------------------------------------------------
# filter gene to improve the quality of the co-expression network
sifi_obj <- filter_lowexp(sifi_obj, t1 = 10, t2 = 0.9, t3 = 0.9)

## ----feature1-----------------------------------------------------------------
# calculate connectivity for each gene
sifi_obj <- cal_connectivity(sifi_obj, m = 10, niter = 100)

## ----feature2-----------------------------------------------------------------
# detect core feature gene sets
sifi_obj <- find_unique_feature(sifi_obj,
  t1 = 5,
  t2 = 0.4,
  t3 = 0.3,
  t1p = 5,
  t2p = 0.7,
  t3p = 0.5,
  resolution = 1,
  min_set_size = 5
)

## ----feature3-----------------------------------------------------------------
# assign shared feature genes to core feature gene sets
sifi_obj <- assign_shared_feature(sifi_obj, min_edge_prop = 0.5)

## ----feature4-----------------------------------------------------------------
# enrich feature gene sets with other genes
sifi_obj <- enrich_feature_set(sifi_obj, min_edge_prop = 0.9)

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

