/*
 * Decompiled with CFR 0.152.
 */
package choco;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.ComponentConstraintWithSubConstraints;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.MetaConstraint;
import choco.kernel.model.constraints.MetaTaskConstraint;
import choco.kernel.model.constraints.TemporalConstraint;
import choco.kernel.model.constraints.automaton.DFA;
import choco.kernel.model.constraints.automaton.FA.IAutomaton;
import choco.kernel.model.constraints.automaton.FA.ICostAutomaton;
import choco.kernel.model.constraints.automaton.penalty.IPenaltyFunction;
import choco.kernel.model.constraints.cnf.ALogicTree;
import choco.kernel.model.constraints.cnf.LogicTreeToolBox;
import choco.kernel.model.constraints.cnf.Singleton;
import choco.kernel.model.constraints.geost.GeostOptions;
import choco.kernel.model.constraints.geost.externalConstraints.DistGeqModel;
import choco.kernel.model.constraints.geost.externalConstraints.DistLeqModel;
import choco.kernel.model.constraints.geost.externalConstraints.IExternalConstraint;
import choco.kernel.model.constraints.pack.PackModel;
import choco.kernel.model.variables.AbstractVariable;
import choco.kernel.model.variables.ConstantFactory;
import choco.kernel.model.variables.Operator;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.geost.GeostObject;
import choco.kernel.model.variables.geost.ShiftedBox;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.integer.MetaIntegerExpressionVariable;
import choco.kernel.model.variables.real.RealConstantVariable;
import choco.kernel.model.variables.real.RealExpressionVariable;
import choco.kernel.model.variables.real.RealVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.model.variables.set.SetConstantVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.model.variables.tree.TreeParametersObject;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.global.automata.fast_costregular.structure.Arc;
import choco.kernel.solver.constraints.global.automata.fast_costregular.structure.Node;
import choco.kernel.solver.constraints.global.scheduling.ResourceParameters;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.CouplesBitSetTable;
import choco.kernel.solver.constraints.integer.extension.CouplesTable;
import choco.kernel.solver.constraints.integer.extension.ExtensionalBinRelation;
import choco.kernel.solver.constraints.integer.extension.IterTuplesTable;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.constraints.integer.extension.TuplesList;
import choco.kernel.solver.constraints.integer.extension.TuplesTable;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgrapht.graph.DirectedMultigraph;

public class Choco {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    public static final int MIN_LOWER_BOUND = -21474836;
    public static final int MAX_UPPER_BOUND = 21474836;
    public static final IntegerVariable ZERO = Choco.constant(0);
    public static final IntegerVariable ONE = Choco.constant(1);
    public static final Constraint TRUE = new ComponentConstraint(ConstraintType.TRUE, (Object)true, (Variable[])new IntegerVariable[0]);
    public static final Constraint FALSE = new ComponentConstraint(ConstraintType.FALSE, (Object)false, (Variable[])new IntegerVariable[0]);

    Choco() {
    }

    private static void checkIntVarBounds(int lowB, int uppB) {
        if (lowB > uppB) {
            throw new ModelException("makeIntVar : lowB > uppB");
        }
        if (lowB < -21474836 || uppB > 21474836) {
            LOGGER.warning("WARNING! Domains over [-21474836, 21474836] are strongly inadvisable ! ");
        }
    }

    public static IntegerVariable makeIntVar(String name, int lowB, int uppB, String ... options) {
        Choco.checkIntVarBounds(lowB, uppB);
        IntegerVariable v = new IntegerVariable(name, lowB, uppB);
        for (String option : options) {
            v.addOption(option);
        }
        return v;
    }

    public static IntegerVariable makeIntVar(String name, String ... options) {
        return Choco.makeIntVar(name, -21474836, 21474836, options);
    }

    private static int[] makeValues(int[] valuesArray) {
        int[] values = ArrayUtils.getNonRedundantSortedValues(valuesArray);
        Choco.checkIntVarBounds(values[0], values[values.length - 1]);
        return values;
    }

    private static IntegerVariable unsafeMakeIntVar(String name, int[] nonRedundantSortedvalues, String ... options) {
        IntegerVariable v = new IntegerVariable(name, nonRedundantSortedvalues);
        v.addOptions(options);
        return v;
    }

    public static IntegerVariable makeIntVar(String name, TIntArrayList valuesList, String ... options) {
        int[] values = ArrayUtils.getNonRedundantSortedValues(valuesList);
        Choco.checkIntVarBounds(values[0], values[values.length - 1]);
        return Choco.unsafeMakeIntVar(name, values, options);
    }

    public static IntegerVariable makeIntVar(String name, List<Integer> valuesList, String ... options) {
        int[] _values = new int[valuesList.size()];
        for (int i = 0; i < valuesList.size(); ++i) {
            _values[i] = valuesList.get(i);
        }
        int[] values = ArrayUtils.getNonRedundantSortedValues(_values);
        Choco.checkIntVarBounds(values[0], values[values.length - 1]);
        return Choco.unsafeMakeIntVar(name, values, options);
    }

    public static IntegerVariable makeIntVar(String name, int[] valuesArray, String ... options) {
        return Choco.unsafeMakeIntVar(name, Choco.makeValues(valuesArray), options);
    }

    public static IntegerVariable makeBooleanVar(String name, String ... options) {
        IntegerVariable v = new IntegerVariable(name, 0, 1);
        for (String option : options) {
            v.addOption(option);
        }
        return v;
    }

    public static IntegerVariable[] makeBooleanVarArray(String name, int dim, String ... options) {
        IntegerVariable[] vars = new IntegerVariable[dim];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.makeBooleanVar(name + "_" + i, options);
        }
        return vars;
    }

    public static IntegerVariable[] makeIntVarArray(String name, int dim, int lowB, int uppB, String ... options) {
        IntegerVariable[] vars = new IntegerVariable[dim];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.makeIntVar(name + "_" + i, lowB, uppB, options);
        }
        return vars;
    }

    public static IntegerVariable[] makeIntVarArray(String name, int dim, String ... options) {
        return Choco.makeIntVarArray(name, dim, -21474836, 21474836, options);
    }

    public static IntegerVariable[] makeIntVarArray(String name, int dim, int[] valuesArray, String ... options) {
        int[] values = Choco.makeValues(valuesArray);
        IntegerVariable[] vars = new IntegerVariable[dim];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.unsafeMakeIntVar(name + "_" + i, Arrays.copyOf(values, values.length), options);
        }
        return vars;
    }

    public static IntegerVariable[] makeIntVarArray(String name, int dim, TIntArrayList valuesArray, String ... options) {
        int[] values = Choco.makeValues(valuesArray.toNativeArray());
        IntegerVariable[] vars = new IntegerVariable[dim];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.unsafeMakeIntVar(name + "_" + i, Arrays.copyOf(values, values.length), options);
        }
        return vars;
    }

    public static IntegerVariable[] makeIntVarArray(String name, int dim, List<Integer> valuesList, String ... options) {
        int[] _values = new int[valuesList.size()];
        for (int i = 0; i < valuesList.size(); ++i) {
            _values[i] = valuesList.get(i);
        }
        int[] values = Choco.makeValues(_values);
        IntegerVariable[] vars = new IntegerVariable[dim];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.unsafeMakeIntVar(name + "_" + i, Arrays.copyOf(values, values.length), options);
        }
        return vars;
    }

    public static IntegerVariable[][] makeIntVarArray(String name, int dim1, int dim2, int lowB, int uppB, String ... options) {
        IntegerVariable[][] vars = new IntegerVariable[dim1][dim2];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.makeIntVarArray(name + "_" + i, dim2, lowB, uppB, options);
        }
        return vars;
    }

    public static IntegerVariable[][] makeIntVarArray(String name, int dim1, int dim2, String ... options) {
        return Choco.makeIntVarArray(name, dim1, dim2, -21474836, 21474836, options);
    }

    public static IntegerVariable[][] makeIntVarArray(String name, int dim1, int dim2, int[] valuesArray, String ... options) {
        int[] values = Choco.makeValues(valuesArray);
        IntegerVariable[][] vars = new IntegerVariable[dim1][dim2];
        for (int i = 0; i < vars.length; ++i) {
            for (int j = 0; j < vars[i].length; ++j) {
                vars[i][j] = Choco.unsafeMakeIntVar(name + "_" + i + "_" + j, Arrays.copyOf(values, values.length), options);
            }
        }
        return vars;
    }

    public static IntegerVariable[][] makeIntVarArray(String name, int dim1, int dim2, TIntArrayList valuesArray, String ... options) {
        int[] values = Choco.makeValues(valuesArray.toNativeArray());
        IntegerVariable[][] vars = new IntegerVariable[dim1][dim2];
        for (int i = 0; i < vars.length; ++i) {
            for (int j = 0; j < vars[i].length; ++j) {
                vars[i][j] = Choco.unsafeMakeIntVar(name + "_" + i + "_" + j, Arrays.copyOf(values, values.length), options);
            }
        }
        return vars;
    }

    public static IntegerVariable[][] makeIntVarArray(String name, int dim1, int dim2, List<Integer> valuesList, String ... options) {
        int[] _values = new int[valuesList.size()];
        for (int i = 0; i < valuesList.size(); ++i) {
            _values[i] = valuesList.get(i);
        }
        int[] values = Choco.makeValues(_values);
        IntegerVariable[][] vars = new IntegerVariable[dim1][dim2];
        for (int i = 0; i < vars.length; ++i) {
            for (int j = 0; j < vars[i].length; ++j) {
                vars[i][j] = Choco.unsafeMakeIntVar(name + "_" + i + "_" + j, Arrays.copyOf(values, values.length), options);
            }
        }
        return vars;
    }

    public static SetVariable makeSetVar(String name, int lowB, int uppB, String ... options) {
        int c = uppB - lowB + 1;
        IntegerVariable card = Choco.makeIntVar("|" + name + "|", 0, c, options);
        SetVariable var = new SetVariable(name, lowB, uppB, card);
        for (String option : options) {
            var.addOption(option);
        }
        return var;
    }

    public static SetVariable makeSetVar(String name, int[] valuesArray, String ... options) {
        int[] values2 = new int[valuesArray.length];
        System.arraycopy(valuesArray, 0, values2, 0, valuesArray.length);
        Arrays.sort(values2);
        int c = values2.length;
        IntegerVariable card = Choco.makeIntVar("|" + name + "|", 0, c, options);
        SetVariable var = new SetVariable(name, values2, card);
        for (String option : options) {
            var.addOption(option);
        }
        return var;
    }

    public static SetVariable[] makeSetVarArray(String name, int dim, int lowB, int uppB, String ... options) {
        SetVariable[] vars = new SetVariable[dim];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.makeSetVar(name + "_" + i, lowB, uppB, options);
        }
        return vars;
    }

    public static RealVariable makeRealVar(String name, double lowB, double uppB, String ... options) {
        if (lowB > uppB) {
            throw new ModelException("makeRealVar : lowB > uppB");
        }
        RealVariable v = new RealVariable(name, lowB, uppB);
        for (String option : options) {
            v.addOption(option);
        }
        return v;
    }

    public static TaskVariable makeTaskVar(String name, IntegerVariable start, IntegerVariable end, IntegerVariable duration, String ... options) {
        TaskVariable tv = new TaskVariable(name, start, end, duration);
        tv.addOptions(options);
        return tv;
    }

    public static TaskVariable makeTaskVar(String name, IntegerVariable start, IntegerVariable duration, String ... options) {
        IntegerVariable end = Choco.makeIntVar("end-" + name, 0, start.getUppB() + duration.getUppB(), options);
        TaskVariable tv = new TaskVariable(name, start, end, duration);
        for (String opt : options) {
            tv.addOption(opt);
        }
        return tv;
    }

    public static TaskVariable makeTaskVar(String name, int binf, int bsup, IntegerVariable duration, String ... options) {
        IntegerVariable start = Choco.makeIntVar("start-" + name, binf, bsup, options);
        IntegerVariable end = Choco.makeIntVar("end-" + name, binf, bsup, options);
        return Choco.makeTaskVar(name, start, end, duration, options);
    }

    public static TaskVariable makeTaskVar(String name, int binf, int bsup, int duration, String ... options) {
        return Choco.makeTaskVar(name, binf, bsup, (IntegerVariable)Choco.constant(duration), options);
    }

    public static TaskVariable makeTaskVar(String name, int bsup, IntegerVariable duration, String ... options) {
        return Choco.makeTaskVar(name, 0, bsup, duration, options);
    }

    public static TaskVariable makeTaskVar(String name, int bsup, int duration, String ... options) {
        return Choco.makeTaskVar(name, 0, bsup, (IntegerVariable)Choco.constant(duration), options);
    }

    public static TaskVariable[] makeTaskVarArray(String prefix, IntegerVariable[] starts, IntegerVariable[] ends, IntegerVariable[] durations, String ... options) {
        if (starts != null && durations != null && starts.length == durations.length) {
            if (ends == null) {
                TaskVariable[] vars = new TaskVariable[starts.length];
                for (int i = 0; i < vars.length; ++i) {
                    vars[i] = Choco.makeTaskVar(prefix + "_" + i, starts[i], durations[i], options);
                }
                return vars;
            }
            if (starts.length == ends.length) {
                TaskVariable[] vars = new TaskVariable[starts.length];
                for (int i = 0; i < vars.length; ++i) {
                    vars[i] = Choco.makeTaskVar(prefix + "_" + i, starts[i], ends[i], durations[i], options);
                }
                return vars;
            }
            throw new ModelException("invalid ends array length.");
        }
        throw new ModelException("starts and durations are required and should have equal lengths.");
    }

    public static TaskVariable[] makeTaskVarArray(String name, int[] binf, int[] bsup, IntegerVariable[] durations, String ... options) {
        int n = durations.length;
        TaskVariable[] vars = new TaskVariable[n];
        for (int i = 0; i < n; ++i) {
            vars[i] = Choco.makeTaskVar(name + "_" + i, binf[i], bsup[i], durations[i], options);
        }
        return vars;
    }

    public static TaskVariable[] makeTaskVarArray(String name, int binf, int bsup, IntegerVariable[] durations, String ... options) {
        int n = durations.length;
        TaskVariable[] vars = new TaskVariable[n];
        for (int i = 0; i < n; ++i) {
            vars[i] = Choco.makeTaskVar(name + "_" + i, binf, bsup, durations[i], options);
        }
        return vars;
    }

    public static TaskVariable[] makeTaskVarArray(String name, int binf, int bsup, int[] durations, String ... options) {
        return Choco.makeTaskVarArray(name, binf, bsup, (IntegerVariable[])Choco.constantArray(durations), options);
    }

    public static TaskVariable[][] makeTaskVarArray(String name, int binf, int bsup, IntegerVariable[][] durations, String ... options) {
        int n = durations.length;
        int m = durations[0].length;
        TaskVariable[][] vars = new TaskVariable[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                vars[i][j] = Choco.makeTaskVar(name + "_" + i + "_" + j, binf, bsup, durations[i][j], options);
            }
        }
        return vars;
    }

    public static TaskVariable[][] makeTaskVarArray(String name, int binf, int bsup, int[][] durations, String ... options) {
        return Choco.makeTaskVarArray(name, binf, bsup, Choco.constantArray(durations), options);
    }

    public static IntegerConstantVariable constant(int value) {
        return ConstantFactory.getConstant(value);
    }

    public static SetConstantVariable constant(int[] values) {
        return ConstantFactory.getConstant(values);
    }

    public static SetConstantVariable emptySet() {
        return ConstantFactory.getConstant(new int[0]);
    }

    public static RealConstantVariable constant(double value) {
        return ConstantFactory.getConstant(value);
    }

    public static IntegerConstantVariable[] constantArray(int[] values) {
        IntegerConstantVariable[] tmp = new IntegerConstantVariable[values.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = Choco.constant(values[i]);
        }
        return tmp;
    }

    public static IntegerConstantVariable[][] constantArray(int[][] values) {
        IntegerConstantVariable[][] tmp = new IntegerConstantVariable[values.length][values[0].length];
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[0].length; ++j) {
                tmp[i][j] = Choco.constant(values[i][j]);
            }
        }
        return tmp;
    }

    public static RealConstantVariable[] constantArray(double[] values) {
        RealConstantVariable[] tmp = new RealConstantVariable[values.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = Choco.constant(values[i]);
        }
        return tmp;
    }

    public static Constraint neq(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.NEQ, (Object)ConstraintType.NEQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint neq(int c, IntegerExpressionVariable x) {
        return Choco.neq(x, c);
    }

    public static Constraint neq(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.NEQ, (Object)ConstraintType.NEQ, new Variable[]{x, y});
    }

    public static Constraint geq(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{x, y});
    }

    public static Constraint geq(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint geq(int c, IntegerExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint geq(RealExpressionVariable x, RealExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{x, y});
    }

    public static Constraint geq(RealExpressionVariable x, double c) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint geq(double c, RealExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint gt(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.GT, (Object)ConstraintType.GT, new Variable[]{x, y});
    }

    public static Constraint gt(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.GT, (Object)ConstraintType.GT, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint gt(int c, IntegerExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.GT, (Object)ConstraintType.GT, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint eq(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{x, y});
    }

    public static Constraint eq(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint eq(int c, IntegerExpressionVariable x) {
        return Choco.eq(x, c);
    }

    public static Constraint eq(RealExpressionVariable x, RealExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{x, y});
    }

    public static Constraint eq(RealExpressionVariable x, double c) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint eq(double c, RealExpressionVariable x) {
        return Choco.eq(x, c);
    }

    public static Constraint eq(RealVariable r, IntegerVariable i) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{r, i});
    }

    public static Constraint eq(IntegerVariable i, RealVariable r) {
        return Choco.eq(r, i);
    }

    public static Constraint leq(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint leq(int c, IntegerExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint leq(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{x, y});
    }

    public static Constraint leq(RealExpressionVariable x, double c) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint leq(double c, RealExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint leq(RealExpressionVariable x, RealExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{x, y});
    }

    public static Constraint lt(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.LT, (Object)ConstraintType.LT, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint lt(int c, IntegerExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.LT, (Object)ConstraintType.LT, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint lt(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.LT, (Object)ConstraintType.LT, new Variable[]{x, y});
    }

    public static Constraint times(IntegerVariable x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.TIMES, null, (Variable[])new IntegerVariable[]{x, y, z});
    }

    public static Constraint times(int x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.TIMES, null, (Variable[])new IntegerVariable[]{Choco.constant(x), y, z});
    }

    public static Constraint times(IntegerVariable x, int y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.TIMES, null, (Variable[])new IntegerVariable[]{x, Choco.constant(y), z});
    }

    public static Constraint intDiv(IntegerVariable x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.EUCLIDEANDIVISION, null, (Variable[])new IntegerVariable[]{x, y, z});
    }

    public static BinRelation makeBinRelation(int[] min, int[] max, List<int[]> mat, boolean feas, boolean bitset) {
        int n1 = max[0] - min[0] + 1;
        int n2 = max[1] - min[1] + 1;
        ConsistencyRelation relation = bitset ? new CouplesBitSetTable(feas, min[0], min[1], n1, n2) : new CouplesTable(feas, min[0], min[1], n1, n2);
        for (int[] couple : mat) {
            if (couple.length != 2) {
                throw new ModelException("Wrong dimension : " + couple.length + " for a couple");
            }
            if (Choco.between(couple[0], min[0], max[0]) && Choco.between(couple[1], min[1], max[1])) {
                relation.setCouple(couple[0], couple[1]);
                continue;
            }
            LOGGER.warning("{" + couple[0] + "," + couple[1] + "} will not be added, because it doesn't respect domain bounds");
        }
        return relation;
    }

    private static boolean between(int v, int low, int upp) {
        return low <= v && v <= upp;
    }

    public static BinRelation makeBinRelation(int[] min, int[] max, List<int[]> mat, boolean feas) {
        return Choco.makeBinRelation(min, max, mat, feas, false);
    }

    public static BinRelation makeBinRelation(int[] min, int[] max, boolean[][] mat, boolean feas, boolean bitset) {
        int n1 = max[0] - min[0] + 1;
        int n2 = max[1] - min[1] + 1;
        if (n1 == mat.length && n2 == mat[0].length) {
            ExtensionalBinRelation relation = (ExtensionalBinRelation)((Object)(bitset ? new CouplesBitSetTable(feas, min[0], min[1], n1, n2) : new CouplesTable(feas, min[0], min[1], n1, n2)));
            for (int i = 0; i < n1; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (!mat[i][j]) continue;
                    relation.setCouple(i + min[0], j + min[1]);
                }
            }
            return relation;
        }
        throw new SolverException("Wrong dimension for the matrix of consistency : " + mat.length + " X " + mat[0].length + " instead of " + n1 + "X" + n2);
    }

    public static BinRelation makeBinRelation(int[] min, int[] max, boolean[][] mat, boolean feas) {
        return Choco.makeBinRelation(min, max, mat, feas, false);
    }

    private static Constraint makePairAC(String options, IntegerVariable v1, IntegerVariable v2, Object mat, boolean feas) {
        if (options == null) {
            return new ComponentConstraint(ConstraintType.TABLE, (Object)new Object[]{feas, mat}, (Variable[])new IntegerVariable[]{v1, v2});
        }
        ComponentConstraint c = new ComponentConstraint(ConstraintType.TABLE, (Object)new Object[]{feas, mat}, (Variable[])new IntegerVariable[]{v1, v2});
        c.addOption(options);
        return c;
    }

    public static Constraint infeasPairAC(IntegerVariable v1, IntegerVariable v2, List<int[]> mat) {
        return Choco.makePairAC(null, v1, v2, mat, false);
    }

    public static Constraint infeasPairAC(String options, IntegerVariable v1, IntegerVariable v2, List<int[]> mat) {
        return Choco.makePairAC(options, v1, v2, mat, false);
    }

    public static Constraint feasPairAC(IntegerVariable v1, IntegerVariable v2, List<int[]> mat) {
        return Choco.makePairAC(null, v1, v2, mat, true);
    }

    public static Constraint feasPairAC(String options, IntegerVariable v1, IntegerVariable v2, List<int[]> mat) {
        return Choco.makePairAC(options, v1, v2, mat, true);
    }

    public static Constraint infeasPairAC(IntegerVariable v1, IntegerVariable v2, boolean[][] mat) {
        return Choco.makePairAC(null, v1, v2, mat, false);
    }

    public static Constraint infeasPairAC(String options, IntegerVariable v1, IntegerVariable v2, boolean[][] mat) {
        return Choco.makePairAC(options, v1, v2, mat, false);
    }

    public static Constraint feasPairAC(IntegerVariable v1, IntegerVariable v2, boolean[][] mat) {
        return Choco.makePairAC(null, v1, v2, mat, true);
    }

    public static Constraint feasPairAC(String options, IntegerVariable v1, IntegerVariable v2, boolean[][] mat) {
        return Choco.makePairAC(options, v1, v2, mat, true);
    }

    public static Constraint relationPairAC(IntegerVariable v1, IntegerVariable v2, BinRelation binR) {
        return Choco.makePairAC(null, v1, v2, binR, false);
    }

    public static Constraint relationPairAC(String options, IntegerVariable v1, IntegerVariable v2, BinRelation binR) {
        return Choco.makePairAC(options, v1, v2, binR, false);
    }

    public static LargeRelation makeLargeRelation(int[] min, int[] max, List<int[]> tuples, boolean feas) {
        return Choco.makeLargeRelation(min, max, tuples, feas, feas ? 0 : 1);
    }

    public static LargeRelation makeLargeRelation(int[] min, int[] max, List<int[]> tuples, boolean feas, int scheme) {
        LargeRelation relation;
        int n = min.length;
        int[] offsets = new int[n];
        int[] sizes = new int[n];
        for (int i = 0; i < n; ++i) {
            sizes[i] = max[i] - min[i] + 1;
            offsets[i] = min[i];
        }
        if (scheme == 0) {
            relation = new IterTuplesTable(tuples, offsets, sizes);
        } else if (scheme == 1) {
            relation = new TuplesTable(feas, offsets, sizes);
            for (int[] tuple : tuples) {
                if (tuple.length != n) {
                    throw new SolverException("Wrong dimension : " + tuple.length + " for a tuple (should be " + n + ")");
                }
                ((TuplesTable)relation).setTuple(tuple);
            }
        } else {
            relation = new TuplesList(tuples);
        }
        return relation;
    }

    private static Constraint makeTupleACFC(String options, IntegerVariable[] vs, Object mat, boolean feas) {
        if (options == null) {
            return new ComponentConstraint(ConstraintType.TABLE, (Object)new Object[]{feas, mat}, (Variable[])vs);
        }
        ComponentConstraint c = new ComponentConstraint(ConstraintType.TABLE, (Object)new Object[]{feas, mat}, (Variable[])vs);
        c.addOption(options);
        return c;
    }

    public static Constraint infeasTupleFC(List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC("cp:fc", vars, tuples, false);
    }

    public static Constraint feasTupleFC(List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC("cp:fc", vars, tuples, true);
    }

    public static Constraint infeasTupleAC(List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC("cp:ac32", vars, tuples, false);
    }

    public static Constraint feasTupleAC(List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC("cp:ac32", vars, tuples, true);
    }

    public static Constraint infeasTupleAC(String options, List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC(options, vars, tuples, false);
    }

    public static Constraint feasTupleAC(String options, List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC(options, vars, tuples, true);
    }

    public static Constraint relationTupleFC(IntegerVariable[] vs, LargeRelation rela) {
        return Choco.makeTupleACFC("cp:fc", vs, rela, false);
    }

    public static Constraint relationTupleAC(IntegerVariable[] vs, LargeRelation rela) {
        return Choco.makeTupleACFC(null, vs, rela, false);
    }

    public static Constraint relationTupleAC(String options, IntegerVariable[] vs, LargeRelation rela) {
        return Choco.makeTupleACFC(options, vs, rela, false);
    }

    public static Constraint member(IntegerVariable var, int[] values) {
        if (values.length == 0) {
            throw new ModelException("MEMBER requirement : |values| > 0");
        }
        return new ComponentConstraint(ConstraintType.INTMEMBER, (Object)values, (Variable[])new IntegerVariable[]{var});
    }

    public static Constraint member(IntegerVariable var, int lower, int upper) {
        if (upper - lower < 0) {
            throw new ModelException("MEMBER requirement : lower <= upper");
        }
        return new ComponentConstraint(ConstraintType.INTMEMBER, (Object)new Object[]{lower, upper}, (Variable[])new IntegerVariable[]{var});
    }

    @Deprecated
    public static Constraint among(IntegerVariable var, int[] values) {
        if (values.length == 0) {
            throw new ModelException("AMONG requirement : |values| > 0");
        }
        return new ComponentConstraint(ConstraintType.INTMEMBER, (Object)values, (Variable[])new IntegerVariable[]{var});
    }

    public static Constraint among(IntegerVariable nvar, IntegerVariable[] variables, int[] values) {
        if (nvar.getLowB() < 0) {
            throw new ModelException("AMONG requirement: nvar >=0 ");
        }
        if (nvar.getUppB() > variables.length) {
            throw new ModelException("AMONG requirement : nvar <= |variables|");
        }
        if (variables.length == 0) {
            throw new ModelException("AMONG requirement : |variables| > 0");
        }
        return new ComponentConstraint(ConstraintType.INTMEMBER, (Object)values, (Variable[])ArrayUtils.append(variables, {nvar}));
    }

    public static Constraint among(IntegerVariable nvar, IntegerVariable[] variables, SetVariable svar) {
        if (nvar.getLowB() < 0) {
            throw new ModelException("AMONG requirement: nvar >=0 ");
        }
        if (nvar.getUppB() > variables.length) {
            throw new ModelException("AMONG requirement : nvar <= |variables|");
        }
        if (variables.length == 0) {
            throw new ModelException("AMONG requirement : |variables| > 0");
        }
        if (svar.getLowB() < 0) {
            throw new ModelException("AMONG requirement : svar > 0");
        }
        if (svar.getCard().getDomainSize() < 1) {
            throw new ModelException("AMONG requirement : |svar| > 0");
        }
        Variable[] vars = new Variable[variables.length + 2];
        System.arraycopy(variables, 0, vars, 0, variables.length);
        vars[variables.length] = svar;
        vars[variables.length + 1] = nvar;
        return new ComponentConstraint(ConstraintType.AMONGSET, null, vars);
    }

    public static Constraint notMember(IntegerVariable var, int[] values) {
        return new ComponentConstraint(ConstraintType.INTNOTMEMBER, (Object)values, (Variable[])new IntegerVariable[]{var});
    }

    public static Constraint notMember(IntegerVariable var, int lower, int upper) {
        return new ComponentConstraint(ConstraintType.INTNOTMEMBER, (Object)new Object[]{lower, upper}, (Variable[])new IntegerVariable[]{var});
    }

    @Deprecated
    public static Constraint disjoint(IntegerVariable var, int[] values) {
        return new ComponentConstraint(ConstraintType.INTNOTMEMBER, (Object)values, (Variable[])new IntegerVariable[]{var});
    }

    public static Constraint distanceEQ(IntegerVariable x, IntegerVariable y, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)0, (Variable[])new IntegerVariable[]{x, y, Choco.constant(c)});
    }

    public static Constraint distanceNEQ(IntegerVariable x, IntegerVariable y, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)3, (Variable[])new IntegerVariable[]{x, y, Choco.constant(c)});
    }

    public static Constraint distanceLT(IntegerVariable x, IntegerVariable y, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)1, (Variable[])new IntegerVariable[]{x, y, Choco.constant(c)});
    }

    public static Constraint distanceGT(IntegerVariable x, IntegerVariable y, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)2, (Variable[])new IntegerVariable[]{x, y, Choco.constant(c)});
    }

    public static Constraint distanceEQ(IntegerVariable x, IntegerVariable y, IntegerVariable z, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)0, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(c)});
    }

    public static Constraint distanceEQ(IntegerVariable x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)0, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(0)});
    }

    public static Constraint distanceLT(IntegerVariable x, IntegerVariable y, IntegerVariable z, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)1, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(c)});
    }

    public static Constraint distanceLT(IntegerVariable x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)1, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(0)});
    }

    public static Constraint distanceGT(IntegerVariable x, IntegerVariable y, IntegerVariable z, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)2, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(c)});
    }

    public static Constraint distanceGT(IntegerVariable x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)2, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(0)});
    }

    public static Constraint abs(IntegerVariable x, IntegerVariable y) {
        return new ComponentConstraint(ConstraintType.ABS, null, (Variable[])new IntegerVariable[]{x, y});
    }

    public static Constraint min(SetVariable svar, IntegerVariable[] ivars, IntegerVariable min, String ... options) {
        Variable[] vars = new Variable[ivars.length + 2];
        vars[0] = svar;
        vars[1] = min;
        System.arraycopy(ivars, 0, vars, 2, ivars.length);
        ComponentConstraint c = new ComponentConstraint(ConstraintType.MIN, (Object)Boolean.TRUE, vars);
        c.addOptions(options);
        return c;
    }

    public static Constraint min(IntegerVariable[] vars, IntegerVariable min) {
        Variable[] tmp = new Variable[vars.length + 1];
        tmp[0] = min;
        System.arraycopy(vars, 0, tmp, 1, vars.length);
        return new ComponentConstraint(ConstraintType.MIN, (Object)true, tmp);
    }

    public static Constraint max(SetVariable svar, IntegerVariable[] ivars, IntegerVariable min, String ... options) {
        Variable[] vars = new Variable[ivars.length + 2];
        vars[0] = svar;
        vars[1] = min;
        System.arraycopy(ivars, 0, vars, 2, ivars.length);
        ComponentConstraint c = new ComponentConstraint(ConstraintType.MIN, (Object)Boolean.FALSE, vars);
        c.addOptions(options);
        return c;
    }

    public static Constraint max(IntegerVariable[] vars, IntegerVariable max) {
        Variable[] tmp = new Variable[vars.length + 1];
        tmp[0] = max;
        System.arraycopy(vars, 0, tmp, 1, vars.length);
        return new ComponentConstraint(ConstraintType.MAX, (Object)false, tmp);
    }

    public static Constraint min(IntegerVariable x, IntegerVariable y, IntegerVariable min) {
        return new ComponentConstraint(ConstraintType.MIN, (Object)true, (Variable[])new IntegerVariable[]{min, x, y});
    }

    public static Constraint min(int x, IntegerVariable y, IntegerVariable min) {
        return Choco.min((IntegerVariable)Choco.constant(x), y, min);
    }

    public static Constraint min(IntegerVariable x, int y, IntegerVariable min) {
        return Choco.min(x, (IntegerVariable)Choco.constant(y), min);
    }

    public static Constraint max(IntegerVariable x, IntegerVariable y, IntegerVariable max) {
        return new ComponentConstraint(ConstraintType.MAX, (Object)false, (Variable[])new IntegerVariable[]{max, x, y});
    }

    public static Constraint max(int x, IntegerVariable y, IntegerVariable max) {
        return Choco.max((IntegerVariable)Choco.constant(x), y, max);
    }

    public static Constraint max(IntegerVariable x, int y, IntegerVariable max) {
        return Choco.max(x, (IntegerVariable)Choco.constant(y), max);
    }

    public static Constraint occurrence(int value, IntegerVariable occurrence, IntegerVariable ... vars) {
        Variable[] variables = new IntegerVariable[vars.length + 2];
        variables[0] = Choco.constant(value);
        variables[1] = occurrence;
        System.arraycopy(vars, 0, variables, 2, vars.length);
        return new ComponentConstraint(ConstraintType.OCCURRENCE, (Object)0, variables);
    }

    public static Constraint occurrence(IntegerVariable occurrence, IntegerVariable[] vars, int value) {
        return Choco.occurrence(value, occurrence, vars);
    }

    public static Constraint occurrenceMin(int value, IntegerVariable occurrence, IntegerVariable ... vars) {
        Variable[] variables = new IntegerVariable[vars.length + 2];
        variables[0] = Choco.constant(value);
        variables[1] = occurrence;
        System.arraycopy(vars, 0, variables, 2, vars.length);
        return new ComponentConstraint(ConstraintType.OCCURRENCE, (Object)-1, variables);
    }

    public static Constraint occurrenceMin(IntegerVariable occurrence, IntegerVariable[] vars, int value) {
        return Choco.occurrenceMin(value, occurrence, vars);
    }

    public static Constraint occurrenceMax(int value, IntegerVariable occurrence, IntegerVariable ... vars) {
        Variable[] variables = new IntegerVariable[vars.length + 2];
        variables[0] = Choco.constant(value);
        variables[1] = occurrence;
        System.arraycopy(vars, 0, variables, 2, vars.length);
        return new ComponentConstraint(ConstraintType.OCCURRENCE, (Object)1, variables);
    }

    public static Constraint occurrenceMax(IntegerVariable occurrence, IntegerVariable[] vars, int value) {
        return Choco.occurrenceMax(value, occurrence, vars);
    }

    public static Constraint occurrence(int occurrence, IntegerVariable[] variables, int value) {
        if (occurrence < 0) {
            throw new ModelException("EXACTLY requirement: n >=0 ");
        }
        if (occurrence > variables.length) {
            throw new ModelException("EXACTLY requirement : nvar <= |variables|");
        }
        if (variables.length == 0) {
            throw new ModelException("EXACTLY requirement : |variables| > 0");
        }
        return new ComponentConstraint(ConstraintType.EXACTLY, (Object)new int[]{occurrence, value}, (Variable[])variables);
    }

    @Deprecated
    public static Constraint exactly(int occurrence, IntegerVariable[] variables, int value) {
        return Choco.occurrence(occurrence, variables, value);
    }

    public static Constraint increasingSum(IntegerVariable[] variables, IntegerVariable sum) {
        return new ComponentConstraint(ConstraintType.INCREASINGSUM, null, (Variable[])ArrayUtils.append(variables, {sum}));
    }

    public static Constraint nth(IntegerVariable index, int[] values, IntegerVariable val) {
        return Choco.nth(index, values, val, 0);
    }

    public static Constraint nth(String options, IntegerVariable index, int[] values, IntegerVariable val) {
        Constraint c = Choco.nth(index, values, val, 0);
        c.addOption(options);
        return c;
    }

    public static Constraint nth(IntegerVariable index, int[] values, IntegerVariable val, int offset) {
        Variable[] vars = new IntegerVariable[values.length + 2];
        for (int i = 0; i < values.length; ++i) {
            vars[i] = Choco.constant(values[i]);
        }
        vars[vars.length - 2] = index;
        vars[vars.length - 1] = val;
        return new ComponentConstraint(ConstraintType.NTH, (Object)offset, vars);
    }

    public static Constraint nth(String options, IntegerVariable index, int[] values, IntegerVariable val, int offset) {
        Constraint c = Choco.nth(index, values, val, offset);
        c.addOption(options);
        return c;
    }

    public static Constraint nth(IntegerVariable index, IntegerVariable[] varArray, IntegerVariable val) {
        return Choco.nth(index, varArray, val, 0);
    }

    public static Constraint nth(String option, IntegerVariable index, IntegerVariable[] varArray, IntegerVariable val) {
        Constraint c = Choco.nth(index, varArray, val, 0);
        c.addOption(option);
        return c;
    }

    public static Constraint nth(IntegerVariable index, IntegerVariable index2, int[][] varArray, IntegerVariable val) {
        return new ComponentConstraint(ConstraintType.NTH, (Object)varArray, (Variable[])new IntegerVariable[]{index, index2, val});
    }

    public static Constraint nth(IntegerVariable index, IntegerVariable[] varArray, IntegerVariable val, int offset) {
        Variable[] vars = ArrayUtils.append(varArray, {index, val});
        return new ComponentConstraint(ConstraintType.NTH, (Object)offset, vars);
    }

    public static Constraint nth(String options, IntegerVariable index, IntegerVariable[] varArray, IntegerVariable val, int offset) {
        Constraint c = Choco.nth(index, varArray, val, offset);
        c.addOption(options);
        return c;
    }

    public static Constraint boolChanneling(IntegerVariable b, IntegerVariable x, int j) {
        return new ComponentConstraint(ConstraintType.CHANNELING, (Object)new Object[]{ConstraintType.CHANNELING}, (Variable[])new IntegerVariable[]{b, x, Choco.constant(j)});
    }

    public static Constraint inverseChanneling(IntegerVariable[] x, IntegerVariable[] y) {
        if (y.length != x.length) {
            throw new ModelException("not a valid inverse channeling constraint with two arrays of different sizes");
        }
        return new ComponentConstraint(ConstraintType.INVERSECHANNELING, (Object)new Object[]{ConstraintType.INVERSECHANNELING}, (Variable[])ArrayUtils.append(x, y));
    }

    public static Constraint inverseChannelingWithinRange(IntegerVariable[] x, IntegerVariable[] y) {
        return new ComponentConstraint(ConstraintType.INVERSECHANNELINGWITHINRANGE, (Object)new Object[]{ConstraintType.INVERSECHANNELINGWITHINRANGE, x.length}, (Variable[])ArrayUtils.append(x, y));
    }

    public static Constraint domainChanneling(IntegerVariable x, IntegerVariable[] b) {
        return new ComponentConstraint(ConstraintType.DOMAIN_CHANNELING, (Object)new Object[]{ConstraintType.DOMAIN_CHANNELING}, (Variable[])ArrayUtils.append(b, {x}));
    }

    @Deprecated
    public static Constraint domainConstraint(IntegerVariable x, IntegerVariable[] b) {
        return new ComponentConstraint(ConstraintType.DOMAIN_CHANNELING, (Object)new Object[]{ConstraintType.DOMAIN_CHANNELING}, (Variable[])ArrayUtils.append(b, {x}));
    }

    public static Constraint allDifferent(IntegerVariable ... vars) {
        return new ComponentConstraint(ConstraintType.ALLDIFFERENT, null, (Variable[])vars);
    }

    public static Constraint allDifferent(String options, IntegerVariable ... vars) {
        Constraint c = Choco.allDifferent(vars);
        c.addOption(options);
        return c;
    }

    private static void globalCardinalityTest(IntegerVariable[] vars, int[] low, int[] up) {
        if (low.length != up.length) {
            throw new ModelException("globalCardinality : low and up do not have same size");
        }
        int sumL = 0;
        for (int i = 0; i < low.length; ++i) {
            sumL += low[i];
            if (low[i] <= up[i]) continue;
            throw new ModelException("globalCardinality : incorrect low and up (" + i + ")");
        }
        if (vars.length < sumL) {
            throw new ModelException("globalCardinality : not enough minimum values");
        }
    }

    public static Constraint globalCardinality(IntegerVariable[] vars, int min, int max, int[] low, int[] up) {
        Choco.globalCardinalityTest(vars, low, up);
        return new ComponentConstraint(ConstraintType.GLOBALCARDINALITY, (Object)new Object[]{ConstraintType.GLOBALCARDINALITYMAX, min, max, low, up}, (Variable[])vars);
    }

    public static Constraint globalCardinality(String options, IntegerVariable[] vars, int min, int max, int[] low, int[] up) {
        Constraint c = Choco.globalCardinality(vars, min, max, low, up);
        c.addOption(options);
        return c;
    }

    public static Constraint globalCardinality(IntegerVariable[] vars, int[] low, int[] up, int offset) {
        Choco.globalCardinalityTest(vars, low, up);
        int max = low.length - 1 + offset;
        return new ComponentConstraint(ConstraintType.GLOBALCARDINALITY, (Object)new Object[]{ConstraintType.GLOBALCARDINALITYMAX, offset, max, low, up}, (Variable[])vars);
    }

    public static Constraint globalCardinality(IntegerVariable[] vars, int[] values, int[] low, int[] up) {
        return new ComponentConstraint(ConstraintType.GLOBALCARDINALITY, (Object)new Object[]{ConstraintType.GLOBALCARDINALITYVALUES, values, low, up}, (Variable[])vars);
    }

    public static Constraint globalCardinality(IntegerVariable[] vars, int[] values, IntegerVariable[] cards) {
        int n = vars.length;
        Variable[] variables = new IntegerVariable[vars.length + cards.length];
        System.arraycopy(vars, 0, variables, 0, n);
        System.arraycopy(cards, 0, variables, n, cards.length);
        return new ComponentConstraint(ConstraintType.GLOBALCARDINALITY, (Object)new Object[]{ConstraintType.GLOBALCARDINALITYVARVALUES, values, n}, variables);
    }

    public static Constraint globalCardinality(String options, IntegerVariable[] vars, int[] low, int[] up, int offset) {
        Constraint c = Choco.globalCardinality(vars, low, up, offset);
        c.addOption(options);
        return c;
    }

    public static Constraint globalCardinality(IntegerVariable[] vars, int min, int max, IntegerVariable[] card) {
        int n = vars.length;
        Variable[] variables = new IntegerVariable[vars.length + card.length];
        System.arraycopy(vars, 0, variables, 0, n);
        System.arraycopy(card, 0, variables, n, card.length);
        return new ComponentConstraint(ConstraintType.GLOBALCARDINALITY, (Object)new Object[]{ConstraintType.GLOBALCARDINALITYVAR, min, max, n}, variables);
    }

    public static Constraint globalCardinality(IntegerVariable[] vars, IntegerVariable[] card, int offset) {
        int n = vars.length;
        Variable[] variables = new IntegerVariable[vars.length + card.length];
        System.arraycopy(vars, 0, variables, 0, n);
        System.arraycopy(card, 0, variables, n, card.length);
        return new ComponentConstraint(ConstraintType.GLOBALCARDINALITY, (Object)new Object[]{ConstraintType.GLOBALCARDINALITYVAR, offset, card.length - 1 + offset, n}, variables);
    }

    public static Constraint stretchPath(List<int[]> stretchesParameters, IntegerVariable ... vars) {
        return new ComponentConstraint(ConstraintType.STRETCHPATH, stretchesParameters, (Variable[])vars);
    }

    public static Constraint increasingNValue(String option, IntegerVariable nval, IntegerVariable[] vars) {
        Constraint c = Choco.increasingNValue(nval, vars);
        c.addOption(option);
        return c;
    }

    public static Constraint increasingNValue(IntegerVariable nval, IntegerVariable[] vars) {
        return new ComponentConstraint(ConstraintType.INCREASINGNVALUE, null, (Variable[])ArrayUtils.append({nval}, vars));
    }

    @Deprecated
    public static Constraint increasing_nvalue(IntegerVariable nval, IntegerVariable[] vars) {
        return Choco.increasingNValue(nval, vars);
    }

    @Deprecated
    public static Constraint increasing_nvalue(String option, IntegerVariable nval, IntegerVariable[] vars) {
        return Choco.increasingNValue(option, nval, vars);
    }

    public static Constraint pack(SetVariable[] itemSets, IntegerVariable[] loads, IntegerVariable[] bins, IntegerConstantVariable[] sizes, IntegerVariable nbNonEmpty, String ... options) {
        return Choco.pack(new PackModel(bins, sizes, itemSets, loads, nbNonEmpty), options);
    }

    public static Constraint pack(PackModel packMod, String ... options) {
        ComponentConstraint pack = new ComponentConstraint(ConstraintType.PACK, (Object)new Object[]{packMod.getNbItems(), packMod.getNbBins()}, packMod.getVariables());
        pack.addOptions(options);
        return pack;
    }

    public static Constraint cumulative(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable[] usages, IntegerVariable consumption, IntegerVariable capacity, IntegerVariable uppBound, String ... options) {
        IntegerVariable[] integerVariableArray;
        if (tasks == null || heights == null || tasks.length == 0 || tasks.length != heights.length) {
            throw new ModelException("can't build cumulative constraint " + name + " : Tasks and heights arrays are nil or have different size.");
        }
        if (usages != null && usages.length > tasks.length) {
            throw new ModelException("can't build cumulative constraint " + name + " : usage array have a greater length than task array.");
        }
        if (consumption == null) {
            LOGGER.log(Level.WARNING, "replace nil consumption in cumulative {0}", name);
            consumption = Choco.constant(0);
        }
        if (capacity == null) {
            LOGGER.log(Level.WARNING, "replace nil capacity in cumulative {0}", name);
            consumption = Choco.constant(21474836);
        }
        ResourceParameters param = new ResourceParameters(name, tasks, usages, uppBound);
        AbstractVariable[][] abstractVariableArrayArray = new AbstractVariable[5][];
        abstractVariableArrayArray[0] = tasks;
        abstractVariableArrayArray[1] = usages;
        abstractVariableArrayArray[2] = heights;
        abstractVariableArrayArray[3] = new IntegerVariable[]{consumption, capacity};
        if (uppBound == null) {
            integerVariableArray = null;
        } else {
            IntegerVariable[] integerVariableArray2 = new IntegerVariable[1];
            integerVariableArray = integerVariableArray2;
            integerVariableArray2[0] = uppBound;
        }
        abstractVariableArrayArray[4] = integerVariableArray;
        Variable[] vars = ArrayUtils.append(abstractVariableArrayArray);
        ComponentConstraint c = new ComponentConstraint(ConstraintType.CUMULATIVE, (Object)param, vars);
        c.addOptions(options);
        return c;
    }

    public static Constraint cumulative(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable consumption, IntegerVariable capacity, String ... options) {
        return Choco.cumulative(name, tasks, heights, null, consumption, capacity, null, options);
    }

    public static Constraint cumulativeMax(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable capacity, String ... options) {
        return Choco.cumulative(name, tasks, heights, null, (IntegerVariable)Choco.constant(0), capacity, null, options);
    }

    public static Constraint cumulativeMax(TaskVariable[] tasks, int[] heights, int capacity, String ... options) {
        return Choco.cumulativeMax(null, tasks, (IntegerVariable[])Choco.constantArray(heights), Choco.constant(capacity), options);
    }

    public static Constraint cumulativeMin(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable consumption, String ... options) {
        return Choco.cumulative(name, tasks, heights, null, consumption, (IntegerVariable)Choco.constant(21474836), null, options);
    }

    public static Constraint cumulativeMin(TaskVariable[] tasks, int[] heights, int consumption, String ... options) {
        return Choco.cumulativeMin(null, tasks, (IntegerVariable[])Choco.constantArray(heights), Choco.constant(consumption), options);
    }

    public static Constraint cumulative(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable[] usages, IntegerVariable consumption, IntegerVariable capacity, String ... options) {
        return Choco.cumulative(name, tasks, heights, usages, consumption, capacity, null, options);
    }

    public static Constraint cumulativeMax(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable[] usages, IntegerVariable capacity, String ... options) {
        return Choco.cumulative(name, tasks, heights, usages, (IntegerVariable)Choco.constant(0), capacity, null, options);
    }

    public static Constraint cumulativeMin(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable[] usages, IntegerVariable consumption, String ... options) {
        return Choco.cumulative(name, tasks, heights, usages, consumption, (IntegerVariable)Choco.constant(Integer.MAX_VALUE), null, options);
    }

    public static Constraint disjunctive(String name, TaskVariable[] tasks, IntegerVariable[] usages, IntegerVariable uppBound, String ... options) {
        ResourceParameters param = new ResourceParameters(name, tasks, usages, uppBound);
        Variable[] vars = uppBound == null ? ArrayUtils.append(tasks, usages) : (Variable[])ArrayUtils.append(tasks, usages, {uppBound});
        ComponentConstraint c = new ComponentConstraint(ConstraintType.DISJUNCTIVE, (Object)param, vars);
        c.addOptions(options);
        return c;
    }

    public static Constraint disjunctive(TaskVariable[] tasks, String ... options) {
        return Choco.disjunctive(null, tasks, options);
    }

    public static Constraint disjunctive(String name, TaskVariable[] tasks, String ... options) {
        return Choco.disjunctive(name, tasks, null, options);
    }

    public static Constraint disjunctive(TaskVariable[] tasks, IntegerVariable[] usages, String ... options) {
        return Choco.disjunctive(null, tasks, usages, options);
    }

    public static Constraint disjunctive(String name, TaskVariable[] tasks, IntegerVariable[] usages, String ... options) {
        return Choco.disjunctive(name, tasks, usages, null, options);
    }

    public static Constraint forbiddenIntervals(String name, TaskVariable[] tasks) {
        return new ComponentConstraint(ConstraintType.FORBIDDEN_INTERVALS, (Object)name, (Variable[])tasks);
    }

    public static Constraint[] disjoint(TaskVariable[] tasks1, TaskVariable[] tasks2) {
        Constraint[] decomp = new Constraint[tasks1.length * tasks2.length];
        int idx = 0;
        for (TaskVariable t1 : tasks1) {
            for (TaskVariable t2 : tasks2) {
                decomp[idx++] = Choco.precedenceDisjoint(t1, t2, VariableUtils.createDirVariable(t1, t2, new String[0]));
            }
        }
        return decomp;
    }

    public static Constraint precedence(TaskVariable t1, TaskVariable t2) {
        return Choco.precedenceDisjoint(t1, t2, ONE);
    }

    public static Constraint precedence(TaskVariable t1, TaskVariable t2, int delta) {
        return Choco.precedenceDisjoint(t1, t2, ONE, delta, 0);
    }

    public static Constraint precedenceDisjoint(IntegerVariable v1, int dur1, IntegerVariable v2, int dur2, IntegerVariable bool) {
        return new ComponentConstraint(ConstraintType.PRECEDENCE_DISJOINT, (Object)Boolean.FALSE, (Variable[])new IntegerVariable[]{v1, Choco.constant(dur1), v2, Choco.constant(dur2), bool});
    }

    public static Constraint precedenceDisjoint(TaskVariable t1, TaskVariable t2, IntegerVariable direction) {
        return Choco.precedenceDisjoint(t1, t2, direction, 0, 0);
    }

    public static Constraint precedenceDisjoint(TaskVariable t1, TaskVariable t2, IntegerVariable direction, int forwardSetup, int backwardSetup) {
        return new TemporalConstraint(ConstraintType.PRECEDENCE_DISJOINT, (Object)Boolean.TRUE, new Variable[]{t1, Choco.constant(forwardSetup), t2, Choco.constant(backwardSetup), direction});
    }

    public static Constraint precedenceReified(IntegerVariable x1, int k1, IntegerVariable x2, IntegerVariable b) {
        return new ComponentConstraint(ConstraintType.PRECEDENCE_REIFIED, (Object)Boolean.FALSE, (Variable[])new IntegerVariable[]{x1, Choco.constant(k1), x2, ZERO, b});
    }

    public static Constraint precedenceReified(TaskVariable t1, int delta, TaskVariable t2, IntegerVariable b) {
        return new TemporalConstraint(ConstraintType.PRECEDENCE_REIFIED, (Object)Boolean.TRUE, new Variable[]{t1, Choco.constant(delta), t2, ZERO, b});
    }

    public static Constraint precedenceImplied(IntegerVariable x1, int k1, IntegerVariable x2, IntegerVariable b) {
        return new ComponentConstraint(ConstraintType.PRECEDENCE_IMPLIED, (Object)Boolean.FALSE, (Variable[])new IntegerVariable[]{x1, Choco.constant(k1), x2, ZERO, b});
    }

    public static Constraint precedenceImplied(TaskVariable t1, int delta, TaskVariable t2, IntegerVariable b) {
        return new TemporalConstraint(ConstraintType.PRECEDENCE_IMPLIED, (Object)Boolean.TRUE, new Variable[]{t1, Choco.constant(delta), t2, ZERO, b});
    }

    @Deprecated
    public static Constraint geost(int dim, Vector<GeostObject> objects, Vector<ShiftedBox> shiftedBoxes, Vector<IExternalConstraint> eCtrs) {
        return Choco.geost(dim, objects, shiftedBoxes, eCtrs, null);
    }

    @Deprecated
    public static Constraint geost(int dim, Vector<GeostObject> objects, Vector<ShiftedBox> shiftedBoxes, Vector<IExternalConstraint> eCtrs, Vector<int[]> ctrlVs) {
        return Choco.geost(dim, objects, shiftedBoxes, eCtrs, ctrlVs, null);
    }

    @Deprecated
    public static Constraint geost(int dim, Vector<GeostObject> objects, Vector<ShiftedBox> shiftedBoxes, Vector<IExternalConstraint> eCtrs, Vector<int[]> ctrlVs, GeostOptions opt) {
        int originOfObjects = objects.size() * dim;
        int otherVariables = objects.size() * 4;
        ArrayList<Integer> distVars = new ArrayList<Integer>(eCtrs.size());
        for (int i = 0; i < eCtrs.size(); ++i) {
            IExternalConstraint ectr = eCtrs.get(i);
            if (ectr instanceof DistLeqModel && ((DistLeqModel)ectr).hasDistanceVar()) {
                distVars.add(i);
            }
            if (!(ectr instanceof DistGeqModel) || !((DistGeqModel)ectr).hasDistanceVar()) continue;
            distVars.add(i);
        }
        Variable[] vars = new IntegerVariable[originOfObjects + otherVariables + distVars.size()];
        for (int i = 0; i < objects.size(); ++i) {
            for (int j = 0; j < dim; ++j) {
                vars[i * (dim + 4) + j] = objects.get(i).getCoordinates()[j];
            }
            vars[i * (dim + 4) + dim] = objects.get(i).getShapeId();
            vars[i * (dim + 4) + dim + 1] = objects.get(i).getStartTime();
            vars[i * (dim + 4) + dim + 2] = objects.get(i).getDurationTime();
            vars[i * (dim + 4) + dim + 3] = objects.get(i).getEndTime();
        }
        int ind = 0;
        Iterator i$ = distVars.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            IExternalConstraint ectr = eCtrs.get(i);
            if (ectr instanceof DistLeqModel) {
                vars[originOfObjects + otherVariables + ind] = ((DistLeqModel)ectr).getDistanceVar();
            }
            if (ectr instanceof DistGeqModel) {
                vars[originOfObjects + otherVariables + ind] = ((DistGeqModel)ectr).getDistanceVar();
            }
            ++ind;
        }
        ArrayList<GeostObject> nObjects = Collections.list(objects.elements());
        ArrayList<ShiftedBox> nShiftedBoxes = Collections.list(shiftedBoxes.elements());
        ArrayList<IExternalConstraint> nECtrs = Collections.list(eCtrs.elements());
        ArrayList<int[]> nCtrlVs = Collections.list(ctrlVs.elements());
        return new ComponentConstraint(ConstraintType.GEOST, (Object)new Object[]{dim, nShiftedBoxes, nECtrs, nObjects, nCtrlVs, opt}, vars);
    }

    public static Constraint geost(int dim, List<GeostObject> objects, List<ShiftedBox> shiftedBoxes, List<IExternalConstraint> eCtrs) {
        return Choco.geost(dim, objects, shiftedBoxes, eCtrs, null);
    }

    public static Constraint geost(int dim, List<GeostObject> objects, List<ShiftedBox> shiftedBoxes, List<IExternalConstraint> eCtrs, List<int[]> ctrlVs) {
        return Choco.geost(dim, objects, shiftedBoxes, eCtrs, ctrlVs, null);
    }

    public static Constraint geost(int dim, List<GeostObject> objects, List<ShiftedBox> shiftedBoxes, List<IExternalConstraint> eCtrs, List<int[]> ctrlVs, GeostOptions opt) {
        int originOfObjects = objects.size() * dim;
        int otherVariables = objects.size() * 4;
        ArrayList<Integer> distVars = new ArrayList<Integer>(eCtrs.size());
        for (int i = 0; i < eCtrs.size(); ++i) {
            IExternalConstraint ectr = eCtrs.get(i);
            if (ectr instanceof DistLeqModel && ((DistLeqModel)ectr).hasDistanceVar()) {
                distVars.add(i);
            }
            if (!(ectr instanceof DistGeqModel) || !((DistGeqModel)ectr).hasDistanceVar()) continue;
            distVars.add(i);
        }
        Variable[] vars = new IntegerVariable[originOfObjects + otherVariables + distVars.size()];
        for (int i = 0; i < objects.size(); ++i) {
            for (int j = 0; j < dim; ++j) {
                vars[i * (dim + 4) + j] = objects.get(i).getCoordinates()[j];
            }
            vars[i * (dim + 4) + dim] = objects.get(i).getShapeId();
            vars[i * (dim + 4) + dim + 1] = objects.get(i).getStartTime();
            vars[i * (dim + 4) + dim + 2] = objects.get(i).getDurationTime();
            vars[i * (dim + 4) + dim + 3] = objects.get(i).getEndTime();
        }
        int ind = 0;
        Iterator i$ = distVars.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            IExternalConstraint ectr = eCtrs.get(i);
            if (ectr instanceof DistLeqModel) {
                vars[originOfObjects + otherVariables + ind] = ((DistLeqModel)ectr).getDistanceVar();
            }
            if (ectr instanceof DistGeqModel) {
                vars[originOfObjects + otherVariables + ind] = ((DistGeqModel)ectr).getDistanceVar();
            }
            ++ind;
        }
        return new ComponentConstraint(ConstraintType.GEOST, (Object)new Object[]{dim, shiftedBoxes, eCtrs, objects, ctrlVs, opt}, vars);
    }

    public static Constraint lexEq(IntegerVariable[] v1, IntegerVariable[] v2) {
        int offset = v1.length;
        return new ComponentConstraint(ConstraintType.LEX, (Object)new Object[]{ConstraintType.LEXEQ, offset}, (Variable[])ArrayUtils.append(v1, v2));
    }

    @Deprecated
    public static Constraint lexeq(IntegerVariable[] v1, IntegerVariable[] v2) {
        int offset = v1.length;
        return new ComponentConstraint(ConstraintType.LEX, (Object)new Object[]{ConstraintType.LEXEQ, offset}, (Variable[])ArrayUtils.append(v1, v2));
    }

    public static Constraint lex(IntegerVariable[] v1, IntegerVariable[] v2) {
        int offset = v1.length;
        return new ComponentConstraint(ConstraintType.LEX, (Object)new Object[]{ConstraintType.LEX, offset}, (Variable[])ArrayUtils.append(v1, v2));
    }

    public static Constraint lexChain(IntegerVariable[] ... arrayOfVectors) {
        int n = arrayOfVectors[0].length;
        Variable[] vs = new IntegerVariable[arrayOfVectors.length * n];
        for (int i = 0; i < arrayOfVectors.length; ++i) {
            if (arrayOfVectors[i].length != n) {
                throw new ModelException("LexChain : every arrays in parameters are of different size");
            }
            System.arraycopy(arrayOfVectors[i], 0, vs, n * i, n);
        }
        return new ComponentConstraint(ConstraintType.LEXCHAIN, (Object)new Object[]{true, n}, vs);
    }

    public static Constraint lexChainEq(IntegerVariable[] ... arrayOfVectors) {
        int n = arrayOfVectors[0].length;
        Variable[] vs = new IntegerVariable[arrayOfVectors.length * n];
        for (int i = 0; i < arrayOfVectors.length; ++i) {
            System.arraycopy(arrayOfVectors[i], 0, vs, n * i, n);
        }
        return new ComponentConstraint(ConstraintType.LEXCHAIN, (Object)new Object[]{false, n}, vs);
    }

    public static Constraint sorting(IntegerVariable[] v1, IntegerVariable[] v2) {
        int offset = v1.length;
        Variable[] vars = ArrayUtils.append(v1, v2);
        return new ComponentConstraint(ConstraintType.SORTING, (Object)offset, vars);
    }

    public static Constraint leximin(IntegerVariable[] v1, IntegerVariable[] v2) {
        Variable[] vars = new IntegerVariable[v1.length + v2.length];
        System.arraycopy(v1, 0, vars, 0, v1.length);
        System.arraycopy(v2, 0, vars, v1.length, v2.length);
        return new ComponentConstraint(ConstraintType.LEXIMIN, null, vars);
    }

    public static Constraint leximin(int[] v1, IntegerVariable[] v2) {
        return new ComponentConstraint(ConstraintType.LEXIMIN, (Object)v1, (Variable[])v2);
    }

    public static Constraint atMostNValue(IntegerVariable nvalue, IntegerVariable[] vars) {
        Variable[] tmp = new IntegerVariable[vars.length + 1];
        System.arraycopy(vars, 0, tmp, 0, vars.length);
        tmp[tmp.length - 1] = nvalue;
        return new ComponentConstraint(ConstraintType.ATMOSTNVALUE, null, tmp);
    }

    @Deprecated
    public static Constraint atMostNValue(IntegerVariable[] vars, IntegerVariable nvalue) {
        Variable[] tmp = new IntegerVariable[vars.length + 1];
        System.arraycopy(vars, 0, tmp, 0, vars.length);
        tmp[tmp.length - 1] = nvalue;
        return new ComponentConstraint(ConstraintType.ATMOSTNVALUE, null, tmp);
    }

    public static Constraint complementSet(SetVariable x, SetVariable y) {
        return new ComponentConstraint(ConstraintType.COMPLEMENTSET, null, (Variable[])new SetVariable[]{x, y});
    }

    public static Constraint setInter(SetVariable sv1, SetVariable sv2, SetVariable inter) {
        return new ComponentConstraint(ConstraintType.SETINTER, null, (Variable[])new SetVariable[]{sv1, sv2, inter});
    }

    public static Constraint setUnion(SetVariable sv1, SetVariable sv2, SetVariable union) {
        return new ComponentConstraint(ConstraintType.SETUNION, null, (Variable[])new SetVariable[]{union, sv1, sv2});
    }

    public static Constraint setUnion(SetVariable[] sv, SetVariable union) {
        return new ComponentConstraint(ConstraintType.SETUNION, null, (Variable[])ArrayUtils.append({union}, sv));
    }

    public static Constraint eq(SetVariable sv1, SetVariable sv2) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, (Variable[])new SetVariable[]{sv1, sv2});
    }

    public static Constraint eqCard(SetVariable sv, IntegerVariable v) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{sv, v});
    }

    public static Constraint eqCard(SetVariable sv, int val) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{sv, Choco.constant(val)});
    }

    public static Constraint neqCard(SetVariable sv, IntegerVariable v) {
        return new ComponentConstraint(ConstraintType.NEQ, (Object)ConstraintType.NEQ, new Variable[]{sv, v});
    }

    public static Constraint neqCard(SetVariable sv, int val) {
        return new ComponentConstraint(ConstraintType.NEQ, (Object)ConstraintType.NEQ, new Variable[]{sv, Choco.constant(val)});
    }

    public static Constraint geqCard(SetVariable sv, IntegerVariable v) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{sv, v});
    }

    public static Constraint geqCard(SetVariable sv, int val) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{sv, Choco.constant(val)});
    }

    public static Constraint leqCard(SetVariable sv, IntegerVariable v) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{sv, v});
    }

    public static Constraint leqCard(SetVariable sv, int val) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{sv, Choco.constant(val)});
    }

    public static Constraint setDisjoint(SetVariable ... sv) {
        if (sv.length < 2) {
            throw new ModelException("setDisjoint : bad number of arguments (>=2)");
        }
        return new ComponentConstraint(ConstraintType.SETDISJOINT, null, (Variable[])sv);
    }

    public static Constraint member(int val, SetVariable sv1) {
        return new ComponentConstraint(ConstraintType.MEMBER, (Object)val, new Variable[]{sv1});
    }

    public static Constraint member(SetVariable sv1, int val) {
        return new ComponentConstraint(ConstraintType.MEMBER, (Object)val, new Variable[]{sv1});
    }

    public static Constraint member(SetVariable sv1, IntegerVariable var) {
        return new ComponentConstraint(ConstraintType.MEMBER, null, new Variable[]{sv1, var});
    }

    public static Constraint member(IntegerVariable var, SetVariable sv1) {
        return new ComponentConstraint(ConstraintType.MEMBER, null, new Variable[]{sv1, var});
    }

    public static Constraint member(SetVariable sv, IntegerVariable ... vars) {
        return new ComponentConstraint(ConstraintType.MEMBER, null, ArrayUtils.append({sv}, vars));
    }

    public static Constraint notMember(int val, SetVariable sv1) {
        return new ComponentConstraint(ConstraintType.NOTMEMBER, (Object)val, new Variable[]{sv1});
    }

    public static Constraint notMember(SetVariable sv1, int val) {
        return new ComponentConstraint(ConstraintType.NOTMEMBER, (Object)val, new Variable[]{sv1});
    }

    public static Constraint notMember(SetVariable sv1, IntegerVariable var) {
        return new ComponentConstraint(ConstraintType.NOTMEMBER, null, new Variable[]{sv1, var});
    }

    public static Constraint notMember(IntegerVariable var, SetVariable sv1) {
        return new ComponentConstraint(ConstraintType.NOTMEMBER, null, new Variable[]{sv1, var});
    }

    public static Constraint inverseSet(IntegerVariable[] iv, SetVariable[] sv) {
        return new ComponentConstraint(ConstraintType.INVERSE_SET, (Object)iv.length, ArrayUtils.append(iv, sv));
    }

    public static Constraint inverseSet(SetVariable[] xs, SetVariable[] ys) {
        return new ComponentConstraint(ConstraintType.INVERSE_SET, (Object)xs.length, (Variable[])ArrayUtils.append(xs, ys));
    }

    public static Constraint setLex(SetVariable x, SetVariable y) {
        return new ComponentConstraint(ConstraintType.SETLEXICOGRAPHICORDERING, null, (Variable[])new SetVariable[]{x, y});
    }

    public static Constraint setValuePrecede(SetVariable[] sv, int s, int t) {
        return new ComponentConstraint(ConstraintType.SETVALUEPRECEDE, (Object)new int[]{s, t}, (Variable[])sv);
    }

    public static Constraint neq(SetVariable sv1, SetVariable sv2) {
        return new ComponentConstraint(ConstraintType.NEQ, (Object)ConstraintType.NEQ, (Variable[])new SetVariable[]{sv1, sv2});
    }

    public static Constraint isIncluded(SetVariable sv1, SetVariable sv2) {
        return new ComponentConstraint(ConstraintType.ISINCLUDED, null, (Variable[])new SetVariable[]{sv1, sv2});
    }

    public static Constraint isNotIncluded(SetVariable sv1, SetVariable sv2) {
        return new ComponentConstraint(ConstraintType.ISNOTINCLUDED, null, (Variable[])new SetVariable[]{sv1, sv2});
    }

    public static Constraint regular(IntegerVariable[] vars, IAutomaton auto) {
        return new ComponentConstraint(ConstraintType.FASTREGULAR, (Object)auto, (Variable[])vars);
    }

    public static Constraint regular(IntegerVariable[] vars, DFA auto) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)auto, (Variable[])vars);
    }

    public static Constraint regular(IntegerVariable[] vars, String regexp) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)regexp, (Variable[])vars);
    }

    @Deprecated
    public static Constraint regular(DFA auto, IntegerVariable[] vars) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)auto, (Variable[])vars);
    }

    @Deprecated
    public static Constraint regular(IAutomaton auto, IntegerVariable[] vars) {
        return new ComponentConstraint(ConstraintType.FASTREGULAR, (Object)auto, (Variable[])vars);
    }

    @Deprecated
    public static Constraint regular(String regexp, IntegerVariable[] vars) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)regexp, (Variable[])vars);
    }

    public static Constraint regular(IntegerVariable[] vars, List<int[]> tuples) {
        return new ComponentConstraint(ConstraintType.REGULAR, tuples, (Variable[])vars);
    }

    public static Constraint regular(IntegerVariable[] vars, List<int[]> tuples, int[] min, int[] max) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)new Object[]{tuples, min, max}, (Variable[])vars);
    }

    public static Constraint costRegular(IntegerVariable costVar, IntegerVariable[] vars, IAutomaton auto, int[][] costs) {
        return new ComponentConstraint(ConstraintType.COSTREGULAR, (Object)new Object[]{auto, costs}, (Variable[])ArrayUtils.append(vars, {costVar}));
    }

    public static Constraint costRegular(IntegerVariable costVar, IntegerVariable[] vars, IAutomaton auto, int[][][] costs) {
        return new ComponentConstraint(ConstraintType.COSTREGULAR, (Object)new Object[]{auto, costs}, (Variable[])ArrayUtils.append(vars, {costVar}));
    }

    public static Constraint costRegular(IntegerVariable costVar, IntegerVariable[] vars, ICostAutomaton auto) {
        return new ComponentConstraint(ConstraintType.COSTREGULAR, (Object)auto, (Variable[])ArrayUtils.append(vars, {costVar}));
    }

    public static Constraint costRegular(IntegerVariable costVar, IntegerVariable[] vars, DirectedMultigraph<Node, Arc> graph, Node source) {
        return new ComponentConstraint(ConstraintType.COSTREGULAR, (Object)new Object[]{graph, source}, (Variable[])ArrayUtils.append(vars, {costVar}));
    }

    @Deprecated
    public static Constraint costRegular(IntegerVariable[] vars, IntegerVariable costVar, IAutomaton auto, int[][][] costs) {
        return new ComponentConstraint(ConstraintType.COSTREGULAR, (Object)new Object[]{auto, costs}, (Variable[])ArrayUtils.append(vars, {costVar}));
    }

    @Deprecated
    public static Constraint costRegular(IntegerVariable[] vars, IntegerVariable costVar, DirectedMultigraph<Node, Arc> graph, Node source) {
        return new ComponentConstraint(ConstraintType.COSTREGULAR, (Object)new Object[]{graph, source}, (Variable[])ArrayUtils.append(vars, {costVar}));
    }

    public static Constraint knapsackProblem(IntegerVariable costVar, IntegerVariable weightVar, IntegerVariable[] vars, int[] costs, int[] weights) {
        return new ComponentConstraint(ConstraintType.COSTKNAPSACK, (Object)new Object[]{costs, weights}, (Variable[])ArrayUtils.append(vars, {costVar, weightVar}));
    }

    @Deprecated
    public static Constraint knapsackProblem(IntegerVariable[] vars, IntegerVariable costVar, IntegerVariable weightVar, int[] costs, int[] weights) {
        return new ComponentConstraint(ConstraintType.COSTKNAPSACK, (Object)new Object[]{costs, weights}, (Variable[])ArrayUtils.append(vars, {costVar, weightVar}));
    }

    public static Constraint multiCostRegular(IntegerVariable[] costVars, IntegerVariable[] vars, IAutomaton auto, int[][][] costs) {
        return new ComponentConstraint(ConstraintType.MULTICOSTREGULAR, (Object)new Object[]{vars.length, auto, costs}, (Variable[])ArrayUtils.append(vars, costVars));
    }

    public static Constraint multiCostRegular(IntegerVariable[] costVars, IntegerVariable[] vars, IAutomaton auto, int[][][][] costs) {
        int[][][][] copy = ArrayUtils.swallowCopy(costs);
        return new ComponentConstraint(ConstraintType.MULTICOSTREGULAR, (Object)new Object[]{vars.length, auto, copy}, (Variable[])ArrayUtils.append(vars, costVars));
    }

    public static Constraint multiCostRegular(IntegerVariable[] costVars, IntegerVariable[] vars, ICostAutomaton auto) {
        return new ComponentConstraint(ConstraintType.MULTICOSTREGULAR, (Object)new Object[]{vars.length, auto}, (Variable[])ArrayUtils.append(vars, costVars));
    }

    public static Constraint softMultiCostRegular(IntegerVariable[] vars, IntegerVariable[] counters, IntegerVariable[] penaltyVars, IntegerVariable globalPenalty, IPenaltyFunction[] pfunction, IAutomaton auto, int[][][][] costs) {
        int[][][][] copy = ArrayUtils.swallowCopy(costs);
        return new ComponentConstraint(ConstraintType.SOFTMULTICOSTREGULAR, (Object)new Object[]{vars.length, counters.length, pfunction, auto, copy}, (Variable[])ArrayUtils.append(vars, counters, penaltyVars, {globalPenalty}));
    }

    public static Constraint softMultiCostRegular(IntegerVariable[] vars, IntegerVariable[] counters, IntegerVariable[] penaltyVars, IntegerVariable globalPenalty, IPenaltyFunction[] pfunction, IAutomaton auto, int[][][][] costs, int ... sumDimension) {
        int[][][][] copy = ArrayUtils.swallowCopy(costs);
        return new ComponentConstraint(ConstraintType.SOFTMULTICOSTREGULAR, (Object)new Object[]{vars.length, counters.length, sumDimension, pfunction, auto, copy}, (Variable[])ArrayUtils.append(vars, counters, penaltyVars, {globalPenalty}));
    }

    public static Constraint tree(TreeParametersObject param) {
        return new ComponentConstraint(ConstraintType.TREE, (Object)param, param.extractVariables());
    }

    public static Constraint equation(int val, IntegerVariable[] vars, int[] coeffs) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)new int[][]{coeffs, {val}}, (Variable[])vars);
    }

    public static Constraint equation(IntegerVariable z, IntegerVariable[] vars, int[] coeffs) {
        IntegerVariable[] v = new IntegerVariable[vars.length + 1];
        System.arraycopy(vars, 0, v, 0, vars.length);
        v[vars.length] = z;
        int[] c = new int[coeffs.length + 1];
        System.arraycopy(coeffs, 0, c, 0, coeffs.length);
        c[coeffs.length] = -1;
        return Choco.equation(0, v, c);
    }

    public static Constraint equation(String option, int val, IntegerVariable[] vars, int[] coeffs) {
        return option.equals("cp:bc") ? Choco.eq(val, Choco.scalar(coeffs, vars)) : Choco.equation(val, vars, coeffs);
    }

    public static Constraint equation(String option, IntegerVariable z, IntegerVariable[] vars, int[] coeffs) {
        return option.equals("cp:bc") ? Choco.eq((IntegerExpressionVariable)z, Choco.scalar(coeffs, vars)) : Choco.equation(z, vars, coeffs);
    }

    @Deprecated
    public static Constraint equation(IntegerVariable[] vars, int[] coeffs, int val) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)new int[][]{coeffs, {val}}, (Variable[])vars);
    }

    public static Constraint sameSign(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new ComponentConstraint(ConstraintType.SIGNOP, (Object)true, new Variable[]{n1, n2});
    }

    public static Constraint oppositeSign(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new ComponentConstraint(ConstraintType.SIGNOP, (Object)false, new Variable[]{n1, n2});
    }

    public static Constraint mod(IntegerVariable v0, IntegerVariable v1, int c) {
        return new ComponentConstraint(ConstraintType.MOD, null, (Variable[])new IntegerVariable[]{v0, v1, Choco.constant(c)});
    }

    @Deprecated
    public static Constraint reifiedIntConstraint(IntegerVariable binVar, Constraint cst) {
        Variable[] vars = ArrayUtils.append({binVar}, cst.getVariables());
        return new ComponentConstraintWithSubConstraints(ConstraintType.REIFIEDCONSTRAINT, vars, null, cst);
    }

    @Deprecated
    public static Constraint reifiedIntConstraint(IntegerVariable binVar, Constraint cst, Constraint oppCst) {
        return new ComponentConstraintWithSubConstraints(ConstraintType.REIFIEDCONSTRAINT, (Variable[])new IntegerVariable[]{binVar}, null, cst, oppCst);
    }

    public static Constraint reifiedConstraint(IntegerVariable binVar, Constraint cst) {
        Variable[] vars = ArrayUtils.append({binVar}, cst.getVariables());
        return new ComponentConstraintWithSubConstraints(ConstraintType.REIFIEDCONSTRAINT, vars, null, cst);
    }

    public static Constraint reifiedConstraint(IntegerVariable binVar, Constraint cst, Constraint oppCst) {
        return new ComponentConstraintWithSubConstraints(ConstraintType.REIFIEDCONSTRAINT, (Variable[])new IntegerVariable[]{binVar}, null, cst, oppCst);
    }

    public static Constraint clause(IntegerVariable[] positiveLiterals, IntegerVariable[] negativeLiterals) {
        Variable[] literals = ArrayUtils.append(positiveLiterals, negativeLiterals);
        return new ComponentConstraint(ConstraintType.CLAUSES, (Object)positiveLiterals.length, literals);
    }

    public static Constraint clause(String option, IntegerVariable[] positiveLiterals, IntegerVariable[] negativeLiterals) {
        Constraint c = Choco.clause(positiveLiterals, negativeLiterals);
        c.addOption(option);
        return c;
    }

    public static Constraint[] clauses(String option, ALogicTree tree) {
        Constraint[] cs = Choco.clauses(tree);
        for (int cl = 0; cl < cs.length; ++cl) {
            cs[cl].addOption(option);
        }
        return cs;
    }

    public static Constraint[] clauses(ALogicTree tree) {
        Constraint[] c;
        if (Singleton.TRUE.equals(tree = LogicTreeToolBox.toCNF(tree))) {
            LOGGER.warning("A \"TRUE\" constraint is build. Make sure, the scoped variables are correctly added to the model!");
            c = new Constraint[]{TRUE};
        } else if (Singleton.FALSE.equals(tree)) {
            LOGGER.warning("A \"FALSE\" constraint is build. Make sure, the scoped variables are correctly added to the model!");
            c = new Constraint[]{FALSE};
        } else {
            ALogicTree[] clauses = tree.is(ALogicTree.Operator.AND) ? tree.getChildren() : new ALogicTree[]{tree};
            c = new Constraint[clauses.length];
            for (int i = 0; i < clauses.length; ++i) {
                ALogicTree clause = clauses[i];
                Variable[] vars = clause.flattenBoolVar();
                c[i] = new ComponentConstraint(ConstraintType.CLAUSES, (Object)clause.getNbPositiveLiterals(), vars);
            }
        }
        return c;
    }

    public static Constraint or(IntegerVariable ... literals) {
        for (IntegerVariable lit : literals) {
            if (lit.isBoolean()) continue;
            throw new ModelException("OR constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.OR, null, (Variable[])literals);
    }

    public static Constraint reifiedOr(IntegerVariable binVar, IntegerVariable ... literals) {
        Variable[] vars;
        for (IntegerVariable integerVariable : vars = ArrayUtils.append({binVar}, literals)) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("reifiedOr constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.REIFIEDOR, null, vars);
    }

    public static Constraint and(IntegerVariable ... literals) {
        for (IntegerVariable lit : literals) {
            if (lit.isBoolean()) continue;
            throw new ModelException("AND constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.AND, null, (Variable[])literals);
    }

    public static Constraint reifiedAnd(IntegerVariable binVar, IntegerVariable ... literals) {
        Variable[] vars;
        for (IntegerVariable integerVariable : vars = ArrayUtils.append({binVar}, literals)) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("reifiedAnd constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.REIFIEDAND, null, vars);
    }

    public static Constraint nand(IntegerVariable ... literals) {
        for (IntegerVariable lit : literals) {
            if (lit.isBoolean()) continue;
            throw new ModelException("NAND constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.NAND, null, (Variable[])literals);
    }

    public static Constraint reifiedNand(IntegerVariable binVar, IntegerVariable ... literals) {
        Variable[] vars;
        for (IntegerVariable integerVariable : vars = ArrayUtils.append({binVar}, literals)) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("reifiedNand constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.REIFIEDNAND, null, vars);
    }

    public static Constraint nor(IntegerVariable ... literals) {
        for (IntegerVariable lit : literals) {
            if (lit.isBoolean()) continue;
            throw new ModelException("NOR constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.NOR, null, (Variable[])literals);
    }

    public static Constraint reifiedNor(IntegerVariable binVar, IntegerVariable ... literals) {
        Variable[] vars;
        for (IntegerVariable integerVariable : vars = ArrayUtils.append({binVar}, literals)) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("reifiedNor constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.REIFIEDNOR, null, vars);
    }

    public static Constraint reifiedNot(IntegerVariable binVar, IntegerVariable lit) {
        Variable[] vars;
        for (IntegerVariable integerVariable : vars = new IntegerVariable[]{binVar, lit}) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("xor constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.XOR, null, vars);
    }

    public static Constraint xor(IntegerVariable lit1, IntegerVariable lit2) {
        Variable[] lits;
        for (IntegerVariable integerVariable : lits = new IntegerVariable[]{lit1, lit2}) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("xor constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.XOR, null, lits);
    }

    public static Constraint reifiedXor(IntegerVariable binVar, IntegerVariable lit1, IntegerVariable lit2) {
        Variable[] vars;
        for (IntegerVariable integerVariable : vars = new IntegerVariable[]{binVar, lit1, lit2}) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("reifiedXor constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.REIFIEDXOR, null, vars);
    }

    public static Constraint xnor(IntegerVariable lit1, IntegerVariable lit2) {
        Variable[] lits;
        for (IntegerVariable integerVariable : lits = new IntegerVariable[]{lit1, lit2}) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("xnor constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.XNOR, null, lits);
    }

    public static Constraint reifiedXnor(IntegerVariable binVar, IntegerVariable lit1, IntegerVariable lit2) {
        Variable[] vars;
        for (IntegerVariable integerVariable : vars = new IntegerVariable[]{binVar, lit1, lit2}) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("reifiedXnor constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.REIFIEDXNOR, null, vars);
    }

    public static Constraint reifiedLeftImp(IntegerVariable binVar, IntegerVariable lit1, IntegerVariable lit2) {
        Variable[] vars;
        for (IntegerVariable integerVariable : vars = new IntegerVariable[]{binVar, lit2, lit1}) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("reifiedLeftImpl constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.REIFIEDIMPLICATION, null, vars);
    }

    public static Constraint reifiedRightImp(IntegerVariable binVar, IntegerVariable lit1, IntegerVariable lit2) {
        Variable[] vars;
        for (IntegerVariable integerVariable : vars = new IntegerVariable[]{binVar, lit1, lit2}) {
            if (integerVariable.isBoolean()) continue;
            throw new ModelException("reifiedRightImp constraint must be used with boolean variables");
        }
        return new ComponentConstraint(ConstraintType.REIFIEDIMPLICATION, null, vars);
    }

    public static IntegerExpressionVariable mult(IntegerExpressionVariable t1, int a) {
        return new IntegerExpressionVariable(null, Operator.MULT, new IntegerExpressionVariable[]{t1, Choco.constant(a)});
    }

    public static IntegerExpressionVariable mult(int a, IntegerExpressionVariable t1) {
        return new IntegerExpressionVariable(null, Operator.MULT, new IntegerExpressionVariable[]{t1, Choco.constant(a)});
    }

    public static IntegerExpressionVariable mult(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MULT, new IntegerExpressionVariable[]{n1, n2});
    }

    public static IntegerExpressionVariable plus(IntegerExpressionVariable t1, IntegerExpressionVariable t2) {
        return new IntegerExpressionVariable(null, Operator.PLUS, new IntegerExpressionVariable[]{t1, t2});
    }

    public static IntegerExpressionVariable plus(IntegerExpressionVariable t, int c) {
        return Choco.plus(t, (IntegerExpressionVariable)Choco.constant(c));
    }

    public static IntegerExpressionVariable plus(int c, IntegerExpressionVariable t) {
        return Choco.plus(t, (IntegerExpressionVariable)Choco.constant(c));
    }

    public static IntegerExpressionVariable minus(IntegerExpressionVariable t1, IntegerExpressionVariable t2) {
        return new IntegerExpressionVariable(null, Operator.MINUS, new IntegerExpressionVariable[]{t1, t2});
    }

    public static IntegerExpressionVariable minus(IntegerExpressionVariable t, int c) {
        return new IntegerExpressionVariable(null, Operator.MINUS, new IntegerExpressionVariable[]{t, Choco.constant(c)});
    }

    public static IntegerExpressionVariable minus(int c, IntegerExpressionVariable t) {
        return new IntegerExpressionVariable(null, Operator.MINUS, new IntegerExpressionVariable[]{Choco.constant(c), t});
    }

    public static IntegerExpressionVariable scalar(int[] lc, IntegerVariable[] lv) {
        if (lc.length != lv.length) {
            throw new ModelException("scalar: parameters length are differents");
        }
        IntegerExpressionVariable[] tmp = new IntegerVariable[lc.length + lv.length];
        for (int i = 0; i < lc.length; ++i) {
            tmp[i] = Choco.constant(lc[i]);
        }
        System.arraycopy(lv, 0, tmp, lc.length, lv.length);
        return new IntegerExpressionVariable(null, Operator.SCALAR, tmp);
    }

    public static IntegerExpressionVariable scalar(IntegerVariable[] lv, int[] lc) {
        return Choco.scalar(lc, lv);
    }

    public static IntegerExpressionVariable sum(IntegerExpressionVariable ... lv) {
        return new IntegerExpressionVariable(null, Operator.SUM, lv);
    }

    public static IntegerExpressionVariable abs(IntegerExpressionVariable n) {
        return new IntegerExpressionVariable(null, Operator.ABS, n);
    }

    public static IntegerExpressionVariable div(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.DIV, new IntegerExpressionVariable[]{n1, n2});
    }

    public static IntegerExpressionVariable div(IntegerExpressionVariable n1, int n2) {
        return new IntegerExpressionVariable(null, Operator.DIV, new IntegerExpressionVariable[]{n1, Choco.constant(n2)});
    }

    public static IntegerExpressionVariable div(int n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.DIV, new IntegerExpressionVariable[]{Choco.constant(n1), n2});
    }

    public static IntegerExpressionVariable max(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MAX, new IntegerExpressionVariable[]{n1, n2});
    }

    public static IntegerExpressionVariable max(int n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MAX, new IntegerExpressionVariable[]{Choco.constant(n1), n2});
    }

    public static IntegerExpressionVariable max(IntegerExpressionVariable n1, int n2) {
        return new IntegerExpressionVariable(null, Operator.MAX, new IntegerExpressionVariable[]{n1, Choco.constant(n2)});
    }

    public static IntegerExpressionVariable max(IntegerExpressionVariable[] n1) {
        return new IntegerExpressionVariable(null, Operator.MAX, n1);
    }

    public static IntegerExpressionVariable min(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MIN, new IntegerExpressionVariable[]{n1, n2});
    }

    public static IntegerExpressionVariable min(int n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MIN, new IntegerExpressionVariable[]{Choco.constant(n1), n2});
    }

    public static IntegerExpressionVariable min(IntegerExpressionVariable n1, int n2) {
        return new IntegerExpressionVariable(null, Operator.MIN, new IntegerExpressionVariable[]{n1, Choco.constant(n2)});
    }

    public static IntegerExpressionVariable min(IntegerExpressionVariable[] n1) {
        return new IntegerExpressionVariable(null, Operator.MIN, n1);
    }

    public static IntegerExpressionVariable mod(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MOD, new IntegerExpressionVariable[]{n1, n2});
    }

    public static IntegerExpressionVariable mod(int n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MOD, new IntegerExpressionVariable[]{Choco.constant(n1), n2});
    }

    public static IntegerExpressionVariable mod(IntegerExpressionVariable n1, int n2) {
        return new IntegerExpressionVariable(null, Operator.MOD, new IntegerExpressionVariable[]{n1, Choco.constant(n2)});
    }

    public static IntegerExpressionVariable neg(IntegerExpressionVariable n) {
        return new IntegerExpressionVariable(null, Operator.NEG, n);
    }

    public static IntegerExpressionVariable power(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.POWER, new IntegerExpressionVariable[]{n1, n2});
    }

    public static IntegerExpressionVariable power(int n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.POWER, new IntegerExpressionVariable[]{Choco.constant(n1), n2});
    }

    public static IntegerExpressionVariable power(IntegerExpressionVariable n1, int n2) {
        return new IntegerExpressionVariable(null, Operator.POWER, new IntegerExpressionVariable[]{n1, Choco.constant(n2)});
    }

    public static IntegerExpressionVariable ifThenElse(Constraint n1, IntegerExpressionVariable n2, IntegerExpressionVariable n3) {
        return new MetaIntegerExpressionVariable(Operator.IFTHENELSE, n1, n2, n3);
    }

    public static RealExpressionVariable mult(double a, RealExpressionVariable x) {
        return new RealExpressionVariable(null, Operator.MULT, new RealExpressionVariable[]{Choco.constant(a), x});
    }

    public static RealExpressionVariable mult(RealExpressionVariable x, double a) {
        return new RealExpressionVariable(null, Operator.MULT, new RealExpressionVariable[]{Choco.constant(a), x});
    }

    public static RealExpressionVariable mult(RealExpressionVariable x, RealExpressionVariable y) {
        return new RealExpressionVariable(null, Operator.MULT, new RealExpressionVariable[]{x, y});
    }

    public static RealExpressionVariable plus(RealExpressionVariable t1, RealExpressionVariable t2) {
        return new RealExpressionVariable(null, Operator.PLUS, new RealExpressionVariable[]{t1, t2});
    }

    public static RealExpressionVariable plus(RealExpressionVariable t, double c) {
        return Choco.plus(t, (RealExpressionVariable)Choco.constant(c));
    }

    public static RealExpressionVariable plus(double c, RealExpressionVariable t) {
        return Choco.plus(t, (RealExpressionVariable)Choco.constant(c));
    }

    public static RealExpressionVariable minus(RealExpressionVariable t1, RealExpressionVariable t2) {
        return new RealExpressionVariable(null, Operator.MINUS, new RealExpressionVariable[]{t1, t2});
    }

    public static RealExpressionVariable minus(RealExpressionVariable t, double c) {
        return new RealExpressionVariable(null, Operator.MINUS, new RealExpressionVariable[]{t, Choco.constant(c)});
    }

    public static RealExpressionVariable minus(double c, RealExpressionVariable t) {
        return new RealExpressionVariable(null, Operator.MINUS, new RealExpressionVariable[]{Choco.constant(c), t});
    }

    public static RealExpressionVariable power(RealExpressionVariable exp, int power) {
        return new RealExpressionVariable(null, Operator.POWER, new RealExpressionVariable[]{exp, Choco.constant((double)power)});
    }

    public static RealExpressionVariable cos(RealExpressionVariable exp) {
        return new RealExpressionVariable(null, Operator.COS, exp);
    }

    public static RealExpressionVariable sin(RealExpressionVariable exp) {
        return new RealExpressionVariable(null, Operator.SIN, exp);
    }

    public static Constraint and(Constraint ... n) {
        if (n.length == 0) {
            return TRUE;
        }
        if (n.length == 1) {
            return n[0];
        }
        return new MetaConstraint(ConstraintType.AND, n);
    }

    public static Constraint ifOnlyIf(Constraint n1, Constraint n2) {
        return new MetaConstraint(ConstraintType.IFONLYIF, new Constraint[]{n1, n2});
    }

    public static Constraint ifThenElse(Constraint n1, Constraint n2, Constraint n3) {
        return new MetaConstraint(ConstraintType.IFTHENELSE, new Constraint[]{n1, n2, n3});
    }

    public static Constraint implies(Constraint n1, Constraint n2) {
        return new MetaConstraint(ConstraintType.IMPLIES, new Constraint[]{n1, n2});
    }

    public static Constraint nand(Constraint ... n) {
        return new MetaConstraint(ConstraintType.NAND, n);
    }

    public static Constraint not(Constraint n) {
        return new MetaConstraint(ConstraintType.NOT, new Constraint[]{n});
    }

    public static Constraint nor(Constraint ... n) {
        return new MetaConstraint(ConstraintType.NOR, n);
    }

    public static Constraint or(Constraint ... n) {
        if (n.length == 0) {
            return TRUE;
        }
        if (n.length == 1) {
            return n[0];
        }
        return new MetaConstraint(ConstraintType.OR, n);
    }

    protected static Constraint timeWindow(IntegerVariable var, int min, int max) {
        return Choco.member(var, min, max);
    }

    public static Constraint endsBetween(TaskVariable t, int min, int max) {
        return Choco.timeWindow(t.end(), min, max);
    }

    public static Constraint startsBetween(TaskVariable t, int min, int max) {
        return Choco.timeWindow(t.start(), min, max);
    }

    public static Constraint endsAt(TaskVariable t, int time) {
        return Choco.eq((IntegerExpressionVariable)t.end(), time);
    }

    public static Constraint startsAt(TaskVariable t, int time) {
        return Choco.eq((IntegerExpressionVariable)t.start(), time);
    }

    public static Constraint endsBefore(TaskVariable t, int max) {
        return Choco.leq((IntegerExpressionVariable)t.end(), max);
    }

    public static Constraint startsBefore(TaskVariable t, int max) {
        return Choco.leq((IntegerExpressionVariable)t.start(), max);
    }

    public static Constraint endsAfter(TaskVariable t, int min) {
        return Choco.geq((IntegerExpressionVariable)t.end(), min);
    }

    public static Constraint startsAfter(TaskVariable t, int min) {
        return Choco.geq((IntegerExpressionVariable)t.start(), min);
    }

    public static Constraint startsBeforeBegin(TaskVariable t1, TaskVariable t2, int delta) {
        return new MetaTaskConstraint(new TaskVariable[]{t1, t2}, Choco.leq(Choco.plus((IntegerExpressionVariable)t1.start(), delta), (IntegerExpressionVariable)t2.start()));
    }

    public static Constraint startsBeforeBegin(TaskVariable t1, TaskVariable t2) {
        return Choco.startsBeforeBegin(t1, t2, 0);
    }

    public static Constraint startsAfterBegin(TaskVariable t1, TaskVariable t2, int delta) {
        return Choco.startsBeforeBegin(t2, t1, delta);
    }

    public static Constraint startsAfterBegin(TaskVariable t1, TaskVariable t2) {
        return Choco.startsAfterBegin(t1, t2, 0);
    }

    public static Constraint startsAfterEnd(TaskVariable t1, TaskVariable t2, int delta) {
        return Choco.endsBeforeBegin(t2, t1, delta);
    }

    public static Constraint startsAfterEnd(TaskVariable t1, TaskVariable t2) {
        return Choco.startsAfterEnd(t1, t2, 0);
    }

    public static Constraint endsBeforeBegin(TaskVariable t1, TaskVariable t2, int delta) {
        return Choco.precedenceDisjoint(t1, t2, ONE, delta, 0);
    }

    public static Constraint endsBeforeBegin(TaskVariable t1, TaskVariable t2) {
        return Choco.endsBeforeBegin(t1, t2, 0);
    }

    public static Constraint startsBeforeEnd(TaskVariable t1, TaskVariable t2, int delta) {
        return new MetaTaskConstraint(new TaskVariable[]{t1, t2}, Choco.leq(Choco.plus((IntegerExpressionVariable)t1.start(), delta), (IntegerExpressionVariable)t2.end()));
    }

    public static Constraint startsBeforeEnd(TaskVariable t1, TaskVariable t2) {
        return Choco.startsBeforeEnd(t1, t2, 0);
    }

    public static Constraint endsAfterBegin(TaskVariable t1, TaskVariable t2, int delta) {
        return new MetaTaskConstraint(new TaskVariable[]{t1, t2}, Choco.leq(Choco.plus((IntegerExpressionVariable)t1.end(), delta), (IntegerExpressionVariable)t2.start()));
    }

    public static Constraint endsAfterBegin(TaskVariable t1, TaskVariable t2) {
        return Choco.endsAfterBegin(t1, t2, 0);
    }

    public static Constraint endsBeforeEnd(TaskVariable t1, TaskVariable t2, int delta) {
        return new MetaTaskConstraint(new TaskVariable[]{t1, t2}, Choco.leq((IntegerExpressionVariable)t1.end(), Choco.plus((IntegerExpressionVariable)t2.end(), delta)));
    }

    public static Constraint endsBeforeEnd(TaskVariable t1, TaskVariable t2) {
        return Choco.endsBeforeEnd(t1, t2, 0);
    }

    public static Constraint endsAfterEnd(TaskVariable t1, TaskVariable t2, int delta) {
        return Choco.endsBeforeEnd(t2, t1, delta);
    }

    public static Constraint endsAfterEnd(TaskVariable t1, TaskVariable t2) {
        return Choco.endsAfterEnd(t1, t2, 0);
    }
}

