/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints;

import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.common.util.tools.IteratorUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.ModelException;
import choco.kernel.model.ModelObject;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintManager;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.ExpressionManager;
import choco.kernel.model.constraints.ManagerFactory;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import gnu.trove.THashSet;
import java.util.Properties;

public abstract class AbstractConstraint
extends ModelObject
implements Constraint,
Comparable {
    private ConstraintType type;
    protected String manager;

    public AbstractConstraint(ConstraintType type, Variable[] variables) {
        super(variables, true);
        this.type = type;
    }

    public AbstractConstraint(String consMan, Variable[] variables) {
        this(ConstraintType.NONE, variables);
        this.manager = consMan;
    }

    void variablesPrettyPrint(StringBuilder buffer) {
        buffer.append(StringUtils.pretty(this.getVariableIterator()));
    }

    public Object getParameters() {
        return null;
    }

    @Override
    public String getName() {
        return this.type == null || this.type.equals((Object)ConstraintType.NONE) ? this.manager : this.type.getName();
    }

    @Override
    public String pretty() {
        StringBuilder st = new StringBuilder(this.getName());
        st.append(" ( ");
        this.variablesPrettyPrint(st);
        st.append(" )");
        return st.toString();
    }

    @Override
    public final ConstraintType getConstraintType() {
        return this.type;
    }

    public IntegerVariable[] getIntVariableScope() {
        DisposableIterator<Variable> itvs = this.getVariableIterator();
        THashSet<IntegerVariable> vs = new THashSet<IntegerVariable>();
        while (itvs.hasNext()) {
            Variable v1 = (Variable)itvs.next();
            if (v1.getVariableType() == VariableType.INTEGER && !vs.contains(v1)) {
                vs.add((IntegerVariable)v1);
                continue;
            }
            if (!v1.getVariableType().equals((Object)VariableType.INTEGER_EXPRESSION)) continue;
            THashSet<Variable> tmp = AbstractConstraint.extractEveryvariables((IntegerExpressionVariable)v1);
            for (Variable aTmp : tmp) {
                if (aTmp.getVariableType() != VariableType.INTEGER || vs.contains(aTmp)) continue;
                vs.add((IntegerVariable)aTmp);
            }
        }
        IntegerVariable[] vars = new IntegerVariable[vs.size()];
        int cpt = 0;
        for (IntegerVariable v : vs) {
            vars[cpt++] = v;
        }
        return vars;
    }

    private static THashSet<Variable> extractEveryvariables(IntegerExpressionVariable iev) {
        THashSet<Variable> vs = new THashSet<Variable>();
        if (iev.getVariableType().equals((Object)VariableType.INTEGER)) {
            if (!vs.contains(iev)) {
                vs.add(iev);
            }
        } else if (iev.getVariableType().equals((Object)VariableType.INTEGER_EXPRESSION)) {
            Variable[] tmp = iev.extractVariables();
            DisposableIterator<Variable> it = IteratorUtils.iterator(tmp);
            while (it.hasNext()) {
                vs.addAll(AbstractConstraint.extractEveryvariables((IntegerExpressionVariable)it.next()));
            }
        }
        return vs;
    }

    @Override
    public int[] getFavoriteDomains() {
        return new int[]{0, 2, 4, 3, 1};
    }

    public ConstraintManager getConstraintManager() {
        return ManagerFactory.loadConstraintManager(this.getManager());
    }

    @Override
    public ExpressionManager getExpressionManager() {
        return ManagerFactory.loadExpressionManager(this.getManager());
    }

    public final String getManager() {
        return this.manager;
    }

    @Override
    public void findManager(Properties propertiesFile) {
        if (this.manager == null) {
            if (this.type.property == null) {
                throw new ModelException("Empty property, can not read it!");
            }
            this.manager = propertiesFile.getProperty(this.type.property);
            if (this.manager == null) {
                throw new ModelException("No property found for " + this.type.property + " in application.properties");
            }
        }
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return 1;
    }
}

