/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.inference.trace.TracesListener;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TracesReader {
    private List<TracesListener> listeners = new ArrayList<TracesListener>();

    public void addTracesListener(TracesListener tracesListener) {
        this.listeners.add(tracesListener);
    }

    public void removeTracesListener(TracesListener tracesListener) {
        this.listeners.remove(tracesListener);
    }

    public void readTraces(Reader reader) throws TraceException, IOException {
        LogFileTraces.TrimLineReader trimLineReader = new LogFileTraces.TrimLineReader(reader);
        StringTokenizer stringTokenizer = trimLineReader.tokenizeLine();
        while (!stringTokenizer.hasMoreTokens()) {
            stringTokenizer = trimLineReader.tokenizeLine();
        }
        String string = stringTokenizer.nextToken();
        while (string.startsWith("[") || string.startsWith("#")) {
            stringTokenizer = trimLineReader.tokenizeLine();
            while (!stringTokenizer.hasMoreTokens()) {
                stringTokenizer = trimLineReader.tokenizeLine();
            }
            string = stringTokenizer.nextToken();
        }
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        for (TracesListener object : this.listeners) {
            object.traceNames(stringArray);
        }
        boolean bl = true;
        stringTokenizer = trimLineReader.tokenizeLine();
        while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = 0;
            try {
                try {
                    n = (int)Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TraceException("Unable to parse state number in column 1 (Line " + trimLineReader.getLineNumber() + ")");
                }
                if (bl) {
                    if (n == 1) {
                        n = 0;
                    }
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new TraceException("State " + n + ":Expected real value in column " + trimLineReader.getLineNumber());
            }
            double[] numberFormatException = new double[stringArray.length];
            for (int i = 0; i < numberFormatException.length; ++i) {
                if (stringTokenizer.hasMoreTokens()) {
                    try {
                        numberFormatException[i] = Double.parseDouble(stringTokenizer.nextToken());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new TraceException("State " + n + ": Expected real value in column " + (i + 1) + " (Line " + trimLineReader.getLineNumber() + ")");
                    }
                }
                throw new TraceException("State " + n + ": missing values at line " + trimLineReader.getLineNumber());
            }
            for (TracesListener tracesListener : this.listeners) {
                tracesListener.traceRow(n, numberFormatException);
            }
            stringTokenizer = trimLineReader.tokenizeLine();
        }
    }
}

