/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.special;

import ec.tstoolkit.maths.special.IRealFunction;

public class DirichletKernel
implements IRealFunction {
    private static final double TWOPI = Math.PI * 2;
    private static final double EPS = 1.0E-9;
    private final int n_;
    private final int m_;
    private final double mc_;

    private boolean mpi(double x) {
        double y = x / Math.PI;
        return Math.abs(y - (double)Math.round(y)) < 1.0E-9;
    }

    public DirichletKernel(int n) {
        this.n_ = n;
        this.m_ = 2 * n + 1;
        this.mc_ = (double)this.m_ / (Math.PI * 2);
    }

    public int getN() {
        return this.n_;
    }

    @Override
    public double fn(double x) {
        double x2 = x * 0.5;
        if (this.mpi(x2)) {
            return this.mc_;
        }
        return Math.sin((double)this.m_ * x2) / Math.sin(x2) / (Math.PI * 2);
    }
}

